.TH ETEX 1 "27 December 1997" "Web2C @VERSION@"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF M\s-2ETAFONT\s0
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP\" for troff
.el .ds OX TeX\" for nroff
.\" the same but obliqued
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.if t .ds AX \fRA\\h'-0.1667m'\\v'0.20v'M\\v'-0.20v'\\h'-0.125m'S\fP\*(TX
.if n .ds AX AmSTeX
.if t .ds AY \fRA\\h'-0.1667m'\\v'0.20v'M\\v'-0.20v'\\h'-0.125m'S\fP\*(LX
.if n .ds AY AmSLaTeX
.\"=====================================================================
.SH NAME
etex, einitex, evirtex \- extended TeX
.SH SYNOPSIS
.B etex
.RI [ options ]
.RI [ commands ]
.\"=====================================================================
.SH DESCRIPTION
This manual page is not meant to be exhaustive.  The complete
documentation for this version of \*(TX can be found in the info file
or manual
.IR "Web2C: A TeX implementation" .
.PP
e-\*(TX is the first concrete result of an international research &
development project, the NTS Project, which was established under the
aegis of DANTE e.V. during 1992. The aims of the project are to
perpetuate and develop the spirit and philosophy of \*(TX, whilst
respecting Knuth's wish that \*(TX should remain frozen.
.PP
e-\*(TX can be used in two different modes: in
.I compatibility mode
it is supposed to be completely interchangable with standard \*(TX.
In
.I extended mode
several new primitives are added that facilitate (among other things)
bidirectional typesetting.
.PP
An extended mode format is generated by prefixing the name of the
source file for the format with an asterisk (*).  Such formats are
often prefixed with an `e', hence
.B etex
as the extended version of
.B tex
and
.B elatex
as the extended version of
.BR latex .
However,
.B eplain
is an exception to this rule.
.PP
The
.B einitex
and
.B evirtex
commands are e-\*(TX's analogues to the
.B initex
and
.B virtex
commands.  In this installation, they are symlinks to the
.B etex
executable.
.PP
e-\*(TX's handling of its command-line arguments is similar to that of
\*(TX.
.\"=====================================================================
.SH OPTIONS
This version of e-\*(TX understands the following command line options.
.TP
.BI --efmt \ format
.rb
Use
.I format
as the name of the format to be used, instead of the name by which
e-\*(TX was called or a
.I %&
line.
.TP
.B --help
.rb
Print help message and exit.
.TP
.B --ini
.rb
Be
.BR einitex ,
for dumping formats; this is implicitly true if the program is called
as
.BR einitex .
.TP
.BI --interaction \ mode
.rb
Sets the interaction mode.  The mode can be one of
.IR batchmode ,
.IR nonstopmode ,
.IR scrollmode ,
and
.IR errorstopmode .
The meaning of these modes is the same as that of the corresponding
\ecommands.
.TP
.B --ipc
.rb
Send DVI output to a socket as well as the usual output file.  Whether
this option is available is the choice of the installer.
.TP
.B --ipc-start
.rb
As
.BR --ipc ,
and starts the server at the other end as well.  Whether this option
is available is the choice of the installer.
.TP
.BI --kpathsea-debug \ bitmask
.rb
Sets path searching debugging flags according to the bitmask.  See the
.I Kpathsea
manual for details.
.TP
.BI --maketex \ fmt
.rb
Enable
.RI mktex fmt ,
where
.I fmt
must be one of
.I tex
or
.IR tfm .
.TP
.B --mltex
.rb
Enable ML\*(TX extensions.
.TP
.BI --no-maketex \ fmt
.rb
Disable
.RI mktex fmt ,
where
.I fmt
must be one of
.I tex
or
.IR tfm .
.TP
.BI --output-comment \ string
.rb
Use
.I string
for the DVI file comment instead of the date.
.TP
.BI --progname \ name
.rb
Pretend to be program
.IR name .
This affects both the format used and the search paths.
.TP
.B --shell-escape
.rb
Enable the
.BI \ewrite18{ command }
construct.  The
.I command
can be any Bourne shell command.  This construct is normally
disallowed for security reasons.
.TP
.B --version
.rb
Print version information and exit.
.\"=====================================================================
.SH ENVIRONMENT
See the Kpathsearch library documentation (the `Path specifications'
node) for precise details of how the environment variables are used.
The
.B kpsewhich
utility can be used to query the values of the variables.
.PP
One caveat: In most e-\*(TX formats, you cannot use ~ in a filename you
give directly to e-\*(TX, because ~ is an active character, and hence is
expanded, not taken as part of the filename.  Other programs, such as
\*(MF, do not have this problem.
.PP
.TP
TEXMFOUTPUT
Normally, e-\*(TX puts its output files in the current directory.  If
any output file cannot be opened there, it tries to open it in the
directory specified in the environment variable TEXMFOUTPUT.
There is no default value for that variable.  For example, if you say
.I tex paper
and the current directory is not writable, if TEXMFOUTPUT has
the value
.IR /tmp ,
e-\*(TX attempts to create
.I /tmp/paper.log
(and
.IR /tmp/paper.dvi ,
if any output is produced.)
.TP
TEXINPUTS
Search path for
.I \einput
and
.I \eopenin
files.
This should probably start with ``.'', so
that user files are found before system files.
.TP
TEXFONTS
Search path for font metric
.RI ( .tfm )
files.
.TP
TEXFORMATS
Search path for format files.
.TP
TEXPOOL
search path for
.B einitex
internal strings.
.TP
TEXEDIT
Command template for switching to editor.  The default, usually
.BR vi ,
is set when e-\*(TX is compiled.
.\"=====================================================================
.SH FILES
The location of the files mentioned below varies from system to
system.  Use the
.B kpsewhich
utility to find their locations.
.TP
.I etex.pool
Encoded text of e-\*(TX's messages.
.TP
.I texfonts.map
Filename mapping definitions.
.TP
.I *.tfm
Metric files for e-\*(TX's fonts.
.TP
.I *.efmt
Predigested e-\*(TX format (.\|efmt) files.
.br
.\"=====================================================================
.SH BUGS
This version of e-\*(TX fails to trap arithmetic overflow when
dimensions are added or subtracted.  Cases where this occurs are rare,
but when it does the generated
.I DVI
file will be invalid.
.\"=====================================================================
.SH "SEE ALSO"
.BR tex (1),
.BR mf (1),
.BR undump (1).
