%
% This file is part of the Omega project, which
% is based on the web2c distribution of TeX.
% 
% Copyright (c) 1995--1998 John Plaice and Yannis Haralambous
% 
%---------------------------------------
@x [3] m.25 l.767 - Omega Input Translation
initialization.  We shall define a word file later; but it will be possible
for us to specify simple operations on word files before they are defined.
@y
initialization.  We shall define a word file later; but it will be possible
for us to specify simple operations on word files before they are defined.

@d this_input=0
@d default_input=1
@d default_ascii_input=1
@d default_ebcdic_input=2
@d default_unicode_input=3
@d default_unicode_LE_input=4
@d ascii_mode=1
@d ebcdic_mode=2
@d unicode_mode=3
@d unicode_LE_mode=3

@z
%---------------------------------------
@x [3] m.25 l.772 - Omega Input Translation
@!alpha_file=packed file of text_char; {files that contain textual data}
@y
@!alpha_file=packed file of text_char; {files that contain textual data}
@z
%---------------------------------------
@x [3] m.30 l.890 - Omega Input Translation
@!max_buf_stack:0..buf_size; {largest index used in |buffer|}
@y
@!max_buf_stack:0..buf_size; {largest index used in |buffer|}
@!term_in_mode:halfword;
@!term_in_translation:halfword;
@z
%---------------------------------------
%@x [3] m.37 l.1065 - Omega Input Translation
%  if not input_ln(term_in,true) then {this shouldn't happen}
%@y
%  if not new_input_ln(term_in,term_in_mode,term_in_translation,true)
%then {this shouldn't happen}
%@z
%---------------------------------------
@x [5] m.71 l.1694 - Omega Input Translation
if not input_ln(term_in,true) then fatal_error("End of file on the terminal!");
@y
if not new_input_ln(term_in,term_in_mode,term_in_translation,true)
then fatal_error("End of file on the terminal!");
@z
%---------------------------------------
@x [15] m.209 l.4170 - Omega Input Translation
@d max_command=ocp_trace_level
   {the largest command code seen at |big_switch|}
@y
@d no_input_translation=ocp_trace_level+1
@d input_translation=no_input_translation+1 {ocp}
@d no_input_mode=input_translation+1 {|tex| input mode}
@d input_mode=no_input_mode+1 {|ascii|, |ebcdic| or |unicode| or |unicodeLE|}
@d max_command=input_mode
  {the largest command code seen at |big_switch|}
@z
%---------------------------------------
@x [17] m.230 l.4722 - Omega Input Translation
@d toks_base=ocp_active_base+max_active_ocp_lists
   {table of |number_regs| token list registers}
@y
@d ocp_input_ascii_translation_base=ocp_active_base+max_active_ocp_lists
@d ocp_input_ebcdic_translation_base=ocp_input_ascii_translation_base+1
@d ocp_input_unicode_translation_base=ocp_input_ascii_translation_base+2
@d ocp_input_unicode_LE_translation_base=ocp_input_ascii_translation_base+3
@d ocp_input_mode_base=ocp_input_ascii_translation_base+4
@d toks_base=ocp_input_ascii_translation_base+5
@z
%---------------------------------------
@x [22] m.304 l.6535 - Omega Input Translation
@!input_file : array[1..max_in_open] of alpha_file;
@y
@!input_file : array[1..max_in_open] of alpha_file;
@!input_file_mode : array[1..max_in_open] of halfword;
@!input_file_translation : array[1..max_in_open] of halfword;
@z
%---------------------------------------
@x [23] m.331 l.7066 - Omega Input Translation
param_ptr:=0; max_param_stack:=0;
@y
param_ptr:=0; max_param_stack:=0;
geq_define(ocp_input_mode_base,data,1);
term_in_mode:=equiv(ocp_input_mode_base);
if term_in_mode>0
then term_in_translation:=
     equiv(ocp_input_ascii_translation_base+term_in_mode-1);
@z
%---------------------------------------
@x [24] m.362 l.7066 - Omega Input Translation
  begin if input_ln(cur_file,true) then {not end of file}
@y
  begin if new_input_ln(cur_file,input_file_mode[index],
           input_file_translation[index],true) then {not end of file}
@z
%---------------------------------------
@x [27] m.480 l.9411 - Omega Input Translation
@!read_file:array[0..15] of alpha_file; {used for \.{\\read}}
@y
@!read_file:array[0..15] of alpha_file; {used for \.{\\read}}
@!read_file_mode:array[0..15] of halfword;
@!read_file_translation:array[0..15] of halfword;
@z
%---------------------------------------
@x [27] m.485 l.9475 - Omega Input Translation
@<Input the first line of |read_file[m]|@>=
if input_ln(read_file[m],false) then read_open[m]:=normal
else  begin a_close(read_file[m]); read_open[m]:=closed;
  end
@y
@<Input the first line of |read_file[m]|@>=
begin read_file_mode[m]:=
  get_file_mode(read_file[m], equiv(ocp_input_mode_base));
if read_file_mode[m]>0
then read_file_translation[m]:=
     equiv(ocp_input_ascii_translation_base+read_file_mode[m]-1);
if new_input_ln(read_file[m],read_file_mode[m],
   read_file_translation[m],false) then read_open[m]:=normal
else  begin a_close(read_file[m]); read_open[m]:=closed;
  end
end
@z
%---------------------------------------
@x [27] m.486 l.9484 - Omega Input Translation
begin if not input_ln(read_file[m],true) then
  begin a_close(read_file[m]); read_open[m]:=closed;
@y
begin if not new_input_ln(read_file[m],
read_file_mode[m],read_file_translation[m],true) then
  begin a_close(read_file[m]); read_open[m]:=closed;
@z
%---------------------------------------
@x [29] m.538 l.10371 - Omega Input Translation
begin line:=1;
if input_ln(cur_file,false) then do_nothing;
@y
begin line:=1;
input_file_mode[index]:=
  get_file_mode(cur_file, equiv(ocp_input_mode_base));
if input_file_mode[index]>0
then input_file_translation[index]:=
     equiv(ocp_input_ascii_translation_base+input_file_mode[index]-1);
if new_input_ln(cur_file,input_file_mode[index],
   input_file_translation[index],false) then do_nothing;
@z
%---------------------------------------
@x [49] m.1210 l.22629 - Omega Input Translation
any_mode(ocp_trace_level) : prefixed_command;
@y
any_mode(ocp_trace_level) : prefixed_command;
any_mode(no_input_translation) : do_no_input_translation;
any_mode(input_translation) : do_input_translation;
any_mode(no_input_mode) : do_no_input_mode;
any_mode(input_mode) : do_input_mode;
@z
%---------------------------------------
@x
@* \[54] $\Omega$ changes.

@y
@* \[54] $\Omega$ changes.

@ Here we do the main work required for reading and interpreting
  $\Omega$ Input Translation Processes.

@ @<Put each...@>=
primitive("noDefaultAsciiInputTranslation",
          no_input_translation, default_ascii_input);
primitive("noDefaultEbcdicInputTranslation",
          no_input_translation, default_ebcdic_input);
primitive("noDefaultUnicodeInputTranslation",
          no_input_translation, default_unicode_input);
primitive("noDefaultUnicodeLEInputTranslation",
          no_input_translation, default_unicode_LE_input);
primitive("noInputTranslation", no_input_translation, this_input);
primitive("defaultAsciiInputTranslation",
          input_translation, default_ascii_input);
primitive("defaultEbcdicInputTranslation",
          input_translation, default_ebcdic_input);
primitive("defaultUnicodeInputTranslation",
          input_translation, default_unicode_input);
primitive("defaultUnicodeLEInputTranslation",
          input_translation, default_unicode_LE_input);
primitive("inputTranslation", input_translation, this_input);
primitive("noDefaultInputMode", no_input_mode, default_input);
primitive("noInputMode", no_input_mode, this_input);
primitive("defaultInputMode", input_mode, default_input);
primitive("inputMode", input_mode, this_input);
geq_define(ocp_input_ascii_translation_base, data, 0);
geq_define(ocp_input_ebcdic_translation_base, data, 0);
geq_define(ocp_input_unicode_translation_base, data, 0);
geq_define(ocp_input_unicode_LE_translation_base, data, 0);
geq_define(ocp_input_mode_base, data, 0);

@ @<Cases of |print_cmd_chr|...@>=
no_input_translation: if chr_code=default_ascii_input
                      then print_esc("noDefaultAsciiInputTranslation")
                      else if chr_code=default_ebcdic_input
                      then print_esc("noDefaultEbcdicInputTranslation")
                      else if chr_code=default_unicode_input
                      then print_esc("noDefaultUnicodeInputTranslation")
                      else if chr_code=default_unicode_LE_input
                      then print_esc("noDefaultUnicodeLEInputTranslation")
                      else print_esc("noInputTranslation");
input_translation:    if chr_code=default_ascii_input
                      then print_esc("defaultAsciiInputTranslation")
                      else if chr_code=default_ebcdic_input
                      then print_esc("defaultEbcdicInputTranslation")
                      else if chr_code=default_unicode_input
                      then print_esc("defaultUnicodeInputTranslation")
                      else if chr_code=default_unicode_LE_input
                      then print_esc("defaultUnicodeLEInputTranslation")
                      else print_esc("inputTranslation");
no_input_mode:        if chr_code>=default_input
                      then print_esc("noDefaultInputMode")
                      else print_esc("noInputMode");
input_mode:           if chr_code>=default_input
                      then print_esc("defaultInputMode")
                      else print_esc("inputMode");

@ @<Declare subprocedures for |prefixed_command|@>=
procedure set_the_value(command, the_default, m: halfword);
begin
if the_default>=default_input then
   if command=input_mode
   then geq_define(ocp_input_mode_base,data,m)
   else if the_default=default_ascii_input
   then geq_define(ocp_input_ascii_translation_base,data,m)
   else if the_default=default_ebcdic_input
   then geq_define(ocp_input_ebcdic_translation_base,data,m)
   else if the_default=default_unicode_input
   then geq_define(ocp_input_unicode_translation_base,data,m)
   else geq_define(ocp_input_unicode_LE_translation_base,data,m)
else
begin
   base_ptr:=input_ptr; input_stack[base_ptr]:=cur_input;
   while state = token_list do
   begin
      decr(base_ptr);
      cur_input:=input_stack[base_ptr];
   end;
   if command=input_mode then
   begin
      if (name=0)or(name=17) then term_in_mode:=m
      else if name<17 then read_file_mode[name-1]:=m
      else {name>17} input_file_mode[index]:=m;
   end
   else
   begin
      if (name=0)or(name=17) then term_in_translation:=m
      else if name<17 then read_file_translation[name-1]:=m
      else {name>17} input_file_translation[index]:=m;
   end;
   cur_input:=input_stack[input_ptr];
end;
end;

procedure do_no_input_mode;
var the_default:halfword;
    m:halfword;
begin
the_default:=cur_chr;
m:=0;
set_the_value(input_mode, the_default, m);
end;

procedure do_input_mode;
var the_default:halfword;
    m:halfword;
begin
the_default:=cur_chr;
if scan_keyword("ascii") then m:=ascii_mode
else if scan_keyword("ebcdic") then m:=ebcdic_mode
else if scan_keyword("unicode") then m:=unicode_mode
else if scan_keyword("unicodeLE") then m:=unicode_LE_mode
else begin print_err("Invalid input mode"); m:=0; end;
set_the_value(input_mode, the_default, m);
end;

procedure do_no_input_translation;
var the_default:halfword;
    m:halfword;
begin
the_default:=cur_chr;
m:=null_ocp;
set_the_value(input_translation, the_default, m);
end;

procedure do_input_translation;
var the_default:halfword;
    m:halfword;
begin
the_default:=cur_chr;
scan_ocp_ident;
m:=cur_val;
set_the_value(input_translation, the_default, m);
end;

function p_new_input_ln(f:alpha_file;
the_mode,translation:halfword;
bypass_eoln:boolean):boolean;
begin
if (the_mode=0) or ((the_mode=1) and (translation=0))
then p_new_input_ln:=input_ln(f,bypass_eoln)
else if not newinputline(f,the_mode,bypass_eoln)
then p_new_input_ln:=false
else if translation=0 then
begin
   if (first+otp_input_end)>=buf_size then overflow("buffer size", buf_size);
   state:=new_line;
   start:=first;
   last:=start;
   loc:=start;
   for otp_counter:=1 to otp_input_end do
   begin
      buffer[last]:=otp_input_buf[otp_counter];
      incr(last);
   end;
   while buffer[last-1]=' ' do decr(last);
   limit:=last-1;
   p_new_input_ln:=true
end
else
begin
   otp_input_start:=0;
   otp_input_last:=0;
   otp_stack_used:=0;
   otp_stack_last:=0;
   otp_stack_new:=0;
   otp_output_end:=0;
   otp_pc:=0;
   otp_finished:=false;
   otp_calc_ptr:=0;
   otp_calcs[otp_calc_ptr]:=0;
   otp_state_ptr:=0;
   otp_states[otp_state_ptr]:=0;
   otp_input_ocp:=translation;
   while not otp_finished do
      @<Run the OTP program@>;
   if (first+otp_output_end)>=buf_size then overflow("buffer size", buf_size);
   state:=new_line;
   start:=first;
   last:=start;
   loc:=start;
   for otp_counter:=1 to otp_output_end do
   begin
      buffer[last]:=otp_output_buf[otp_counter];
      incr(last);
   end;
   while buffer[last-1]=' ' do decr(last);
   limit:=last-1;
   p_new_input_ln:=true
end
end;

@z
%---------------------------------------
