.\" $XConsortium: XdbeAllo.man /main/3 1996/12/09 16:45:23 kaleb $
.\"
.\" Copyright (c) 1995  Hewlett-Packard Company
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"), 
.\" to deal in the Software without restriction, including without limitation 
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense, 
.\" and/or sell copies of the Software, and to permit persons to whom the 
.\" Software furnished to do so, subject to the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
.\" HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
.\" SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the Hewlett-Packard Company shall not 
.\" be used in advertising or otherwise to promote the sale, use or other 
.\" dealing in this Software without prior written authorization from the 
.\" Hewlett-Packard Company.
.TH XdbeAllocateBackBufferName 3X11 "Release 6.3" "X Version 11" "X FUNCTIONS"
.SH NAME
XdbeAllocateBackBufferName - allocates a DBE buffer.
.SH SYNOPSIS
#include <X11/extensions/Xdbe.h>

XdbeBackBuffer XdbeAllocateBackBufferName(
    Display        *dpy,
    Window         window, 
    XdbeSwapAction swap_action)
.SH DESCRIPTION
This function returns a drawable ID used to refer to the back buffer of the 
specified window.  The swap_action is a hint to indicate the swap action that 
will likely be used in subsequent calls to
.B XdbeSwapBuffers().
The actual swap
action used in calls to
.B XdbeSwapBuffers()
does not have to be the same as the 
swap_action passed to this function, though clients are encouraged to provide
accurate information whenever possible.
.SH ERRORS
.IP BadAlloc
.IP BadIDChoice
.IP BadMatch
The specified window is not an InputOutput window or its visual does not
support DBE.
.IP BadValue
An invalid swap action was specified.
.IP BadWindow
An invalid window was specified.
.SH SEE ALSO
DBE,
.I XdbeBeginIdiom(),
.I XdbeDeallocateBackBufferName(),
.I XdbeEndIdiom(),
.I XdbeFreeVisualInfo(),
.I XdbeGetBackBufferAttributes(),
.I XdbeGetVisualInfo(),
.I XdbeQueryExtension(),
.I XdbeSwapBuffers().

