/**
 *
 * $Header: /cvsroot/hungry/lesstif/lib/Xm-2.0/Notebook.c,v 1.10 1998/01/12 02:1
2:28 pgw Exp $
 *
 * Copyright (C) 1998 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#include <stdio.h>
#include <time.h>

#include <Xm/XmAll.h>
#include <X11/IntrinsicP.h>

#include <Xm/ArrowBGP.h>
#include <Xm/ArrowBP.h>
#include <Xm/BaseClassP.h>
#include <Xm/BulletinBP.h>
#include <Xm/CacheP.h>
#include <Xm/CascadeBGP.h>
#include <Xm/CascadeBP.h>
#include <Xm/ComboBoxP.h>
#include <Xm/CommandP.h>
#include <Xm/CutPasteP.h>
#include <Xm/DesktopP.h>
#include <Xm/DialogSEP.h>
#include <Xm/DialogSP.h>
#include <Xm/DisplayP.h>
#include <Xm/DragCP.h>
#include <Xm/DragIconP.h>
#include <Xm/DragOverSP.h>
#include <Xm/DrawP.h>
#include <Xm/DrawingAP.h>
#include <Xm/DrawnBP.h>
#include <Xm/DropSMgrP.h>
#include <Xm/DropTransP.h>
#include <Xm/ExtObjectP.h>
#include <Xm/FileSBP.h>
#include <Xm/FormP.h>
#include <Xm/FrameP.h>
#include <Xm/GadgetP.h>
#include <Xm/GrabShellP.h>
#include <Xm/IconGP.h>
#include <Xm/LabelGP.h>
#include <Xm/LabelP.h>
#include <Xm/ListP.h>
#include <Xm/MainWP.h>
#include <Xm/ManagerP.h>
#include <Xm/MenuShellP.h>
#include <Xm/MenuUtilP.h>
#include <Xm/MessageBP.h>
#include <Xm/NotebookP.h>
#include <Xm/PanedWP.h>
#include <Xm/PrimitiveP.h>
#include <Xm/ProtocolsP.h>
#include <Xm/PushBGP.h>
#include <Xm/PushBP.h>
#include <Xm/RCUtilsP.h>
#include <Xm/RowColumnP.h>
#include <Xm/SashP.h>
#include <Xm/ScaleP.h>
#include <Xm/ScreenP.h>
#include <Xm/ScrollBarP.h>
#include <Xm/ScrolledWP.h>
#include <Xm/SelectioBP.h>
#include <Xm/SeparatoGP.h>
#include <Xm/SeparatorP.h>
#include <Xm/ShellEP.h>
#include <Xm/SpinBP.h>
#include <Xm/TearOffBP.h>
#include <Xm/TearOffP.h>
#include <Xm/TextFP.h>
#include <Xm/TextFSelP.h>
#include <Xm/TextInP.h>
#include <Xm/TextOutP.h>
#include <Xm/TextP.h>
#include <Xm/TextSelP.h>
#include <Xm/TextStrSoP.h>
#include <Xm/ToggleBGP.h>
#include <Xm/ToggleBP.h>
#include <Xm/TraitP.h>
#include <Xm/VaSimpleP.h>
#include <Xm/VendorSEP.h>
#include <Xm/VendorSP.h>
#include <Xm/VirtKeysP.h>
#include <Xm/WorldP.h>

FILE *OpenFile(char *s)
{
	FILE	*f = fopen(s, "w");

	if (f == NULL)
		return NULL;
	fprintf(f, ".\\%c\n.\\%c $Header: /cvsroot/hungry/lesstif/doc/lessdox/widgets/spit.c,v 1.2 1998/04/11 10:09:01 u27113 Exp $\n.\\%c\n", '"', '"', '"');

	fprintf(f, ".\\%c %s\n", '"',
	  "Copyright (C) 1997-1998 Free Software Foundation, Inc.");
	fprintf(f, ".\\%c %s\n", '"', "");
	fprintf(f, ".\\%c %s\n", '"',
	  "This file is part of the GNU LessTif Library.");
	fprintf(f, ".\\%c %s\n", '"',
	  "This library is free software; you can redistribute it and/or");
	fprintf(f, ".\\%c %s\n", '"',
	  "modify it under the terms of the GNU Library General Public");
	fprintf(f, ".\\%c %s\n", '"',
	  "License as published by the Free Software Foundation; either");
	fprintf(f, ".\\%c %s\n", '"',
	  "version 2 of the License, or (at your option) any later version.");
	fprintf(f, ".\\%c %s\n", '"', "");
	fprintf(f, ".\\%c %s\n", '"',
	  "This library is distributed in the hope that it will be useful,");
	fprintf(f, ".\\%c %s\n", '"',
	  "but WITHOUT ANY WARRANTY; without even the implied warranty of");
	fprintf(f, ".\\%c %s\n", '"',
	  "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU");
	fprintf(f, ".\\%c %s\n", '"',
	  "Library General Public License for more details.");
	fprintf(f, ".\\%c %s\n", '"', "");
	fprintf(f, ".\\%c %s\n", '"',
	  "You should have received a copy of the GNU Library General Public");
	fprintf(f, ".\\%c %s\n", '"',
	  "License along with this library; if not, write to the Free");
	fprintf(f, ".\\%c %s\n", '"',
	  "Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.");
	fprintf(f, ".\\%c %s\n", '"', "");

	return f;
}

char *months[] = { "January", "February", "March", "April", "May", "June",
	"July", "August", "September", "October", "November", "December" };

void PrintName(FILE *f, CoreClassPart *wc)
{
	struct tm *now;
	time_t	nowt;

	time(&nowt);
	now = localtime(&nowt);

	fprintf(f,
	    ".TH %s 3 %c%s %d%c %cLessTif Project%c %cLessTif Manuals%c\n",
	    wc->class_name,
	    '"', months[now->tm_mon], 1900 + now->tm_year, '"',
	    '"', '"', '"', '"');
	fprintf(f, ".SH NAME\n%s\n.SH SYNOPSYS\n.B #include <Xm/%s.h>\n",
		wc->class_name, wc->class_name + 2);
	fprintf(f, ".PP\n.B %s\n.PP\n.B XmCreate%s\n",
		wc->class_name, wc->class_name + 2);
	fprintf(f, ".SH DESCRIPTION\n%s\n", wc->class_name);
}

void PrintH(FILE *f, CoreClassPart *wc)
{
	if (wc == NULL)
		return;
	PrintH(f, wc->superclass);
	fprintf(f, ".BR %s (3)\n", wc->class_name);
}

void PrintHierarchy(FILE *f, CoreClassPart *wc)
{
	fprintf(f, ".SH CLASS HIERARCHY\n");
	PrintH(f, wc);
}

void PrintResources(FILE *f, CoreClassPart *wc)
{
	int	i;

	fprintf(f, ".SH X RESOURCES\n.TS\ntab(;);\nl l l l l.\n");
	fprintf(f, "Name;Class;Type;Default;Access\n_\n");

	for (i=0; i<wc->num_resources; i++)
	    if (strcmp(wc->resources[i].default_type, "Int") == 0) {
		fprintf(f, "XmN%s;XmC%s;%s;%d;%s\n",
			wc->resources[i].resource_name,
			wc->resources[i].resource_class,
			wc->resources[i].resource_type,
			wc->resources[i].default_addr,
			"CSG");
	    } else if (strcmp(wc->resources[i].default_type, "String") == 0) {
		fprintf(f, "XmN%s;XmC%s;%s;%s;%s\n",
			wc->resources[i].resource_name,
			wc->resources[i].resource_class,
			wc->resources[i].resource_type,
			wc->resources[i].default_addr,
			"CSG");
	    } else if ((strcmp(wc->resources[i].default_type, "Immediate") == 0)
		&& (strcmp(wc->resources[i].resource_type, "Int") == 0)) {
		fprintf(f, "XmN%s;XmC%s;%s;%d;%s\n",
			wc->resources[i].resource_name,
			wc->resources[i].resource_class,
			wc->resources[i].resource_type,
			wc->resources[i].default_addr,
			"CSG");
	    } else {
		fprintf(f, "XmN%s;XmC%s;%s;%s;%s\n",
			wc->resources[i].resource_name,
			wc->resources[i].resource_class,
			wc->resources[i].resource_type,
			"NULL",
			"CSG");
	    }
	fprintf(f, ".TE\n.PP\n");

	for (i=0; i<wc->num_resources; i++)
		fprintf(f, ".BR XmN%s\n.PP\n", wc->resources[i].resource_name);
}

Doit(char *s, CoreClassPart *wc)
{
	FILE	*f;
	char	fn[64], *p;

	strcpy(fn, "Xm");
	strcat(fn, s+2);	/* Strip "xm" */
	p = strstr(fn, "ClassRec");
	*p = 0;
	strcat(fn, ".3");

	f = OpenFile(fn);
	PrintName(f, wc);
	PrintResources(f, wc);
	PrintHierarchy(f, wc);
	fprintf(f, ".SH CALLBACKS\n");
	fprintf(f, ".SH CONVENIENCE FUNCTIONS\n");
	fprintf(f, ".SH SEE ALSO\n");
	fclose(f);
}

main()
{
	Doit("xmComboBoxClassRec", &xmComboBoxClassRec);
	Doit("xmGrabShellClassRec", &xmGrabShellClassRec);
	Doit("xmIconGCacheObjClassRec", &xmIconGCacheObjClassRec);
	Doit("xmIconGadgetClassRec", &xmIconGadgetClassRec);
	Doit("xmNotebookClassRec", &xmNotebookClassRec);
	Doit("xmPanedWindowClassRec", &xmPanedWindowClassRec);
	Doit("xmSpinBoxClassRec", &xmSpinBoxClassRec);
	Doit("xmTextClassRec", &xmTextClassRec);
	Doit("xmTextFieldClassRec", &xmTextFieldClassRec);
	Doit("xmArrowButtonClassRec", &xmArrowButtonClassRec);
	Doit("xmArrowButtonGadgetClassRec", &xmArrowButtonGadgetClassRec);
	Doit("xmBulletinBoardClassRec", &xmBulletinBoardClassRec);
	Doit("xmCascadeButtonClassRec", &xmCascadeButtonClassRec);
	Doit("xmCascadeButtonGCacheObjClassRec", &xmCascadeButtonGCacheObjClassRec);
	Doit("xmCascadeButtonGadgetClassRec", &xmCascadeButtonGadgetClassRec);
	Doit("xmCommandClassRec", &xmCommandClassRec);
	Doit("xmDesktopClassRec", &xmDesktopClassRec);
	Doit("xmDialogShellClassRec", &xmDialogShellClassRec);
	Doit("xmDialogShellExtClassRec", &xmDialogShellExtClassRec);
	Doit("xmDisplayClassRec", &xmDisplayClassRec);
	Doit("xmDragContextClassRec", &xmDragContextClassRec);
	Doit("xmDragIconClassRec", &xmDragIconClassRec);
	Doit("xmDragOverShellClassRec", &xmDragOverShellClassRec);
	Doit("xmDrawingAreaClassRec", &xmDrawingAreaClassRec);
	Doit("xmDrawnButtonClassRec", &xmDrawnButtonClassRec);
	Doit("xmDropSiteManagerClassRec", &xmDropSiteManagerClassRec);
	Doit("xmDropTransferClassRec", &xmDropTransferClassRec);
	Doit("xmFileSelectionBoxClassRec", &xmFileSelectionBoxClassRec);
	Doit("xmFormClassRec", &xmFormClassRec);
	Doit("xmFrameClassRec", &xmFrameClassRec);
	Doit("xmGadgetClassRec", &xmGadgetClassRec);
	Doit("xmLabelClassRec", &xmLabelClassRec);
	Doit("xmLabelGCacheObjClassRec", &xmLabelGCacheObjClassRec);
	Doit("xmLabelGadgetClassRec", &xmLabelGadgetClassRec);
	Doit("xmListClassRec", &xmListClassRec);
	Doit("xmMainWindowClassRec", &xmMainWindowClassRec);
	Doit("xmManagerClassRec", &xmManagerClassRec);
	Doit("xmMenuShellClassRec", &xmMenuShellClassRec);
	Doit("xmMessageBoxClassRec", &xmMessageBoxClassRec);
	Doit("xmPanedWindowClassRec", &xmPanedWindowClassRec);
	Doit("xmPrimitiveClassRec", &xmPrimitiveClassRec);
	Doit("xmProtocolClassRec", &xmProtocolClassRec);
	Doit("xmPushButtonClassRec", &xmPushButtonClassRec);
	Doit("xmPushButtonGCacheObjClassRec", &xmPushButtonGCacheObjClassRec);
	Doit("xmPushButtonGadgetClassRec", &xmPushButtonGadgetClassRec);
	Doit("xmRowColumnClassRec", &xmRowColumnClassRec);
	Doit("xmSashClassRec", &xmSashClassRec);
	Doit("xmScaleClassRec", &xmScaleClassRec);
	Doit("xmScreenClassRec", &xmScreenClassRec);
	Doit("xmScrollBarClassRec", &xmScrollBarClassRec);
	Doit("xmScrolledWindowClassRec", &xmScrolledWindowClassRec);
	Doit("xmSelectionBoxClassRec", &xmSelectionBoxClassRec);
	Doit("xmSeparatorGCacheObjClassRec", &xmSeparatorGCacheObjClassRec);
	Doit("xmSeparatorGadgetClassRec", &xmSeparatorGadgetClassRec);
	Doit("xmSeparatorClassRec", &xmSeparatorClassRec);
	Doit("xmTearOffButtonClassRec", &xmTearOffButtonClassRec);
	Doit("xmTextClassRec", &xmTextClassRec);
	Doit("xmTextFieldClassRec", &xmTextFieldClassRec);
	Doit("xmToggleButtonClassRec", &xmToggleButtonClassRec);
	Doit("xmToggleButtonGCacheObjClassRec", &xmToggleButtonGCacheObjClassRec);
	Doit("xmToggleButtonGadgetClassRec", &xmToggleButtonGadgetClassRec);
	Doit("xmVendorShellExtClassRec", &xmVendorShellExtClassRec);
	Doit("xmWorldClassRec", &xmWorldClassRec);

	exit(0);
}
