/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import sun.rmi.transport.Channel;
import sun.rmi.transport.ConnectionInputStream;
import sun.rmi.transport.ConnectionOutputStream;
import sun.rmi.transport.DGCClient;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPEndpoint;

public class LiveRef
implements Externalizable {
    private transient Endpoint ep;
    private transient ObjID id;
    private transient Channel ch;
    private transient boolean counted = false;
    private transient boolean isLocal = false;

    private LiveRef(ObjID objID, Endpoint endpoint, Channel channel, boolean bl) {
        this.ep = endpoint;
        this.id = objID;
        this.ch = channel;
        this.isLocal = bl;
    }

    LiveRef copy() {
        return new LiveRef(this.id, this.ep, this.ch, this.isLocal);
    }

    public LiveRef(ObjID objID, Endpoint endpoint, boolean bl) {
        this(objID, endpoint, null, bl);
    }

    public LiveRef() {
    }

    public LiveRef(int n) {
        this(new ObjID(), n);
    }

    public int getPort() {
        return ((TCPEndpoint)this.ep).getPort();
    }

    public LiveRef(ObjID objID, int n) {
        this(objID, TCPEndpoint.getLocalEndpoint(n), true);
    }

    public void exportObject(Target target) throws RemoteException {
        this.ep.exportObject(this.id, target);
    }

    public Channel getChannel() throws RemoteException {
        if (this.ch == null) {
            this.ch = this.ep.getChannel();
        }
        return this.ch;
    }

    public ObjID getObjID() {
        return this.id;
    }

    Endpoint getEndpoint() {
        return this.ep;
    }

    void counted() {
        this.counted = true;
    }

    public String toString() {
        String string = this.isLocal ? "local" : "remote";
        return "[endpoint:" + this.ep + "(" + string + ")," + "objID:" + this.id + "]";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof LiveRef) {
            LiveRef liveRef = (LiveRef)object;
            return this.ep.equals(liveRef.ep) && this.id.equals(liveRef.id) && this.isLocal == liveRef.isLocal;
        }
        return false;
    }

    public boolean remoteEquals(Object object) {
        if (object instanceof LiveRef) {
            LiveRef liveRef = (LiveRef)object;
            return this.ep.equals(liveRef.ep) && this.id.equals(liveRef.id);
        }
        return false;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        boolean bl = false;
        if (objectOutput instanceof ConnectionOutputStream) {
            ConnectionOutputStream connectionOutputStream = (ConnectionOutputStream)objectOutput;
            if (this.isLocal) {
                Target target = ObjectTable.getTarget(this.id);
                if (target != null) {
                    target.pinImpl();
                } else {
                    throw new IOException("attempt to marshal unexported object reference: " + this);
                }
            }
            if (bl = connectionOutputStream.isResultStream()) {
                connectionOutputStream.saveRef(this);
            }
        }
        ((TCPEndpoint)this.ep).write(objectOutput);
        this.id.write(objectOutput);
        objectOutput.writeBoolean(bl);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ep = TCPEndpoint.read(objectInput);
        this.id = ObjID.read(objectInput);
        boolean bl = objectInput.readBoolean();
        this.ch = null;
        this.isLocal = false;
        this.counted = false;
        if (objectInput instanceof ConnectionInputStream) {
            ConnectionInputStream connectionInputStream = (ConnectionInputStream)objectInput;
            connectionInputStream.saveRef(this);
            if (bl) {
                connectionInputStream.setAckNeeded();
                return;
            }
        } else {
            DGCClient.referenced(this);
        }
    }

    public void finalize() throws Throwable {
        if (!this.isLocal && !this.id.equals(DGCImpl.getID()) && this.counted) {
            DGCClient.unreferenced(this);
        }
    }
}

