/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.peer.CheckboxPeer;
import sun.awt.macos.MComponentPeer;
import sun.awt.macos.MToolkit;

public class MCheckboxPeer
extends MComponentPeer
implements CheckboxPeer {
    boolean isRadioButton;

    public MCheckboxPeer(Checkbox checkbox) {
        super(checkbox);
    }

    native void create(MComponentPeer var1);

    void initialize() {
        super.initialize();
        this.isRadioButton = false;
    }

    public Dimension minimumSize() {
        String string = ((Checkbox)this.target).getLabel();
        if (string != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
            return new Dimension(30 + fontMetrics.stringWidth(string), Math.max(fontMetrics.getHeight() + 8, 16));
        }
        return new Dimension(20, 16);
    }

    public native void setLabel(String var1);

    public native void setState(boolean var1);

    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        if (checkboxGroup == null && this.isRadioButton || checkboxGroup != null && !this.isRadioButton) {
            this.dispose();
            Container container = this.target.getParent();
            this.setup();
            this.create((MComponentPeer)(container != null ? container.getPeer() : null));
        }
    }

    public void handleAction(boolean bl) {
        Checkbox checkbox = (Checkbox)this.target;
        checkbox.setState(bl);
        MToolkit.postEvent(new ItemEvent(checkbox, 701, checkbox.getLabel(), bl ? 1 : 2));
    }

    public boolean isFocusTraversable() {
        return true;
    }
}

