/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPCheckComm;
import netscape.ldap.LDAPConnThread;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedOperation;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSSLSocketFactoryExt;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPUrl;
import netscape.ldap.LDAPv3;
import netscape.ldap.ResponseControl;
import netscape.ldap.client.JDAPAVA;
import netscape.ldap.client.JDAPMessage;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPAddRequest;
import netscape.ldap.client.opers.JDAPBindRequest;
import netscape.ldap.client.opers.JDAPBindResponse;
import netscape.ldap.client.opers.JDAPCompareRequest;
import netscape.ldap.client.opers.JDAPDeleteRequest;
import netscape.ldap.client.opers.JDAPExtendedRequest;
import netscape.ldap.client.opers.JDAPExtendedResponse;
import netscape.ldap.client.opers.JDAPModifyRDNRequest;
import netscape.ldap.client.opers.JDAPModifyRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPResult;
import netscape.ldap.client.opers.JDAPSearchRequest;
import netscape.ldap.client.opers.JDAPSearchResult;
import netscape.ldap.client.opers.JDAPSearchResultReference;

public class LDAPConnection
implements LDAPv3,
Cloneable {
    public static final int LDAP_VERSION = 2;
    public static final String LDAP_PROPERTY_SDK = "version.sdk";
    public static final String LDAP_PROPERTY_PROTOCOL = "version.protocol";
    public static final String LDAP_PROPERTY_SECURITY = "version.security";
    private static final String defaultFilter = "(objectClass=*)";
    private static final LDAPSearchConstraints readConstraints = new LDAPSearchConstraints();
    private transient LDAPSearchConstraints defaultConstraints = new LDAPSearchConstraints();
    private transient Vector responseListeners;
    private transient Vector searchListeners;
    private transient boolean bound;
    private transient String host;
    private transient String[] m_hostList;
    private transient int port = -1;
    private transient int[] m_portList;
    private transient int m_defaultPort;
    private transient String prevBoundDN;
    private transient String prevBoundPasswd;
    private transient String boundDN;
    private transient String boundPasswd;
    private transient int protocolVersion = 2;
    private transient LDAPSocketFactory m_factory;
    private transient LDAPConnThread th;
    private transient Vector m_attachedList = new Vector();
    private transient Hashtable m_responseControlTable = new Hashtable();
    private transient LDAPCache m_cache;
    static Hashtable m_threadConnTable = new Hashtable();
    private boolean m_anonymousBound = false;
    private Object m_security;
    private boolean saslBind = false;
    private Object m_mechanismDriver;
    private Properties m_securityProperties;
    private Object m_clientCB;
    private Hashtable m_methodLookup = new Hashtable();
    private LDAPConnection m_referralConnection;
    private static final Float SdkVersion = new Float(3.1f);
    private static final Float ProtocolVersion = new Float(3.0f);
    private static final String SecurityVersion = new String("none,simple,sasl");
    private static final Float MajorVersion = new Float(3.0f);
    private static final Float MinorVersion = new Float(0.1f);
    private static final String DELIM = "#";
    private static final String PersistSearchPackageName = "netscape.ldap.controls.LDAPPersistSearchControl";
    private static final String EXTERNAL_MECHANISM = "SASLExternalMechanism";
    private static final String EXTERNAL_MECHANISM_PACKAGE = "com.netscape.sasl.mechanisms";
    public static final int MAXBACKLOG = 30;
    private static boolean isCommunicator = LDAPConnection.checkCommunicator();
    private static final boolean debug = false;

    public LDAPConnection() {
        this.m_factory = null;
    }

    public LDAPConnection(LDAPSocketFactory lDAPSocketFactory) {
        this.m_factory = lDAPSocketFactory;
    }

    public void finalize() throws LDAPException {
        if (this.th != null) {
            this.disconnect();
        }
    }

    public void setCache(LDAPCache lDAPCache) {
        this.m_cache = lDAPCache;
    }

    public LDAPCache getCache() {
        return this.m_cache;
    }

    public Object getProperty(String string) throws LDAPException {
        if (string.equals(LDAP_PROPERTY_SDK)) {
            return SdkVersion;
        }
        if (string.equals(LDAP_PROPERTY_PROTOCOL)) {
            return ProtocolVersion;
        }
        if (string.equals(LDAP_PROPERTY_SECURITY)) {
            return SecurityVersion;
        }
        if (string.equals("version.major")) {
            return MajorVersion;
        }
        if (string.equals("version.minor")) {
            return MinorVersion;
        }
        return null;
    }

    public void setProperty(String string, Object object) throws LDAPException {
        throw new LDAPException("No property has been set");
    }

    private void setProtocolVersion(int n) {
        this.protocolVersion = n;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuthenticationDN() {
        return this.boundDN;
    }

    public String getAuthenticationPassword() {
        return this.boundPasswd;
    }

    public LDAPSocketFactory getSocketFactory() {
        return this.m_factory;
    }

    public void setSocketFactory(LDAPSocketFactory lDAPSocketFactory) {
        this.m_factory = lDAPSocketFactory;
    }

    public boolean isConnected() {
        Thread.yield();
        return this.th != null;
    }

    public boolean isAuthenticated() {
        if (this.bound && (this.boundDN == null || this.boundDN.equals("") || this.boundPasswd == null || this.boundPasswd.equals(""))) {
            return false;
        }
        return this.bound;
    }

    public void connect(String string, int n) throws LDAPException {
        this.connect(string, n, null, null, this.defaultConstraints, false);
    }

    public void connect(String string, int n, String string2, String string3) throws LDAPException {
        this.connect(string, n, string2, string3, this.defaultConstraints, true);
    }

    public void connect(String string, int n, String string2, String string3, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.connect(string, n, string2, string3, lDAPSearchConstraints, true);
    }

    private void connect(String string, int n, String string2, String string3, LDAPSearchConstraints lDAPSearchConstraints, boolean bl) throws LDAPException {
        Object object;
        if (this.th != null) {
            this.disconnect();
        }
        if (string == null || string.equals("")) {
            throw new LDAPException("no host for connection", 89);
        }
        this.m_defaultPort = n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.m_hostList = new String[stringTokenizer.countTokens()];
        this.m_portList = new int[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n3 = ((String)object).indexOf(58);
            if (n3 > 0) {
                this.m_hostList[n2] = ((String)object).substring(0, n3);
                this.m_portList[n2] = Integer.parseInt(((String)object).substring(n3 + 1));
            } else {
                this.m_hostList[n2] = object;
                this.m_portList[n2] = this.m_defaultPort;
            }
            ++n2;
        }
        object = null;
        n2 = 0;
        while (n2 < this.m_hostList.length) {
            try {
                this.host = this.m_hostList[n2];
                this.port = this.m_portList[n2];
                this.connect();
                object = null;
                break;
            }
            catch (LDAPException lDAPException) {
                object = lDAPException;
                ++n2;
            }
        }
        if (object != null) {
            this.host = this.m_hostList[0];
            this.port = this.m_defaultPort;
            throw object;
        }
        if (bl) {
            this.authenticate(string2, string3, lDAPSearchConstraints);
        }
    }

    public void connect(int n, String string, int n2, String string2, String string3) throws LDAPException {
        this.connect(n, string, n2, string2, string3, this.defaultConstraints);
    }

    public void connect(int n, String string, int n2, String string2, String string3, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.setProtocolVersion(n);
        this.connect(string, n2, string2, string3, lDAPSearchConstraints);
    }

    private synchronized void connect() throws LDAPException {
        if (this.th != null) {
            return;
        }
        if (this.host == null || this.port < 0) {
            throw new LDAPException("no connection parameters", 89);
        }
        this.th = this.getNewThread(this.host, this.port, this.m_factory, this.m_cache);
    }

    private synchronized LDAPConnThread getNewThread(String string, int n, LDAPSocketFactory lDAPSocketFactory, LDAPCache lDAPCache) throws LDAPException {
        LDAPConnThread lDAPConnThread = null;
        Vector vector = null;
        Hashtable hashtable = m_threadConnTable;
        synchronized (hashtable) {
            Object object;
            Enumeration enumeration = m_threadConnTable.keys();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                LDAPConnThread lDAPConnThread2 = (LDAPConnThread)enumeration.nextElement();
                Vector vector2 = (Vector)m_threadConnTable.get(lDAPConnThread2);
                object = vector2.elements();
                while (object.hasMoreElements()) {
                    LDAPConnection lDAPConnection = (LDAPConnection)object.nextElement();
                    if (!lDAPConnection.equals(this)) continue;
                    bl = true;
                    if (lDAPConnThread2.isAlive()) break;
                    try {
                        lDAPConnThread = new LDAPConnThread(string, n, lDAPSocketFactory, lDAPCache);
                        lDAPConnThread.setMaxBacklog(this.getSearchConstraints().getMaxBacklog());
                        vector = (Vector)m_threadConnTable.remove(lDAPConnThread2);
                        break;
                    }
                    catch (Exception exception) {
                        throw new LDAPException("unable to establish connection", 52);
                    }
                }
                if (bl) break;
            }
            if (!bl) {
                try {
                    lDAPConnThread = new LDAPConnThread(string, n, lDAPSocketFactory, lDAPCache);
                    lDAPConnThread.setMaxBacklog(this.getSearchConstraints().getMaxBacklog());
                    vector = new Vector();
                    vector.addElement(this);
                }
                catch (Exception exception) {
                    throw new LDAPException("unable to establish connection", 52);
                }
            }
            if (lDAPConnThread != null) {
                m_threadConnTable.put(lDAPConnThread, vector);
                int n2 = 0;
                int n3 = vector.size();
                while (n2 < n3) {
                    object = (LDAPConnection)vector.elementAt(n2);
                    lDAPConnThread.register((LDAPConnection)object);
                    ((LDAPConnection)object).th = lDAPConnThread;
                    ++n2;
                }
            }
        }
        this.authenticateSSLConnection();
        return lDAPConnThread;
    }

    private void authenticateSSLConnection() throws LDAPException {
        boolean bl;
        if (this.m_factory != null && this.m_factory instanceof LDAPSSLSocketFactoryExt && (bl = ((LDAPSSLSocketFactoryExt)this.m_factory).isClientAuth())) {
            this.authenticate(null, EXTERNAL_MECHANISM, EXTERNAL_MECHANISM_PACKAGE, null, null);
        }
    }

    public void abandon(LDAPSearchResults lDAPSearchResults) throws LDAPException {
        if (this.th == null || lDAPSearchResults == null) {
            return;
        }
        lDAPSearchResults.abandon();
        int n = lDAPSearchResults.getID();
        int n2 = 0;
        while (n2 < 3) {
            try {
                this.th.abandon(n);
                this.th.sendRequest(new JDAPAbandonRequest(n), null, this.defaultConstraints);
                break;
            }
            catch (NullPointerException nullPointerException) {
                ++n2;
            }
        }
        if (this.th == null) {
            throw new LDAPException("Failed to send abandon request to the server.", 80);
        }
    }

    public void authenticate(String string, String string2) throws LDAPException {
        this.authenticate(this.protocolVersion, string, string2, this.defaultConstraints);
    }

    public void authenticate(String string, String string2, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.authenticate(this.protocolVersion, string, string2, lDAPSearchConstraints);
    }

    public void authenticate(int n, String string, String string2) throws LDAPException {
        this.authenticate(n, string, string2, this.defaultConstraints);
    }

    public void authenticate(int n, String string, String string2, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.prevBoundDN = this.boundDN;
        this.prevBoundPasswd = this.boundPasswd;
        this.boundDN = string;
        this.boundPasswd = string2;
        this.m_anonymousBound = this.prevBoundDN == null || this.prevBoundPasswd == null;
        this.bind(n, true, lDAPSearchConstraints);
    }

    public void authenticate(String string, String string2, String string3, Properties properties, Object object) throws LDAPException {
        try {
            Object[] objectArray = new Object[]{string2, string3};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
            this.m_mechanismDriver = this.invokeMethod(null, "com.netscape.sasl.SASLMechanismFactory", "getMechanismDriver", objectArray, stringArray);
        }
        catch (Exception exception) {
            throw new LDAPException(exception.toString(), 80);
        }
        this.m_securityProperties = properties;
        this.m_clientCB = object;
        this.boundDN = string;
        this.saslBind(true);
    }

    public void authenticate(String string, String[] stringArray, String string2, Properties properties, Object object) throws LDAPException {
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.authenticate(string, stringArray[n], string2, properties, object);
                if (this.m_mechanismDriver != null) {
                    return;
                }
            }
            catch (LDAPException lDAPException) {}
            ++n;
        }
        throw new LDAPException("Failed to get mechanism driver", 80);
    }

    private void saslBind(boolean bl) throws LDAPException {
        this.saslBind = true;
        this.protocolVersion = 3;
        if (this.th == null) {
            this.bound = false;
            this.th = null;
            this.connect();
        }
        if (this.bound && bl && this.th.getClientCount() > 1) {
            this.disconnect();
            this.connect();
        }
        if (this.bound && bl || !this.bound) {
            try {
                Object object;
                Object[] objectArray = new Object[]{this.boundDN, "LDAP", null, this.m_securityProperties, this.m_clientCB};
                String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.util.Properties", "com.netscape.sasl.SASLClientCB"};
                String string = this.m_mechanismDriver.getClass().getName();
                byte[] byArray = (byte[])this.invokeMethod(this.m_mechanismDriver, string, "startAuthentication", objectArray, stringArray);
                boolean bl2 = this.isExternalMechanism(string);
                int n = 14;
                JDAPBindResponse jDAPBindResponse = null;
                while (!this.checkForSASLBindCompletion(n)) {
                    jDAPBindResponse = this.saslBind(byArray);
                    n = jDAPBindResponse.getResultCode();
                    if (bl2) continue;
                    object = jDAPBindResponse.getCredentials();
                    byte[] byArray2 = ((String)object).getBytes();
                    Object[] objectArray2 = new Object[]{byArray2};
                    String[] stringArray2 = new String[]{"[B"};
                    byArray = (byte[])this.invokeMethod(this.m_mechanismDriver, string, "evaluateResponse", objectArray2, stringArray2);
                }
                object = (Boolean)this.invokeMethod(this.m_mechanismDriver, string, "isComplete", null, null);
                if (!((Boolean)object).booleanValue()) {
                    throw new LDAPException("The server indicates that authentication is successful, but the SASL driver indicates that authentication is not yet done.", 80);
                }
                this.m_security = this.invokeMethod(this.m_mechanismDriver, string, "getSecurityLayer", null, null);
                this.th.setSecurityLayer(this.m_security);
                this.updateThreadConnTable();
                return;
            }
            catch (LDAPException lDAPException) {
                throw lDAPException;
            }
            catch (Exception exception) {
                throw new LDAPException(exception.toString(), 80);
            }
        }
    }

    private boolean isExternalMechanism(String string) {
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1);
        }
        return string2.equals(EXTERNAL_MECHANISM);
    }

    private Object invokeMethod(Object object, String string, String string2, Object[] objectArray, String[] stringArray) throws LDAPException {
        try {
            Method method = this.getMethod(string, string2, stringArray);
            if (method != null) {
                return method.invoke(object, objectArray);
            }
        }
        catch (Exception exception) {
            throw new LDAPException("Invoking " + string2 + ": " + exception.toString(), 89);
        }
        return null;
    }

    private Method getMethod(String string, String string2, String[] stringArray) throws LDAPException {
        try {
            String string3;
            Method method = null;
            String string4 = "";
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    string4 = String.valueOf(string4) + stringArray[n].getClass().getName();
                    ++n;
                }
            }
            if ((method = (Method)this.m_methodLookup.get(string3 = String.valueOf(string) + "." + string2 + "." + string4)) != null) {
                return method;
            }
            Class<?> clazz = Class.forName(string);
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                Class[] classArray = methodArray[n].getParameterTypes();
                if (methodArray[n].getName().equals(string2) && this.signatureCorrect(classArray, stringArray)) {
                    this.m_methodLookup.put(string3, methodArray[n]);
                    return methodArray[n];
                }
                ++n;
            }
            throw new LDAPException("Method " + string2 + " not found in " + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LDAPException("Class " + string + " not found");
        }
    }

    private boolean signatureCorrect(Class[] classArray, String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        if (classArray.length != stringArray.length) {
            return false;
        }
        int n = 0;
        while (n < classArray.length) {
            if (!classArray[n].getName().equals(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean checkForSASLBindCompletion(int n) throws LDAPException {
        if (n == 0) {
            return true;
        }
        if (n == 14) {
            return false;
        }
        throw new LDAPException("Authentication failed", n);
    }

    private JDAPBindResponse saslBind(byte[] byArray) throws LDAPException {
        this.saslBind = true;
        if (this.th == null) {
            this.connect();
        }
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        try {
            String string = (String)this.invokeMethod(this.m_mechanismDriver, this.m_mechanismDriver.getClass().getName(), "getMechanismName", null, null);
            this.sendRequest(new JDAPBindRequest(this.protocolVersion, this.boundDN, string, byArray), lDAPResponseListener, this.defaultConstraints);
            JDAPMessage jDAPMessage = lDAPResponseListener.getResponse();
            JDAPProtocolOp jDAPProtocolOp = jDAPMessage.getProtocolOp();
            if (jDAPProtocolOp instanceof JDAPBindResponse) {
                JDAPBindResponse jDAPBindResponse = (JDAPBindResponse)jDAPProtocolOp;
                Object var6_7 = null;
                this.releaseResponseListener(lDAPResponseListener);
                return jDAPBindResponse;
            }
            throw new LDAPException("Unknown response from the server during SASL bind", 80);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    private void bind(int n, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.saslBind = false;
        if (this.th == null) {
            this.bound = false;
            this.th = null;
            this.connect();
        } else if (!this.bound && bl && this.th.getClientCount() > 1) {
            this.disconnect();
            this.connect();
        }
        if (this.bound && !bl) {
            return;
        }
        if (!(this.m_anonymousBound || this.boundDN != null && this.boundPasswd != null || bl)) {
            return;
        }
        if (this.bound && bl) {
            if (this.protocolVersion == n) {
                if (this.m_anonymousBound && (this.boundDN == null || this.boundPasswd == null)) {
                    return;
                }
                if (!this.m_anonymousBound && this.boundDN != null && this.boundPasswd != null && this.boundDN.equals(this.prevBoundDN) && this.boundPasswd.equals(this.prevBoundPasswd)) {
                    return;
                }
            }
            if (this.th.getClientCount() > 1) {
                this.disconnect();
                this.connect();
            }
        }
        this.protocolVersion = n;
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        try {
            try {
                if (this.m_referralConnection != null) {
                    this.m_referralConnection.disconnect();
                    this.m_referralConnection = null;
                }
                this.sendRequest(new JDAPBindRequest(this.protocolVersion, this.boundDN, this.boundPasswd), lDAPResponseListener, lDAPSearchConstraints);
                JDAPMessage jDAPMessage = lDAPResponseListener.getResponse();
                this.checkMsg(jDAPMessage);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.m_referralConnection = this.createReferralConnection(lDAPReferralException, lDAPSearchConstraints);
            }
            Object var7_7 = null;
            this.releaseResponseListener(lDAPResponseListener);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
        this.updateThreadConnTable();
    }

    private void updateThreadConnTable() {
        Hashtable hashtable = m_threadConnTable;
        synchronized (hashtable) {
            if (m_threadConnTable.containsKey(this.th)) {
                Vector vector = (Vector)m_threadConnTable.get(this.th);
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    LDAPConnection lDAPConnection = (LDAPConnection)vector.elementAt(n);
                    lDAPConnection.bound = true;
                    ++n;
                }
            } else {
                LDAPConnection.printDebug("Thread table does not contain the specified thread");
            }
            return;
        }
    }

    private void sendRequest(JDAPProtocolOp jDAPProtocolOp, LDAPResponseListener lDAPResponseListener, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        int n = 0;
        while (n < 3) {
            try {
                this.th.sendRequest(jDAPProtocolOp, lDAPResponseListener, lDAPSearchConstraints);
                break;
            }
            catch (NullPointerException nullPointerException) {
                ++n;
            }
        }
        if (this.th == null) {
            throw new LDAPException("The connection is not available", 80);
        }
    }

    private void bind(LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        if (this.saslBind) {
            this.saslBind(false);
            return;
        }
        this.bind(this.protocolVersion, false, lDAPSearchConstraints);
    }

    public synchronized void disconnect() throws LDAPException {
        if (this.m_referralConnection != null) {
            this.m_referralConnection.disconnect();
            this.m_referralConnection = null;
        }
        if (this.th == null) {
            throw new LDAPException("unable to disconnect() without connecting", 80);
        }
        if (this.m_cache != null) {
            this.m_cache.cleanup();
            this.m_cache = null;
        }
        this.deleteThreadConnEntry();
        this.deregisterConnection();
    }

    private void deleteThreadConnEntry() {
        Hashtable hashtable = m_threadConnTable;
        synchronized (hashtable) {
            Enumeration enumeration = m_threadConnTable.keys();
            while (enumeration.hasMoreElements()) {
                LDAPConnThread lDAPConnThread = (LDAPConnThread)enumeration.nextElement();
                Vector vector = (Vector)m_threadConnTable.get(lDAPConnThread);
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    LDAPConnection lDAPConnection = (LDAPConnection)enumeration2.nextElement();
                    if (!lDAPConnection.equals(this)) continue;
                    vector.removeElement(lDAPConnection);
                    if (vector.size() == 0) {
                        m_threadConnTable.remove(lDAPConnThread);
                    }
                    Object var2_7 = null;
                    return;
                }
            }
            return;
        }
    }

    synchronized void deregisterConnection() {
        this.th.deregister(this);
        this.th = null;
        this.bound = false;
    }

    public LDAPEntry read(String string) throws LDAPException {
        return this.read(string, null, this.defaultConstraints);
    }

    public LDAPEntry read(String string, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        return this.read(string, null, lDAPSearchConstraints);
    }

    public LDAPEntry read(String string, String[] stringArray) throws LDAPException {
        return this.read(string, stringArray, this.defaultConstraints);
    }

    public LDAPEntry read(String string, String[] stringArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPSearchResults lDAPSearchResults = this.search(string, 0, defaultFilter, stringArray, false, lDAPSearchConstraints);
        if (lDAPSearchResults == null) {
            return null;
        }
        return lDAPSearchResults.next();
    }

    public static LDAPEntry read(LDAPUrl lDAPUrl) throws LDAPException {
        String string = lDAPUrl.getHost();
        int n = lDAPUrl.getPort();
        if (string == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] stringArray = lDAPUrl.getAttributeArray();
        String string2 = lDAPUrl.getDN();
        LDAPConnection lDAPConnection = new LDAPConnection();
        lDAPConnection.connect(string, n);
        LDAPEntry lDAPEntry = lDAPConnection.read(string2, stringArray);
        lDAPConnection.disconnect();
        return lDAPEntry;
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl) throws LDAPException {
        return LDAPConnection.search(lDAPUrl, null);
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        String string = lDAPUrl.getHost();
        int n = lDAPUrl.getPort();
        if (string == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] stringArray = lDAPUrl.getAttributeArray();
        String string2 = lDAPUrl.getDN();
        String string3 = lDAPUrl.getFilter();
        if (string3 == null) {
            string3 = defaultFilter;
        }
        int n2 = lDAPUrl.getScope();
        LDAPConnection lDAPConnection = new LDAPConnection();
        lDAPConnection.connect(string, n);
        LDAPSearchResults lDAPSearchResults = lDAPSearchConstraints != null ? lDAPConnection.search(string2, n2, string3, stringArray, false, lDAPSearchConstraints) : lDAPConnection.search(string2, n2, string3, stringArray, false);
        lDAPSearchResults.closeOnCompletion(lDAPConnection);
        return lDAPSearchResults;
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl) throws LDAPException {
        return this.search(string, n, string2, stringArray, bl, this.defaultConstraints);
    }

    /*
     * Unable to fully structure code
     */
    public LDAPSearchResults search(String var1_1, int var2_2, String var3_3, String[] var4_4, boolean var5_5, LDAPSearchConstraints var6_6) throws LDAPException {
        block29: {
            if (var6_6 == null) {
                var6_6 = this.defaultConstraints;
            }
            var7_7 = new LDAPSearchResults(this, var6_6, var1_1, var2_2, var3_3, var4_4, var5_5);
            var8_8 = null;
            var9_9 = null;
            var10_10 = true;
            try {
                if (this.m_cache != null && (var8_8 = (Vector)this.m_cache.getEntry(var9_9 = this.m_cache.createKey(this.host, this.port, var1_1, var3_3, var2_2, var4_4, this.boundDN, var6_6))) != null) {
                    return new LDAPSearchResults(var8_8, this, var6_6, var1_1, var2_2, var3_3, var4_4, var5_5);
                }
            }
            catch (LDAPException var11_11) {
                var10_10 = false;
                LDAPConnection.printDebug("Exception: " + var11_11);
            }
            this.bind(var6_6);
            var11_12 = this.getSearchListener(var6_6);
            var12_13 = var6_6.getDereference();
            var13_14 = new JDAPSearchRequest(var1_1, var2_2, var12_13, var6_6.getMaxResults(), var6_6.getTimeLimit(), var5_5, var3_3, var4_4);
            var14_15 = var11_12;
            synchronized (var14_15) {
                var16_17 = 0;
                try {
                    this.sendRequest(var13_14, var11_12, var6_6);
                    var16_17 = 1;
                }
                finally {
                    var18_22 = null;
                    if (var16_17 == 0) {
                        this.releaseSearchListener(var11_12);
                    }
                }
                if (this.m_cache != null && var10_10) {
                    var11_12.setKey(var9_9);
                }
            }
            if (var6_6.getBatchSize() != 0) break block29;
            try {
                var16_18 = var11_12.getResponse();
                var17_26 = var11_12.getSearchResults();
                try {
                    this.checkSearchMsg(var7_7, var16_18, var6_6, var1_1, var2_2, var3_3, var4_4, var5_5);
                    ** GOTO lbl56
                }
                catch (LDAPException var18_24) {
                    block30: {
                        var19_27 = var16_18.getProtocolOp();
                        if (!(var19_27 instanceof JDAPSearchResultReference) && !(var19_27 instanceof JDAPSearchResult)) break block30;
                        System.err.println("LDAPConnection.checkSearchMsg: ignoring bad referral");
                        if (true) ** GOTO lbl56
                    }
                    throw var18_24;
                }
                do {
                    var18_22 = (JDAPMessage)var17_26.nextElement();
                    this.checkSearchMsg(var7_7, var18_22, var6_6, var1_1, var2_2, var3_3, var4_4, var5_5);
lbl56:
                    // 3 sources

                } while (var17_26.hasMoreElements());
                var15_28 = null;
                this.releaseSearchListener(var11_12);
            }
            catch (Throwable var14_16) {
                var15_29 = null;
                this.releaseSearchListener(var11_12);
                throw var14_16;
            }
        }
        var14_15 = var11_12.nextResult();
        if (var14_15 == null) {
            var14_15 = var11_12.getResponse();
            try {
                this.checkSearchMsg(var7_7, (JDAPMessage)var14_15, var6_6, var1_1, var2_2, var3_3, var4_4, var5_5);
            }
            finally {
                var16_20 = null;
                this.releaseSearchListener(var11_12);
            }
        }
        try {
            this.checkSearchMsg(var7_7, (JDAPMessage)var14_15, var6_6, var1_1, var2_2, var3_3, var4_4, var5_5);
        }
        catch (LDAPException var15_31) {
            if (var14_15.getProtocolOp() instanceof JDAPSearchResultReference) {
                System.err.println("LDAPConnection.checkSearchMsg: ignoring bad referral");
            }
            throw var15_31;
        }
        var15_32 = (LDAPControl[])LDAPConnection.getOption(12, var6_6);
        var16_17 = 0;
        while (var15_32 != null && var16_17 < var15_32.length) {
            if (var15_32[var16_17].getClass().getName().equals("netscape.ldap.controls.LDAPPersistSearchControl")) {
                var7_7.associatePersistentSearch(var11_12);
                return var7_7;
            }
            ++var16_17;
        }
        var7_7.associate(var11_12);
        return var7_7;
    }

    /*
     * Unable to fully structure code
     */
    void checkSearchMsg(LDAPSearchResults var1_1, JDAPMessage var2_2, LDAPSearchConstraints var3_3, String var4_4, int var5_5, String var6_6, String[] var7_7, boolean var8_8) throws LDAPException {
        try {
            this.checkMsg(var2_2);
            if (var2_2.getProtocolOp().getType() != 5) {
                var1_1.add(var2_2.getProtocolOp());
                return;
            }
        }
        catch (LDAPReferralException var9_9) {
            var10_11 = new Vector<E>();
            this.performReferrals(var9_9, var3_3, 3, var4_4, var5_5, var6_6, var7_7, var8_8, null, null, null, var10_11);
            var11_12 = 0;
            ** while (var11_12 < var10_11.size())
        }
lbl-1000:
        // 1 sources

        {
            var1_1.addReferralEntries((LDAPSearchResults)var10_11.elementAt(var11_12));
            ++var11_12;
            continue;
        }
lbl15:
        // 1 sources

        var10_11 = null;
        return;
        catch (LDAPException var9_10) {
            if (var9_10.getLDAPResultCode() == 11 || var9_10.getLDAPResultCode() == 3 || var9_10.getLDAPResultCode() == 4) {
                var1_1.add(var9_10);
                return;
            }
            throw var9_10;
        }
    }

    public boolean compare(String string, LDAPAttribute lDAPAttribute) throws LDAPException {
        return this.compare(string, lDAPAttribute, this.defaultConstraints);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compare(String string, LDAPAttribute lDAPAttribute, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPResponseListener lDAPResponseListener;
        block10: {
            boolean bl;
            block9: {
                this.bind(lDAPSearchConstraints);
                lDAPResponseListener = this.getResponseListener();
                Enumeration enumeration = lDAPAttribute.getByteValues();
                byte[] byArray = (byte[])enumeration.nextElement();
                String string2 = "";
                try {
                    string2 = new String(byArray, "UTF8");
                }
                catch (Throwable throwable) {}
                JDAPAVA jDAPAVA = new JDAPAVA(lDAPAttribute.getName(), string2);
                try {
                    try {
                        this.sendRequest(new JDAPCompareRequest(string, jDAPAVA), lDAPResponseListener, lDAPSearchConstraints);
                        JDAPMessage jDAPMessage = lDAPResponseListener.getResponse();
                        int n = ((JDAPResult)((Object)jDAPMessage.getProtocolOp())).getResultCode();
                        if (n == 5) {
                            boolean bl2 = false;
                            Object var12_15 = null;
                            this.releaseResponseListener(lDAPResponseListener);
                            return bl2;
                        }
                        if (n == 6) {
                            bl = true;
                            break block9;
                        }
                        this.checkMsg(jDAPMessage);
                        break block10;
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                        Vector vector = new Vector();
                        this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 14, string, 0, null, null, false, null, null, lDAPAttribute, vector);
                        boolean bl3 = false;
                        if (vector.size() > 0) {
                            bl3 = (Boolean)vector.elementAt(0);
                        }
                        vector = null;
                        boolean bl4 = bl3;
                        Object var12_17 = null;
                        this.releaseResponseListener(lDAPResponseListener);
                        return bl4;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    this.releaseResponseListener(lDAPResponseListener);
                    throw throwable;
                }
            }
            Object var12_16 = null;
            this.releaseResponseListener(lDAPResponseListener);
            return bl;
        }
        Object var12_18 = null;
        this.releaseResponseListener(lDAPResponseListener);
        return false;
    }

    public void add(LDAPEntry lDAPEntry) throws LDAPException {
        this.add(lDAPEntry, this.defaultConstraints);
    }

    public void add(LDAPEntry lDAPEntry, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.bind(lDAPSearchConstraints);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[lDAPAttributeSet.size()];
        int n = 0;
        while (n < lDAPAttributeSet.size()) {
            lDAPAttributeArray[n] = lDAPAttributeSet.elementAt(n);
            ++n;
        }
        try {
            try {
                this.sendRequest(new JDAPAddRequest(lDAPEntry.getDN(), lDAPAttributeArray), lDAPResponseListener, lDAPSearchConstraints);
                JDAPMessage jDAPMessage = lDAPResponseListener.getResponse();
                this.checkMsg(jDAPMessage);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 8, null, 0, null, null, false, null, lDAPEntry, null, null);
            }
            Object var9_9 = null;
            this.releaseResponseListener(lDAPResponseListener);
            return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation lDAPExtendedOperation) throws LDAPException {
        return this.extendedOperation(lDAPExtendedOperation, this.defaultConstraints);
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        String string;
        this.bind(lDAPSearchConstraints);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        JDAPMessage jDAPMessage = null;
        byte[] byArray = null;
        try {
            try {
                this.sendRequest(new JDAPExtendedRequest(lDAPExtendedOperation.getID(), lDAPExtendedOperation.getValue()), lDAPResponseListener, lDAPSearchConstraints);
                jDAPMessage = lDAPResponseListener.getResponse();
                this.checkMsg(jDAPMessage);
                JDAPExtendedResponse jDAPExtendedResponse = (JDAPExtendedResponse)jDAPMessage.getProtocolOp();
                byArray = jDAPExtendedResponse.getValue();
                string = jDAPExtendedResponse.getID();
            }
            catch (LDAPReferralException lDAPReferralException) {
                LDAPExtendedOperation lDAPExtendedOperation2 = this.performExtendedReferrals(lDAPReferralException, lDAPSearchConstraints, lDAPExtendedOperation);
                Object var9_10 = null;
                this.releaseResponseListener(lDAPResponseListener);
                return lDAPExtendedOperation2;
            }
            Object var9_11 = null;
            this.releaseResponseListener(lDAPResponseListener);
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
        return new LDAPExtendedOperation(string, byArray);
    }

    public void modify(String string, LDAPModification lDAPModification) throws LDAPException {
        this.modify(string, lDAPModification, this.defaultConstraints);
    }

    public void modify(String string, LDAPModification lDAPModification, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPModification[] lDAPModificationArray = new LDAPModification[]{lDAPModification};
        this.modify(string, lDAPModificationArray, lDAPSearchConstraints);
    }

    public void modify(String string, LDAPModificationSet lDAPModificationSet) throws LDAPException {
        this.modify(string, lDAPModificationSet, this.defaultConstraints);
    }

    public void modify(String string, LDAPModificationSet lDAPModificationSet, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPModification[] lDAPModificationArray = new LDAPModification[lDAPModificationSet.size()];
        int n = 0;
        while (n < lDAPModificationSet.size()) {
            lDAPModificationArray[n] = lDAPModificationSet.elementAt(n);
            ++n;
        }
        this.modify(string, lDAPModificationArray, lDAPSearchConstraints);
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray) throws LDAPException {
        this.modify(string, lDAPModificationArray, this.defaultConstraints);
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.bind(lDAPSearchConstraints);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        JDAPMessage jDAPMessage = null;
        try {
            try {
                this.sendRequest(new JDAPModifyRequest(string, lDAPModificationArray), lDAPResponseListener, lDAPSearchConstraints);
                jDAPMessage = lDAPResponseListener.getResponse();
                this.checkMsg(jDAPMessage);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 6, string, 0, null, null, false, lDAPModificationArray, null, null, null);
            }
            Object var7_7 = null;
            this.releaseResponseListener(lDAPResponseListener);
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    public void delete(String string) throws LDAPException {
        this.delete(string, this.defaultConstraints);
    }

    public void delete(String string, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.bind(lDAPSearchConstraints);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        try {
            try {
                this.sendRequest(new JDAPDeleteRequest(string), lDAPResponseListener, lDAPSearchConstraints);
                JDAPMessage jDAPMessage = lDAPResponseListener.getResponse();
                this.checkMsg(jDAPMessage);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 10, string, 0, null, null, false, null, null, null, null);
            }
            Object var6_6 = null;
            this.releaseResponseListener(lDAPResponseListener);
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    public void rename(String string, String string2, boolean bl) throws LDAPException {
        this.rename(string, string2, null, bl);
    }

    public void rename(String string, String string2, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.rename(string, string2, null, bl, lDAPSearchConstraints);
    }

    public void rename(String string, String string2, String string3, boolean bl) throws LDAPException {
        this.rename(string, string2, string3, bl, this.defaultConstraints);
    }

    public void rename(String string, String string2, String string3, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.bind(lDAPSearchConstraints);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        try {
            try {
                JDAPModifyRDNRequest jDAPModifyRDNRequest = null;
                jDAPModifyRDNRequest = string3 != null ? new JDAPModifyRDNRequest(string, string2, bl, string3) : new JDAPModifyRDNRequest(string, string2, bl);
                this.sendRequest(jDAPModifyRDNRequest, lDAPResponseListener, lDAPSearchConstraints);
                JDAPMessage jDAPMessage = lDAPResponseListener.getResponse();
                this.checkMsg(jDAPMessage);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 12, string, 0, string2, null, bl, null, null, null, null);
            }
            Object var9_10 = null;
            this.releaseResponseListener(lDAPResponseListener);
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    public Object getOption(int n) throws LDAPException {
        if (n == 17) {
            return new Integer(this.protocolVersion);
        }
        return LDAPConnection.getOption(n, this.defaultConstraints);
    }

    private static Object getOption(int n, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        switch (n) {
            case 2: {
                return new Integer(lDAPSearchConstraints.getDereference());
            }
            case 3: {
                return new Integer(lDAPSearchConstraints.getMaxResults());
            }
            case 4: {
                return new Integer(lDAPSearchConstraints.getTimeLimit());
            }
            case 8: {
                return new Boolean(lDAPSearchConstraints.getReferrals());
            }
            case 9: {
                return lDAPSearchConstraints.getRebindProc();
            }
            case 10: {
                return new Integer(lDAPSearchConstraints.getHopLimit());
            }
            case 20: {
                return new Integer(lDAPSearchConstraints.getBatchSize());
            }
            case 11: {
                return lDAPSearchConstraints.getClientControls();
            }
            case 12: {
                return lDAPSearchConstraints.getServerControls();
            }
            case 30: {
                return new Integer(lDAPSearchConstraints.getMaxBacklog());
            }
        }
        throw new LDAPException("invalid option", 89);
    }

    public void setOption(int n, Object object) throws LDAPException {
        int n2;
        if (n == 17) {
            this.setProtocolVersion((Integer)object);
            return;
        }
        LDAPConnection.setOption(n, object, this.defaultConstraints);
        if (n == 30 && this.th != null && (n2 = ((Integer)object).intValue()) >= 1) {
            this.th.setMaxBacklog(n2);
        }
    }

    private static void setOption(int n, Object object, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        try {
            switch (n) {
                case 2: {
                    lDAPSearchConstraints.setDereference((Integer)object);
                    return;
                }
                case 3: {
                    lDAPSearchConstraints.setMaxResults((Integer)object);
                    return;
                }
                case 4: {
                    lDAPSearchConstraints.setTimeLimit((Integer)object);
                    return;
                }
                case 8: {
                    lDAPSearchConstraints.setReferrals((Boolean)object);
                    return;
                }
                case 9: {
                    lDAPSearchConstraints.setRebindProc((LDAPRebind)object);
                    return;
                }
                case 10: {
                    lDAPSearchConstraints.setHopLimit((Integer)object);
                    return;
                }
                case 20: {
                    lDAPSearchConstraints.setBatchSize((Integer)object);
                    return;
                }
                case 11: {
                    if (object == null) {
                        lDAPSearchConstraints.setClientControls((LDAPControl[])null);
                        return;
                    }
                    if (object instanceof LDAPControl) {
                        lDAPSearchConstraints.setClientControls((LDAPControl)object);
                        return;
                    }
                    if (object instanceof LDAPControl[]) {
                        lDAPSearchConstraints.setClientControls((LDAPControl[])object);
                        return;
                    }
                    throw new LDAPException("invalid LDAPControl", 89);
                }
                case 12: {
                    if (object == null) {
                        lDAPSearchConstraints.setServerControls((LDAPControl[])null);
                        return;
                    }
                    if (object instanceof LDAPControl) {
                        lDAPSearchConstraints.setServerControls((LDAPControl)object);
                        return;
                    }
                    if (object instanceof LDAPControl[]) {
                        lDAPSearchConstraints.setServerControls((LDAPControl[])object);
                        return;
                    }
                    throw new LDAPException("invalid LDAPControl", 89);
                }
                case 30: {
                    int n2 = (Integer)object;
                    if (n2 < 1) {
                        throw new LDAPException("MAXBACKLOG must be at least 1", 89);
                    }
                    lDAPSearchConstraints.setMaxBacklog((Integer)object);
                    return;
                }
            }
            throw new LDAPException("invalid option", 89);
        }
        catch (ClassCastException classCastException) {
            throw new LDAPException("invalid option value", 89);
        }
    }

    public LDAPControl[] getResponseControls() {
        LDAPControl[] lDAPControlArray = null;
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            Vector vector = (Vector)this.m_responseControlTable.get(this.th);
            if (vector != null) {
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    ResponseControl responseControl = (ResponseControl)vector.elementAt(n);
                    if (responseControl.getConnection().equals(this)) {
                        lDAPControlArray = responseControl.getControls();
                        vector.removeElementAt(n);
                        break;
                    }
                    ++n;
                }
            }
        }
        return lDAPControlArray;
    }

    public LDAPSearchConstraints getSearchConstraints() {
        return this.defaultConstraints;
    }

    private synchronized LDAPResponseListener getResponseListener() {
        LDAPResponseListener lDAPResponseListener;
        if (this.responseListeners == null) {
            this.responseListeners = new Vector(5);
        }
        if (this.responseListeners.size() < 1) {
            lDAPResponseListener = new LDAPResponseListener(this);
        } else {
            lDAPResponseListener = (LDAPResponseListener)this.responseListeners.elementAt(0);
            this.responseListeners.removeElementAt(0);
        }
        return lDAPResponseListener;
    }

    private synchronized LDAPSearchListener getSearchListener(LDAPSearchConstraints lDAPSearchConstraints) {
        LDAPSearchListener lDAPSearchListener;
        if (this.searchListeners == null) {
            this.searchListeners = new Vector(5);
        }
        if (this.searchListeners.size() < 1) {
            lDAPSearchListener = new LDAPSearchListener(this, lDAPSearchConstraints);
        } else {
            lDAPSearchListener = (LDAPSearchListener)this.searchListeners.elementAt(0);
            this.searchListeners.removeElementAt(0);
        }
        return lDAPSearchListener;
    }

    private synchronized void releaseResponseListener(LDAPResponseListener lDAPResponseListener) {
        if (this.responseListeners == null) {
            this.responseListeners = new Vector(5);
        }
        lDAPResponseListener.reset();
        this.responseListeners.addElement(lDAPResponseListener);
    }

    synchronized void releaseSearchListener(LDAPSearchListener lDAPSearchListener) {
        if (this.searchListeners == null) {
            this.searchListeners = new Vector(5);
        }
        lDAPSearchListener.reset();
        this.searchListeners.addElement(lDAPSearchListener);
    }

    void checkMsg(JDAPMessage jDAPMessage) throws LDAPException {
        if (jDAPMessage.getProtocolOp() instanceof JDAPResult) {
            JDAPResult jDAPResult = (JDAPResult)((Object)jDAPMessage.getProtocolOp());
            int n = jDAPResult.getResultCode();
            if (n == 0) {
                return;
            }
            if (n == 10) {
                throw new LDAPReferralException("referral", n, jDAPResult.getReferrals());
            }
            if (n == 9) {
                throw new LDAPReferralException("referral", n, jDAPResult.getErrorMessage());
            }
            throw new LDAPException("error result", n, jDAPResult.getErrorMessage(), jDAPResult.getMatchedDN());
        }
        if (jDAPMessage.getProtocolOp() instanceof JDAPSearchResultReference) {
            String[] stringArray = ((JDAPSearchResultReference)jDAPMessage.getProtocolOp()).getUrls();
            throw new LDAPReferralException("referral", 0, stringArray);
        }
    }

    void setResponseControls(LDAPConnThread lDAPConnThread, ResponseControl responseControl) {
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            Object object;
            Vector<ResponseControl> vector = (Vector<ResponseControl>)this.m_responseControlTable.get(lDAPConnThread);
            if (vector != null && vector.size() > 0) {
                int n = vector.size() - 1;
                while (n >= 0) {
                    object = (ResponseControl)vector.elementAt(n);
                    if (((ResponseControl)object).getConnection().equals(this) && (responseControl == null || responseControl.getMsgID() != ((ResponseControl)object).getMsgID())) {
                        vector.removeElement(object);
                    }
                    --n;
                }
            } else if (responseControl != null) {
                vector = new Vector<ResponseControl>();
            }
            if (responseControl != null) {
                vector.addElement(responseControl);
                this.m_responseControlTable.put(lDAPConnThread, vector);
            }
            Enumeration enumeration = this.m_attachedList.elements();
            while (enumeration.hasMoreElements()) {
                object = (LDAPConnThread)enumeration.nextElement();
                if (((Thread)object).isAlive()) continue;
                this.m_responseControlTable.remove(object);
                this.m_attachedList.removeElement(object);
            }
        }
        if (this.m_attachedList.indexOf(lDAPConnThread) < 0) {
            this.m_attachedList.addElement(lDAPConnThread);
        }
    }

    private LDAPConnection prepareReferral(LDAPUrl lDAPUrl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPConnection lDAPConnection = new LDAPConnection(this.getSocketFactory());
        lDAPConnection.setOption(8, new Boolean(true));
        lDAPConnection.setOption(9, lDAPSearchConstraints.getRebindProc());
        lDAPConnection.setOption(17, new Integer(this.protocolVersion));
        lDAPConnection.setOption(10, new Integer(lDAPSearchConstraints.getHopLimit() - 1));
        lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort());
        return lDAPConnection;
    }

    LDAPConnection createReferralConnection(LDAPReferralException lDAPReferralException, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        if (lDAPSearchConstraints.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", lDAPReferralException.getLDAPResultCode(), lDAPReferralException.getLDAPErrorMessage());
        }
        if (!lDAPSearchConstraints.getReferrals()) {
            throw lDAPReferralException;
        }
        LDAPUrl[] lDAPUrlArray = lDAPReferralException.getURLs();
        if (lDAPUrlArray == null || lDAPUrlArray.length <= 0 || lDAPUrlArray[0].equals("")) {
            throw new LDAPException("No target URL in referral", 94);
        }
        LDAPConnection lDAPConnection = null;
        lDAPConnection = this.prepareReferral(lDAPUrlArray[0], lDAPSearchConstraints);
        String string = lDAPUrlArray[0].getDN();
        if (string == null || string.equals("")) {
            string = this.boundDN;
        }
        lDAPConnection.authenticate(this.protocolVersion, string, this.boundPasswd);
        return lDAPConnection;
    }

    void performReferrals(LDAPReferralException lDAPReferralException, LDAPSearchConstraints lDAPSearchConstraints, int n, String string, int n2, String string2, String[] stringArray, boolean bl, LDAPModification[] lDAPModificationArray, LDAPEntry lDAPEntry, LDAPAttribute lDAPAttribute, Vector vector) throws LDAPException {
        if (lDAPSearchConstraints.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", lDAPReferralException.getLDAPResultCode(), lDAPReferralException.getLDAPErrorMessage());
        }
        if (!lDAPSearchConstraints.getReferrals()) {
            if (n == 3) {
                LDAPSearchResults lDAPSearchResults = new LDAPSearchResults();
                lDAPSearchResults.add(lDAPReferralException);
                vector.addElement(lDAPSearchResults);
                return;
            }
            throw lDAPReferralException;
        }
        LDAPUrl[] lDAPUrlArray = lDAPReferralException.getURLs();
        if (lDAPUrlArray == null) {
            return;
        }
        int n3 = 0;
        while (n3 < lDAPUrlArray.length) {
            block11: {
                LDAPSearchConstraints lDAPSearchConstraints2;
                String string3;
                block10: {
                    String string4 = lDAPUrlArray[n3].getDN();
                    string3 = null;
                    string3 = string4 == null || string4.equals("") ? string : string4;
                    if (lDAPUrlArray[n3].getUrl().indexOf("?base") > -1) {
                        n2 = 0;
                    }
                    lDAPSearchConstraints2 = (LDAPSearchConstraints)lDAPSearchConstraints.clone();
                    lDAPSearchConstraints2.setHopLimit(lDAPSearchConstraints.getHopLimit() - 1);
                    try {
                        if (this.m_referralConnection == null || !lDAPUrlArray[n3].getHost().equals(this.m_referralConnection.host) || lDAPUrlArray[n3].getPort() != this.m_referralConnection.port) break block10;
                        this.performReferrals(this.m_referralConnection, lDAPSearchConstraints2, n, string3, n2, string2, stringArray, bl, lDAPModificationArray, lDAPEntry, lDAPAttribute, vector);
                        break block11;
                    }
                    catch (LDAPException lDAPException) {
                        if (lDAPException.getLDAPResultCode() == 50) break block10;
                        throw lDAPException;
                    }
                }
                LDAPConnection lDAPConnection = null;
                lDAPConnection = this.prepareReferral(lDAPUrlArray[n3], lDAPSearchConstraints);
                if (lDAPSearchConstraints.getRebindProc() == null) {
                    lDAPConnection.authenticate(null, null);
                } else {
                    LDAPRebindAuth lDAPRebindAuth = lDAPSearchConstraints.getRebindProc().getRebindAuthentication(lDAPUrlArray[n3].getHost(), lDAPUrlArray[n3].getPort());
                    lDAPConnection.authenticate(lDAPRebindAuth.getDN(), lDAPRebindAuth.getPassword());
                }
                this.performReferrals(lDAPConnection, lDAPSearchConstraints2, n, string3, n2, string2, stringArray, bl, lDAPModificationArray, lDAPEntry, lDAPAttribute, vector);
            }
            ++n3;
        }
    }

    /*
     * Exception decompiling
     */
    void performReferrals(LDAPConnection var1_1, LDAPSearchConstraints var2_2, int var3_3, String var4_4, int var5_5, String var6_6, String[] var7_7, boolean var8_8, LDAPModification[] var9_9, LDAPEntry var10_10, LDAPAttribute var11_11, Vector var12_12) throws LDAPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LDAPExtendedOperation performExtendedReferrals(LDAPReferralException lDAPReferralException, LDAPSearchConstraints lDAPSearchConstraints, LDAPExtendedOperation lDAPExtendedOperation) throws LDAPException {
        if (lDAPSearchConstraints.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", lDAPReferralException.getLDAPResultCode(), lDAPReferralException.getLDAPErrorMessage());
        }
        if (!lDAPSearchConstraints.getReferrals()) {
            throw lDAPReferralException;
        }
        LDAPUrl[] lDAPUrlArray = lDAPReferralException.getURLs();
        if (lDAPUrlArray == null) {
            return null;
        }
        int n = 0;
        while (n < lDAPUrlArray.length) {
            try {
                LDAPConnection lDAPConnection = this.prepareReferral(lDAPUrlArray[n], lDAPSearchConstraints);
                LDAPExtendedOperation lDAPExtendedOperation2 = lDAPConnection.extendedOperation(lDAPExtendedOperation);
                lDAPConnection.disconnect();
                return lDAPExtendedOperation2;
            }
            catch (LDAPException lDAPException) {
                ++n;
            }
        }
        return null;
    }

    public synchronized Object clone() {
        try {
            LDAPConnection lDAPConnection = (LDAPConnection)super.clone();
            if (this.th == null) {
                this.bind(this.defaultConstraints);
            }
            lDAPConnection.defaultConstraints = (LDAPSearchConstraints)this.defaultConstraints.clone();
            lDAPConnection.responseListeners = null;
            lDAPConnection.searchListeners = null;
            lDAPConnection.bound = this.bound;
            lDAPConnection.host = this.host;
            lDAPConnection.port = this.port;
            lDAPConnection.boundDN = this.boundDN;
            lDAPConnection.boundPasswd = this.boundPasswd;
            lDAPConnection.prevBoundDN = this.prevBoundDN;
            lDAPConnection.prevBoundPasswd = this.prevBoundPasswd;
            lDAPConnection.m_anonymousBound = this.m_anonymousBound;
            lDAPConnection.m_factory = this.m_factory;
            lDAPConnection.th = this.th;
            Hashtable hashtable = m_threadConnTable;
            synchronized (hashtable) {
                Vector vector = (Vector)m_threadConnTable.get(this.th);
                if (vector == null) {
                    LDAPConnection.printDebug("Failed to clone");
                    Object var2_4 = null;
                    Object var4_5 = null;
                    return var2_4;
                }
                vector.addElement(lDAPConnection);
            }
            lDAPConnection.th.register(lDAPConnection);
            return lDAPConnection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    void resultRetrieved() {
        if (this.th != null) {
            this.th.resultRetrieved();
        }
    }

    private static boolean checkCommunicator() {
        try {
            Method method = LDAPCheckComm.getMethod("netscape.security.PrivilegeManager", "enablePrivilege");
            if (method == null) {
                LDAPConnection.printDebug("Method is null");
                return false;
            }
            Object[] objectArray = new Object[]{new String("UniversalConnect")};
            method.invoke(null, objectArray);
            LDAPConnection.printDebug("UniversalConnect enabled");
            return true;
        }
        catch (LDAPException lDAPException) {
            LDAPConnection.printDebug("Exception: " + lDAPException.toString());
        }
        catch (Exception exception) {
            LDAPConnection.printDebug("Exception on invoking enablePrivilege: " + exception.toString());
        }
        return false;
    }

    public static boolean isNetscape() {
        return isCommunicator;
    }

    static void printDebug(String string) {
    }

    public static void main(String[] stringArray) {
        System.out.println("LDAP SDK Version is " + SdkVersion);
        System.out.println("LDAP Protocol Version is " + ProtocolVersion);
    }
}

