#include <pthread.h>
#include "misc.h"
#include "gui.h"

#ifdef BXZVT
ZvtTerm		*mainviewport;
int		mainpipe[2];
#endif
GtkWidget	*mainwindow,
#ifndef BXZVT
		*mainviewport,
#endif
		*mainmenubar,
		*mainscroller,
		*mainbox;
GdkFont		*mainfont;
GtkAdjustment	*mainadjust;
#ifndef BXZVT
char		mainansibuf[20];
#endif

/* Theses variables are used for interthread communication and 
   synchronization */
gint            gtkio;
int gtkipcin[2], guiipc[2];
pthread_t gtkthread;
int gtk_duringwrite=0;
extern fd_set 	readables;

/* These are for $lastclickline() function */
char *lastclicklinedata = NULL;
int lastclickcol, lastclickrow;
int contextx, contexty;

/* Used by the scroller bars */
int newscrollerpos, lastscrollerpos, lastscrollerwindow;
unsigned long menucmd;

/* needed for rclick */
#include "keys.h"
void wm_process(int param);
unsigned long menucmd;   

MenuStruct *findmenu(char *menuname);
int gtk_getx(void);
int gtk_gety(void);
void newmenubar(Screen *menuscreen, MenuStruct *menutoadd);
void output_info(char *buffer, int t);

#define WIDTH	10

GdkColor colors[] =
{
	{ 0, 0, 0, 0 },                /* 0  black */
	{ 0, 0xbbbb, 0, 0 },	       /* 1  red */
	{ 0, 0, 0xbbbb, 0 },           /* 2  green */
	{ 0, 0xaaaa, 0xaaaa, 0 },      /* 3  yellow */
	{ 0, 0, 0, 0xcccc }, 	       /* 4  blue */
	{ 0, 0xbbbb, 0, 0xbbbb },      /* 5  magenta */
	{ 0, 0, 0xbbbb, 0xbbbb },      /* 6  cyan */
	{ 0, 0xaaaa, 0xaaaa, 0xaaaa }, /* 7  white */
	{ 0, 0x7777, 0x7777, 0x7777 }, /* 8  grey */
	{ 0, 0xffff, 0, 0 },	       /* 9  bright red */
	{ 0, 0, 0xffff, 0 }, 	       /* 10 bright green */
	{ 0, 0xeeee, 0xeeee, 0 },      /* 11 bright yellow */
	{ 0, 0, 0, 0xffff },	       /* 12 bright blue */
	{ 0, 0xffff, 0, 0xffff },      /* 13 bright magenta */
	{ 0, 0, 0xeeee, 0xeeee },      /* 14 bright cyan */
	{ 0, 0xffff, 0xffff, 0xffff }, /* 15 bright white */
};

/* Find the screen of the Window that generated an event */
Screen *findscreen(GtkWidget *widget)
{
Screen *tmp;

	for(tmp = screen_list; tmp; tmp = tmp->next)
		{
		if(widget == tmp->window)
			return tmp;
		}
	return NULL;
}

/* Determine the most space the font will occupy, 
   fixed size fonts are recommended. */
void gtk_maxfont(Screen *thisscreen)
{
int z, cursize;
	
	thisscreen->maxfontwidth=0;
	for(z=0;z<256;z++)
		{
		cursize = gdk_char_width(thisscreen->font, (gchar)z);
		if(cursize > thisscreen->maxfontwidth)
			thisscreen->maxfontwidth = cursize;
		}
	thisscreen->maxfontheight=0;
	for(z=0;z<256;z++)
		{
		cursize = gdk_char_height(thisscreen->font, (gchar)z);
		if(cursize > thisscreen->maxfontheight)
			thisscreen->maxfontheight = cursize;
		}
}

/* This gets called when a window close event occurs, if it is the last
   active window, kill_screen will exit the application if WINDOW_CREATE
   is defined.  Otherwise it gets passed on to destroy.  */		
gint window_destroy(GtkWidget *widget, GdkEvent *event, gpointer data)
{
#ifdef WINDOW_CREATE
Screen *closescreen;

	if((closescreen = findscreen(widget))!=NULL)
		kill_screen(closescreen);
	return TRUE;
#else 
	return FALSE;
#endif
}

/* This should not get called unless WINDOW_CREATE isn't defined */
void destroy(GtkWidget *widget, gpointer data)
{
	irc_exit(1, "gtkBitchX rocks your world!", NULL);
}

/* Write a formatted string to the output_screen */
int gtkprintf(char *format, ...) 
{
va_list args;
char    putbuf[4000];
      
	va_start(args, format);
	vsprintf(putbuf, format, args);
	va_end(args);

	gdk_threads_enter();
	output_info(putbuf, strlen(putbuf));
	gdk_threads_leave();
	return strlen(putbuf);
}            
                                                                                                                                                                          
/* Write a character to the current output_screen */
int gtkputc(int c)
{
   if((char)c == '\r')
   	return 1;
   gdk_threads_enter();
   output_info((char *)&c, 1);
   gdk_threads_leave();
   return 1;
}

/* This gets called on a keypress event and writes it to the input queue */
gint gtk_keypress(GtkWidget *widget, GdkEventKey *event, gpointer data)
{
if(gtkipcin[1])
	write(gtkipcin[1], event->string, strlen(event->string));
return TRUE;
}

#ifndef BXZVT
/* Clears the gtk text presentation space */
void gtk_clrscr(Screen *clrscreen)
{
int len;

len=gtk_text_get_length(GTK_TEXT(clrscreen ? clrscreen->viewport : mainviewport));
gtk_text_set_point(GTK_TEXT(clrscreen ? clrscreen->viewport : mainviewport), 0);
gtk_text_forward_delete(GTK_TEXT(clrscreen ? clrscreen->viewport : mainviewport), len);
}

/* gtk Clear End of Line */
void gtk_clreol(void)
{
int pos, len, z;

pos = gtk_text_get_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
len = gtk_text_get_length(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));

z=0;
while((z+pos-1)<len)
	{
	if(GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), z+pos)=='\n')
		break;
	z++;
	}
if(z-1 > 0)
	gtk_text_forward_delete(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), z-1);
}
		
/* Position the write position at a x - y coordinate */
void gtk_gotoxy(int x, int y)
{
int cx=0, cy=0, z, len, t;

if(x<0 || y<0)
	return;
	
len = gtk_text_get_length(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
for(z=0;z<len;z++)
	{
	if(GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), z) == '\n')
		{
		if(cy != y)
			cx=0;
		cy++;
		}
	else
		cx++;
	if((cx == x && cy == y) || cy > y)
		break;
	}
	
if(cy < y)
	{
	gtk_text_set_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), z);
	for(t=0;t<(y-cy);t++)
		gtk_text_insert(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), output_screen ? output_screen->font : mainfont, &colors[WHITE], &colors[BLACK], "\n", 1);
	z=z+t;
	len=gtk_text_get_length(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
	/*z=z+t-1*/
	cx=0;
	}

if(z<len)	
	gtk_text_set_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), z+1);
	
if(cx < x)
	{
	for(t=0;t<(x-cx);t++)
		gtk_text_insert(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), output_screen ? output_screen->font : mainfont, &colors[WHITE], &colors[BLACK], " ", 1);
	}
}

/* Move the current write position back n characters */
void gtk_backward(int n)
{
int pos, k=0;

pos = gtk_text_get_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
if(n>pos)
	n=pos;
while(pos>-1 && k<n)
	{
	if(GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), pos)=='\n')
		{
		pos++;
		break;
		}
	pos--;
	k++;
	}
gtk_text_set_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), pos);
}

/* Move the current write position forward n characters */
void gtk_forward(int n)
{
int pos, z, k, j, len;

pos = gtk_text_get_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
len = gtk_text_get_length(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));

z=0;k=0;
while((z+pos)<len)
	{
	if(GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), z+pos)=='\n')
		{
		z--;k--;
		break;
		}
	z++;
	k++;
	}
gtk_text_set_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), z+pos);
if(k<n)
	{
	for(j=0;j<n-k;j++)
		gtk_text_insert(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), output_screen ? output_screen->font : mainfont, &colors[WHITE], &colors[BLACK], " ", 1);
	}	
}

/* Emulate a char 8 backspace character */
void gtk_backspace(void)
{
int pos;

pos = gtk_text_get_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));

if(pos > 0 && GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), pos-1)!='\n')
	{
	gtk_text_set_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), pos-1);
	gtk_text_forward_delete(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), 1);
	gtk_text_insert(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), output_screen ? output_screen->font : mainfont, &colors[WHITE], &colors[BLACK], " ", 1);
	gtk_text_set_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), pos);
	}
}

/* Scroll the gtk text between top and bot n lines. */
void gtk_scroll(int top, int bot, int n)
{
int z, len, chars=0, position=0, lines=0, dellines=0;

len=gtk_text_get_length(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));

gtk_text_freeze(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));

while(position < len && lines < top)
	{
	if(GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), position)=='\n')
		lines++;
	position++;
	}
if(lines == top)
	{
	gtk_text_set_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), position);
	while(position < len && dellines < n)
		{
		if(GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), position)=='\n')
			dellines++;
		position++;
		chars++;
		}
	gtk_text_forward_delete(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), chars);
	}
dellines=0;
len = gtk_text_get_length(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
position = gtk_text_get_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
while(position < len && dellines < (bot-top-n+1))
	{
	if(GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), position) == '\n')
		dellines++;
	position++;
	}
gtk_text_set_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), position);
for(z=0;z<n;z++)
	gtk_text_insert(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), output_screen ? output_screen->font : mainfont, &colors[WHITE], &colors[BLACK], "\n", 1);

gtk_text_thaw(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
}

/* Get the current line of the write position */
int gtk_gety(void)
{
int z, pos, curline=0;

pos = gtk_text_get_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));

for(z=0; z<pos; z++)
	{
	if(GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), z)=='\n')
		curline++;
	}
return curline;
}

/* Get the current column of the write position */
int gtk_getx(void)
{
int z, pos, curcol=0;

pos = gtk_text_get_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));

for(z=pos-1;z>-1;z--)
	{
	if(GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), z)=='\n')
		break;
	curcol++;
	}
return curcol;
}

/* If any lines are wider than the physical space add newlines */
void gtk_fixnewlines(void)
{
int len, curx=0, pos, z;

len = gtk_text_get_length(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
pos = gtk_text_get_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));

for(z=0;z<len;z++)
	{
	if(GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), z)=='\n')
		curx=-1;
	if(curx ==  (output_screen ? output_screen->co : 25))
		{
		gtk_text_set_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), z);
		gtk_text_insert(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), output_screen ? output_screen->font : mainfont, output_screen ? &colors[output_screen->fg] : &colors[WHITE], output_screen ? &colors[output_screen->bg] : &colors[BLACK], "\n", 1);
		len++;
		if(z<pos)
			pos++;
		curx=-1;
		}
	curx++;
	}
gtk_text_set_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), pos);	
}

/* Write text to the gtk presentation space */
void gtk_write(char *buffer, int t)
{   
int z, pos, len, chars=0, lines=0, curline=0, curchar=0;

	pos = gtk_text_get_point(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
	len = gtk_text_get_length(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
	
	/* Count the number of lines/chars to add */
	for(z=0;z<t;z++)
		{
		chars++;
		if(buffer[z] == '\n')
			{
			lines++;
			chars=0;
			}
		}

	curline = gtk_gety();
	
	/* If we are going to scroll off the physical viewport, delete the
	   necessary lines from the top of the viewport to scroll up. */
	
	/*if(curline+lines > (output_screen ? output_screen->li : 25))
		gtk_scroll(0, (output_screen ? output_screen->li : 25), (curline+lines) - (output_screen ? output_screen->li : 24));*/
	
	/* Determine number of chars to delete */
	z=0;curline=0;
	while(curline < lines && (pos+z) < len)
		{
		if(GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), pos+z)=='\n')
			curline++;
		z++;
		}
	if(curline == lines && chars > 0)
		{
		while(curchar<chars && (z+pos) < len)
			{
			if(GTK_TEXT_INDEX(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport),pos+z) == '\n')
				{
				z--;
				break;
				}
			z++;
			curchar++;
			}
		}
        	gtk_text_freeze(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
		if(z>0)
			gtk_text_forward_delete(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), z);
		gtk_text_insert(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport), output_screen ? output_screen->font : mainfont, output_screen ? &colors[output_screen->fg] : &colors[WHITE], output_screen ? &colors[output_screen->bg] : &colors[BLACK], buffer, t);
		gtk_text_thaw(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));

	gtk_fixnewlines();
}
#endif

/* This is the main output function, code will need to be added here to make
   sure text goes to the correct window as well as ANSI handling etc, this 
   will probably be the most complex part of gtkBitchX */

void output_info(char *buffer, int t)
{
#ifndef BXZVT
char def[20];
char buffer2[4000]; /* It really should't ever go above 200 ... but just to be safe :) */
int x=0, z=0, escape=-1, m, cstart, bright;
int params[10], nparams;

        if(!output_screen)
        	{
        	/*gtk_write(buffer, t);*/
        	return;
        	}
        	
        if(output_screen->ansibuf && *output_screen->ansibuf) /* There was a partial sequence from last time, add it to the subbuffer */
        	{
        	x = strlen(output_screen->ansibuf);
        	memcpy(buffer2, output_screen->ansibuf, x);
        	escape = 0;
        	}
        /* We are in an escape sequence but no info has been saved */
        if(output_screen->escape == 1 && escape == -1)
        	escape = 0;
        for(z=0;z<t;z++)
        	{
        	if(escape > -1) /* We are in an escape sequence, see if we have all of it */
        		{   	/* if not we will save what we have and proceed next time */
        		buffer2[x]=buffer[z];
        		/* We've got a complete ANSI sequence */
        		if((buffer2[x] >= 'a' && buffer2[x] <= 'z') || (buffer2[x] >= 'A' && buffer2[x] <= 'Z'))
        			{
       				cstart=1; 
        			nparams=0;
        			buffer2[x+1]=0;
        			strcpy(def, buffer2);
        			/*printf("ANSI Sequence: %s\n", def);*/
        			params[0]=params[1]=-1;
        			for(m=1;m<(x+1);m++)
        				{
        				if(buffer2[m]==';' || m == x || buffer2[m] == ':')
        					{
        					buffer2[m]=0;
        					if(strlen(&buffer2[cstart])>0)
        						params[nparams]=atoi(&buffer2[cstart]);
        					nparams++;
        					cstart=m+1;
        					}
        				}
        			strcpy(buffer2, def);
        			gtk_text_freeze(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
               			switch(buffer2[x]) /* Here is the miserable ANSI interpretting code :) */
        				{
 
        			  	case 'm': /* Color change sequence */
        			  	cstart=1;
        			  	for(m=0;m<nparams;m++)
        			  		{
        			  		/* Reset colors */
        			  		if(params[m] == 0)
        			  			{
        			  			output_screen->fg = WHITE;
        			  			output_screen->bg = BLACK;
        			  			}
        			  		/* Set bright attribute */
        			  		if(params[m] == 1 && output_screen->fg < 8)
        			  			output_screen->fg += 8;
        			 
        			 		/* Foreground color */
        			  		if(params[m] > 29 && params[m] < 38)
        			  			{
        			  			/* Check current bright state */
        			  			if(output_screen->fg > 7)
        			  				bright = 1;
        			  			else
        			  				bright = 0;
        			  					
        			  			output_screen->fg = params[m] - 30;
        			  			
        			  			/* If bright is on increment the foreground color */ 
        			  			if(bright == 1)
        			  				output_screen->fg += 8;
        			  			}
        			  			
        			  		/* Background color */
        			  		if(params[m] > 39 && params[m] < 48)
        			  			output_screen->bg = params[m] - 40;
        			  		}
        			  	break;
        			  	case 'C': /* Cursor Forward */
        			  	if(nparams == 1)
        			  		gtk_forward(params[0]);
        			  	else
        			  		gtk_forward(1);
        			  	break;
        			  	case 'D': /* Cursor Backward */
        			  	if(nparams == 1)
        			  		gtk_backward(params[0]);
        			  	else
        			  		gtk_backward(1);
        			  	break;
        			  	case 'J': /* Clear Screen */
        			  	if(nparams == 1 && params[0]==2)
        			  		gtk_clrscr(output_screen);
        			  	break;
        			  	case 'K':
        			  	gtk_clreol();
        			  	break;
        			  	case 'H': /* Cursor Goto xy */
        			   	params[0]--;params[1]--;
        			   	if(nparams == 0)
        			   		gtk_clrscr(output_screen);
        			   	else
        			  		gtk_gotoxy(params[1], params[0]);
        			  	break;
        			  	case 'N':
        			  	if(nparams == 3)
        			  		gtk_scroll(params[0], params[1], params[2]);
        			  	}
        			gtk_text_thaw(GTK_TEXT(output_screen ? output_screen->viewport : mainviewport));
        			/* Escape sequence has been processed, reset subbuffer and escape flag */
        			output_screen->escape = 0;
        			escape = -1;
        			x=-1;
        			}
        		x++;
        		}
        	else
        		{
        		if(buffer[z] != '\e') /* No Escape sequence, continue normally */
        			{
        			/* Handle the backspace */
        			if(buffer[z] == 8)
        				gtk_backspace();
        			else
        				{
        				buffer2[x] = buffer[z];
        				x++;
        				}
        			}
        		else	/* We have an escape sequence, write what we have in the buffer before reading it */
        			{
        			if(x!=0)
        				{
        				gtk_write(buffer2, x);
        				x=0;
        				}
        			output_screen->escape = 1;
        			escape=z;
        			}
        		}	
        	}
	if(x>0 && escape > -1 && x < 20) /* Save the partial sequence for next entry */
		{
		memcpy(output_screen->ansibuf, buffer2, x);
		output_screen->ansibuf[x] = 0;
		}
	else 
		output_screen->ansibuf[0] = 0;
	if(x>0 && escape == -1) /* Write the remaining text to the viewport */
		gtk_write(buffer2, x);
#endif
}

/* This function sets the window size to the current columns and rows */
void gtk_sizewindow(Screen *thisscreen)
{
gtk_widget_set_usize(thisscreen->viewport, (thisscreen->maxfontwidth * (thisscreen->co))+14, (thisscreen->maxfontheight * thisscreen->li)+8);
}

/* This may be going away, it replaces code which is currently elsewhere in BitchX */
void gtk_resize(Screen *this_screen)
{
        co = this_screen->co; li = this_screen->li;
             
        /* Recalculate some stuff that was done in input.c previously */
        this_screen->input_line = this_screen->li-1;
        
        this_screen->input_zone_len = this_screen->co - (WIDTH * 2);
	if (this_screen->input_zone_len < 10)
             	this_screen->input_zone_len = 10;             /* Take that! */                           
             
        this_screen->input_start_zone = WIDTH;
        this_screen->input_end_zone = this_screen->co - WIDTH;
}                  

/* This gets called when the window size event occurs */
void gtk_windowsize(GtkWidget *widget, gpointer data)
{
Screen *sizescreen;
	
	if((sizescreen = findscreen(widget))!= NULL && sizescreen->maxfontwidth > 0 && sizescreen->maxfontwidth > 0)
		{
		sizescreen->co = (int) ((sizescreen->viewport->allocation.width-14) / sizescreen->maxfontwidth);
		sizescreen->li = (int) ((sizescreen->viewport->allocation.height-8) / sizescreen->maxfontheight);
		gtk_resize(sizescreen);
		recalculate_windows(sizescreen);
		/* Send the resize message to the main thread */
		/*write(guiipc[1], "4", 1);
		write(guiipc[1], (char *)&last_input_screen->current_window->refnum, 1);
		*/
		}
}

/* This gets called when a window gets the focus */
void gtk_windowfocus(GtkWidget *widget, gpointer *data)
{
Screen *focusscreen;

	if((focusscreen = findscreen(widget))!=NULL && focusscreen->current_window)
		make_window_current(focusscreen->current_window);
}

/* This gets called when the scroller bar gets moved on a window */
void gtk_scrollerchanged(GtkWidget *widget, GtkWidget *window)
{
Screen *thisscreen;

	if((thisscreen = findscreen(window))!=NULL)
		{
		newscrollerpos=thisscreen->adjust->value;
		if(newscrollerpos<0)
			newscrollerpos=0;
		if(newscrollerpos>get_int_var(SCROLLBACK_VAR))
			newscrollerpos=get_int_var(SCROLLBACK_VAR);
		write(guiipc[1], "5", 1);
		write(guiipc[1], (char *)&thisscreen->current_window->refnum, 1);
		}
}

/* This handles right click events on the viewport */
void gtk_contextmenu(GtkWidget *widget, GdkEventButton *event, GtkWidget *window)
{
Screen *this_screen;
int statusstart;
if(event->button == 3)
	{
	if((this_screen = findscreen(window))!=NULL)
		{
		/* This will only give decent results with fixed width fonts at the moment */
		lastclickrow = (int)(event->x/this_screen->maxfontheight);
		lastclickcol = (int)(event->y/this_screen->maxfontwidth);
		
		last_input_screen=output_screen=this_screen;
		make_window_current(this_screen->current_window);
		statusstart=this_screen->li - 2;
		
		/*sprintf(linenumbuf, "%d", lastclickrow);
		strcpy(lastclicklinedata, function_line(linenumbuf));*/
		
		if(this_screen->window_list_end->status_lines == 0 && this_screen->window_list_end->double_status == 1 && this_screen->window_list_end->status_split == 1)
			statusstart=statusstart-1;
		if(this_screen->window_list_end->status_lines == 1 && this_screen->window_list_end->double_status == 0 && this_screen->window_list_end->status_split == 0)
			statusstart=statusstart-1;
		if(this_screen->window_list_end->status_lines == 1 && this_screen->window_list_end->double_status == 1 && this_screen->window_list_end->status_split == 1)
			statusstart=statusstart-1;
		if(this_screen->window_list_end->status_lines == 1 && this_screen->window_list_end->double_status == 1 && this_screen->window_list_end->status_split == 0)
			statusstart=statusstart-2;
		if(lastclickrow <= (current_window->screen->li - 2) && lastclickrow >= statusstart)		
			wm_process(STATUSRCLICK);
		else
			wm_process(RCLICK);
		}
	}
}

void gtk_start_main(void)
{
	gdk_threads_enter();
	gtk_main();
	gdk_threads_leave();
}

/* Initialize all needed structures, create the main window, 
   start the gtk_thread and gtk handler */
                                         
void gui_init(void)
{
	int fh, z;
	char tbuf[200];
	GtkStyle *style;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GdkColormap *cmap;
	GtkWidget *tmpbox;
	
	TI_cols = 80;
	TI_lines = 25;
	li = TI_lines;
	co = TI_cols;
	
	/* Initialize GDK POSIX threads support */
#if 0	
/*	if(!gdk_threads_init())*/
	if (!g_thread_supported())
	{
		printf("gtkBitchX panic! GDK could not initialize threads!\n");
		exit(500);
	}
#endif	
        /* Open the IPC pipes */
        pipe(gtkipcin);
        pipe(guiipc);

        /* Load the default font */
	mainfont = gdk_font_load("vga");
	
        /* Create the main window */
	mainwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);

        /* Attach handlers to the events */
	gtk_signal_connect(GTK_OBJECT(mainwindow), "delete_event", GTK_SIGNAL_FUNC(window_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(mainwindow), "destroy", GTK_SIGNAL_FUNC(destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(mainwindow), "key_press_event", GTK_SIGNAL_FUNC(gtk_keypress), NULL);
	gtk_signal_connect(GTK_OBJECT(mainwindow), "size_allocate", GTK_SIGNAL_FUNC(gtk_windowsize), NULL);
	gtk_signal_connect(GTK_OBJECT(mainwindow), "focus_in_event", GTK_SIGNAL_FUNC(gtk_windowfocus), NULL);
	
	gtk_container_set_border_width(GTK_CONTAINER(mainwindow), 0);
	
	tmpbox = gtk_hbox_new(FALSE, 0);
	mainbox = gtk_vbox_new(FALSE, 0);
	
	style = gtk_style_new();

#ifdef BXZVT
	mainviewport = ZVT_TERM(zvt_term_new());
	zvt_term_set_font_name(mainviewport, "vga");
	pipe(mainpipe);
#else	
	mainviewport = gtk_text_new(0, 0);
#endif

	gtk_signal_connect(GTK_OBJECT(mainviewport), "button_press_event", GTK_SIGNAL_FUNC(gtk_contextmenu), (gpointer)mainwindow);
		
	/* Add BitchX colors to the system colormap */
	cmap = gdk_colormap_get_system();
	for(z=0;z<16;z++)
		gdk_color_alloc(cmap, &colors[z]);
	
	memcpy(style, gtk_widget_get_style(GTK_WIDGET(mainviewport)), sizeof(GtkStyle));
	memcpy(style->base, &colors[BLACK], sizeof(GdkColor));
	memcpy(style->bg, &colors[BLACK], sizeof(GdkColor));
	memcpy(style->fg, &colors[WHITE], sizeof(GdkColor));
            
        /* Use a background XPM if it exists */
	sprintf(tbuf, "%s/bitchx.xpm", DEFAULT_CTOOLZ_DIR);
	fh = open(tbuf, O_RDONLY);
	printf("Attempting to use %s as a background XPM, result %d\n", tbuf, fh);
	if(fh != -1)
		{
		close(fh);
 		pixmap = gdk_pixmap_create_from_xpm(mainwindow->window, &mask,
 			&style->bg[GTK_STATE_NORMAL], tbuf);
		if(pixmap) style->bg_pixmap[0] = pixmap;
 		}
 	gtk_widget_set_style(mainviewport, style);
 	
        /* Make the window view port readonly and nonwrapping */
 #ifndef BXZVT
 	gtk_text_set_editable(GTK_TEXT(mainviewport), FALSE);
 	gtk_text_set_word_wrap(GTK_TEXT(mainviewport), FALSE);
 #endif
 
        /* Create the vertical scroll bar */
        mainadjust = (GtkAdjustment *)gtk_adjustment_new(get_int_var(SCROLLBACK_VAR), 0, get_int_var(SCROLLBACK_VAR), 1, 22, 22);
 	mainscroller = gtk_vscrollbar_new(mainadjust);
	GTK_WIDGET_UNSET_FLAGS(mainscroller, GTK_CAN_FOCUS);
        
        gtk_signal_connect(GTK_OBJECT(mainadjust), "value_changed", GTK_SIGNAL_FUNC(gtk_scrollerchanged), mainwindow);
        
        /* Add to the layout */
	gtk_container_add(GTK_CONTAINER(mainwindow), mainbox);
	
	gtk_box_pack_start(GTK_BOX(tmpbox), GTK_WIDGET(mainviewport), TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(tmpbox), mainscroller, FALSE, TRUE, 0);
	
	gtk_box_pack_end(GTK_BOX(mainbox), tmpbox, TRUE, TRUE, 0);
	
	gtk_widget_show(GTK_WIDGET(mainviewport));
	gtk_widget_show(mainscroller);
	gtk_widget_show(mainbox);
	gtk_widget_show(tmpbox);
	gtk_widget_show(mainwindow);
        
        lastclicklinedata = new_malloc(1000);
        
	if(pthread_create(&gtkthread, NULL, (void *)&gtk_start_main, NULL))
		{
	    	printf("gtkBitchX panic! Could not create gtk thread!");
	    	exit(500);
	    	}
}

/* Handler for menuitem events */
void menuitemhandler(gpointer *data)
{
menucmd = (int) *data;

write(guiipc[1], "2", 1);
write(guiipc[1], (char *)&last_input_screen->current_window->refnum, 1);
}

/* Create a submenu, used in menubar and popup menu creation */
GtkWidget *newsubmenu(MenuStruct *menutoadd)
{
GtkWidget 	*tmphandle,
		*tmpmenu;
MenuList *tmp;

	tmp = menutoadd->menuorigin;
	
	tmpmenu = gtk_menu_new();
	
	while(tmp!=NULL)
		{
		if(tmp->menutype == GUISEPARATOR)
			tmphandle=gtk_menu_item_new();
		else
			tmphandle=gtk_menu_item_new_with_label(tmp->name);
		if(tmp->menutype==GUISUBMENU || tmp->menutype==GUISHARED || tmp->menutype==GUIBRKSUBMENU)
			gtk_menu_item_set_submenu(GTK_MENU_ITEM(tmphandle), newsubmenu((MenuStruct *)findmenu(tmp->submenu)));
		if(tmp->menutype == GUIMENUITEM)
			gtk_signal_connect_object(GTK_OBJECT(tmphandle), "activate", GTK_SIGNAL_FUNC(menuitemhandler), (gpointer) &tmp->menuid);
		gtk_menu_append(GTK_MENU(tmpmenu), tmphandle);
		gtk_widget_show(tmphandle);
		tmp=tmp->next;
		}
		
	gtk_widget_show(tmpmenu);				
	return tmpmenu;
}

/* Creates a menubar on a given window/screen */
void newmenubar(Screen *menuscreen, MenuStruct *menutoadd)
{
GtkWidget *tmphandle;
MenuList *tmp;

        if(menutoadd->menuorigin == NULL)
        	{
                say("Cannot create blank menu,");
                return;
                }
	tmp = menutoadd->menuorigin;
        gdk_threads_enter();
      	menuscreen->menubar = gtk_menu_bar_new();
      	while(tmp!=NULL)
      		{
      		if(tmp->menutype == GUISEPARATOR)
      			tmphandle = gtk_menu_item_new();
      		else
     			tmphandle = gtk_menu_item_new_with_label(tmp->name);
          	if(tmp->menutype==GUISUBMENU || tmp->menutype==GUISHARED || tmp->menutype==GUIBRKSUBMENU)
          		gtk_menu_item_set_submenu(GTK_MENU_ITEM(tmphandle), newsubmenu((MenuStruct *)findmenu(tmp->submenu)));
       		if(tmp->menutype == GUIMENUITEM)
    			gtk_signal_connect_object(GTK_OBJECT(tmphandle), "activate", GTK_SIGNAL_FUNC(menuitemhandler), (gpointer) &tmp->menuid);
        	gtk_menu_bar_append(GTK_MENU_BAR(menuscreen->menubar), tmphandle);
        	gtk_widget_show(tmphandle);
        	tmp=tmp->next;
          	}
    	gtk_box_pack_end(GTK_BOX(menuscreen->box), menuscreen->menubar, FALSE, TRUE, 0);
    	gtk_widget_show(menuscreen->menubar);
	gtk_sizewindow(menuscreen);
  	gdk_threads_leave();
}

/* This section is for portability considerations */
void gui_clreol(void)
{

}

void gui_gotoxy(int col, int row)
{
	col++;row++;
	gtkprintf("\e[%d;%dH", row, col);
}

void gui_clrscr(void)
{
Screen *tmp;

   for(tmp = screen_list; tmp; tmp = tmp->next)
   	gtk_clrscr(tmp);
}

void gui_left(int num)
{
   gtk_backward(num);
}

void gui_right(int num)
{
   gtk_forward(num);
}

void gui_scroll(int top, int bot, int n)
{
	gtkprintf("\e[%d;%d;%dN", top, bot, n);
}

void gui_flush(void)
{

}

void gui_puts(char *buffer)
{
int i;
	for (i = 0; i < strlen(buffer); i++) 
		gtkputc(buffer[i]);
	gtkputc('\n'); 
}

/* Create a new (non-main) window */
void gui_new_window(Screen *new, Window *win)
{
char *defmenu, *deffont;
GtkWidget *tmpbox;
GtkStyle *style;
GdkPixmap *pixmap;
GdkBitmap *mask;
MenuStruct *tmpms;
char tbuf[200];
int fh;

        deffont=get_string_var(DEFAULT_FONT_VAR);
        if(deffont && *deffont)
        	new->font = gdk_font_load(deffont);
        else 
        	new->font = gdk_font_load("vga");

	gdk_threads_enter();

        /* Create the main window */
	new->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

        /* Attach handlers to the events */
	gtk_signal_connect(GTK_OBJECT(new->window), "delete_event", GTK_SIGNAL_FUNC(window_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(new->window), "destroy", GTK_SIGNAL_FUNC(destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(new->window), "key_press_event", GTK_SIGNAL_FUNC(gtk_keypress), NULL);
	gtk_signal_connect(GTK_OBJECT(new->window), "size_allocate", GTK_SIGNAL_FUNC(gtk_windowsize), NULL);
	gtk_signal_connect(GTK_OBJECT(new->window), "focus_in_event", GTK_SIGNAL_FUNC(gtk_windowfocus), NULL);
	
	gtk_container_set_border_width(GTK_CONTAINER(new->window), 0);
	
	tmpbox = gtk_hbox_new(FALSE, 0);
	new->box = gtk_vbox_new(FALSE, 0);
	
	style = gtk_style_new();

#ifdef BXZVT
	new->viewport = ZVT_TERM(xvt_term_new());
	if(deffont && *deffont)
		zvt_term_set_font_name(new->viewport, deffont);
	else
		zvt_term_set_font_name(new->viewport, "vga");
	pipe(new->pipe);
#else	
	new->viewport = gtk_text_new(0, 0);
#endif
	
	gtk_signal_connect(GTK_OBJECT(new->viewport), "button_press_event", GTK_SIGNAL_FUNC(gtk_contextmenu), new->window);

	memcpy(style, gtk_widget_get_style(GTK_WIDGET(new->viewport)), sizeof(GtkStyle));
	memcpy(style->base, &colors[BLACK], sizeof(GdkColor));
	memcpy(style->bg, &colors[BLACK], sizeof(GdkColor));
	memcpy(style->fg, &colors[WHITE], sizeof(GdkColor));
            
        /* Use a background XPM if it exists */
	sprintf(tbuf, "%s/bitchx.xpm", DEFAULT_CTOOLZ_DIR);
	fh = open(tbuf, O_RDONLY);
	if(fh != -1)
		{
		close(fh);
 		pixmap = gdk_pixmap_create_from_xpm(new->window->window, &mask,
 			&style->bg[GTK_STATE_NORMAL], tbuf);
		if(pixmap) style->bg_pixmap[0] = pixmap;
 		}
 	gtk_widget_set_style(new->viewport, style);
 	
        /* Make the window view port readonly and nonwrapping */
 #ifndef BXZVT
 	gtk_text_set_editable(GTK_TEXT(new->viewport), FALSE);
 	gtk_text_set_word_wrap(GTK_TEXT(new->viewport), FALSE);
 #endif
 	
        /* Create the vertical scroll bar */
        new->adjust = (GtkAdjustment *)gtk_adjustment_new(get_int_var(SCROLLBACK_VAR), 0, get_int_var(SCROLLBACK_VAR), 1, 22, 22);
 	new->scroller = gtk_vscrollbar_new(new->adjust);
	GTK_WIDGET_UNSET_FLAGS(new->scroller, GTK_CAN_FOCUS);
        
   	gtk_signal_connect(GTK_OBJECT(new->adjust), "value_changed", GTK_SIGNAL_FUNC(gtk_scrollerchanged), (gpointer)new->window);
        
        /* Add to the layout */
	gtk_container_add(GTK_CONTAINER(new->window), new->box);
	
	gtk_box_pack_start(GTK_BOX(tmpbox), new->viewport, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(tmpbox), new->scroller, FALSE, TRUE, 0);
	
	gtk_box_pack_end(GTK_BOX(new->box), tmpbox, TRUE, TRUE, 0);

	gtk_widget_show(GTK_WIDGET(new->viewport));
	gtk_widget_show(new->scroller);
	gtk_widget_show(new->box);
	gtk_widget_show(tmpbox);
	gtk_widget_show(new->window);

	defmenu=get_string_var(DEFAULT_MENU_VAR);
	if(defmenu && *defmenu)
		{
		if((tmpms = (MenuStruct *)findmenu(defmenu))!=NULL)
			newmenubar(new, tmpms);
		}                                                                         

	gtk_maxfont(new);
	gtk_sizewindow(new);
	gdk_threads_leave();
}
                                  
void gui_kill_window(Screen *killscreen)
{
#ifdef BXZVT
	new_close(killscreen->pipe[0]);
	new_close(killscreen->pipe[1]);
#endif
	gtk_widget_destroy(killscreen->window);
}

int gui_read(Screen *screen, char *buffer, int maxbufsize)
{
        return read(gtkipcin[0], buffer, maxbufsize);
}

void gui_settitle(char *titletext, Screen *gtkwin)
{
	if(gtkwin->window)
		{
		gdk_threads_enter();
		gtk_window_set_title(GTK_WINDOW(gtkwin->window), titletext);
		gdk_threads_leave();
		}
}

void gui_msgbox(void)
{

}

void gui_popupmenu(char *menuname)
{
MenuStruct *menupopup;

      if((menupopup=findmenu(menuname))!=NULL)
      	{
      	gdk_threads_enter();
      	gtk_menu_popup(GTK_MENU(newsubmenu(menupopup)), NULL, NULL, NULL, NULL, NULL, NULL);
      	gdk_threads_leave();
	}
}

void gui_font_dialog(Screen *screen)
{

}

/* These are support routines for gui_file_dialog() */

/* Ripped from functions.c because I couldn't get it to link from there */
char * fencode (unsigned char * input)
{
	char	*result;
	int	i = 0;

	result = (char *)new_malloc(strlen((char *)input) * 2 + 1);
	while (*input)
	{
		result[i++] = (*input >> 4) + 0x41;
		result[i++] = (*input & 0x0f) + 0x41;
		input++;
	}
	result[i] = '\0';

	return result;		/* DONT USE RETURN_STR HERE! */
}

void gtk_file_ok(GtkWidget *widget, GtkFileSelection *fs)
{
	gdk_threads_enter();
	gtk_widget_destroy(GTK_WIDGET(fs));
	gdk_threads_leave();
}

void gtk_file_cancel(GtkWidget *widget, GtkFileSelection *fs)
{
	gdk_threads_enter();
	gtk_widget_destroy(GTK_WIDGET(fs));
	gdk_threads_leave();
}

void gui_file_dialog(char *type, char *path, char *title, char *ok, char *apply, char *code, char *szButton)
{
	GtkWidget *filew;

	gdk_threads_enter();
	
	filew = gtk_file_selection_new(title);
	
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filew)->ok_button), "clicked", (GtkSignalFunc) gtk_file_ok, filew);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filew)->cancel_button), "clicked", (GtkSignalFunc) gtk_file_cancel, filew);
	
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(filew), path);
	
	gtk_widget_show(filew);
	
	gdk_threads_leave();
}

void gui_properties_notebook(void)
{

}

void gui_paste(char *args)
{

}

void gui_setfocus(Screen *screen)
{

}

void gui_scrollerchanged(Screen *screen, int position)
{
	screen->adjust->value = position;
	gtk_signal_emit_by_name(GTK_OBJECT(screen->adjust), "changed");
}

void gui_query_window_info(Screen *screen, char *fontinfo, int *x, int *y, int *cx, int *cy)
{
        *x = *y = *cx = *cy = 0;
        strcpy(fontinfo, "unknown");
}

void gui_play_sound(char *filename)
{

}

int gui_send_mci_string(char *mcistring, char *retstring)
{
return 0;
}

void gui_get_sound_error(int errnum, char *errstring)
{

}

void gui_menu(Screen *screen, MenuStruct *menu, char *addmenu)
{
	if(!my_stricmp(addmenu, "-delete"))
		gtk_widget_destroy(screen->menubar);
	else
		newmenubar(screen, menu);
}

int gui_isset(Screen *screen, fd_set *rd, int what)
{
	return FD_ISSET(gtkipcin[0], rd);
}

int gui_putc(int c)
{
   return gtkputc(c);
}

void gui_exit(void)
{

}
