/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPRebind;

public class LDAPSearchConstraints
implements Cloneable {
    private int timeLimit;
    private int deref;
    private int maxRes;
    private boolean referrals;
    private int batch;
    private LDAPRebind m_rebind_proc;
    private int m_hop_limit;
    private LDAPControl[] m_clientControls;
    private LDAPControl[] m_serverControls;
    private transient int m_maxBacklog = 100;

    public LDAPSearchConstraints() {
        this.timeLimit = 0;
        this.deref = 0;
        this.maxRes = 1000;
        this.referrals = false;
        this.batch = 1;
        this.m_rebind_proc = null;
        this.m_hop_limit = 10;
        this.m_clientControls = null;
        this.m_serverControls = null;
    }

    public LDAPSearchConstraints(int n, int n2, int n3, boolean bl, int n4, LDAPRebind lDAPRebind, int n5) {
        this.timeLimit = n;
        this.deref = n2;
        this.maxRes = n3;
        this.referrals = bl;
        this.batch = n4;
        this.m_rebind_proc = lDAPRebind;
        this.m_hop_limit = n5;
        this.m_clientControls = null;
        this.m_serverControls = null;
    }

    public int getTimeLimit() {
        return this.timeLimit * 1000;
    }

    public int getDereference() {
        return this.deref;
    }

    public int getMaxResults() {
        return this.maxRes;
    }

    public boolean getReferrals() {
        return this.referrals;
    }

    public int getBatchSize() {
        return this.batch;
    }

    public LDAPRebind getRebindProc() {
        return this.m_rebind_proc;
    }

    public int getHopLimit() {
        return this.m_hop_limit;
    }

    public LDAPControl[] getClientControls() {
        return this.m_clientControls;
    }

    public LDAPControl[] getServerControls() {
        return this.m_serverControls;
    }

    public void setTimeLimit(int n) {
        if (n != 0) {
            this.timeLimit = Math.max(1, (n + 500) / 1000);
        }
    }

    public void setDereference(int n) {
        this.deref = n;
    }

    public void setMaxResults(int n) {
        this.maxRes = n;
    }

    public void setReferrals(boolean bl) {
        this.referrals = bl;
    }

    public void setBatchSize(int n) {
        this.batch = n;
    }

    public void setRebindProc(LDAPRebind lDAPRebind) {
        this.m_rebind_proc = lDAPRebind;
    }

    public void setHopLimit(int n) {
        this.m_hop_limit = n;
    }

    public void setClientControls(LDAPControl lDAPControl) {
        this.m_clientControls = new LDAPControl[1];
        this.m_clientControls[0] = lDAPControl;
    }

    public void setClientControls(LDAPControl[] lDAPControlArray) {
        this.m_clientControls = lDAPControlArray;
    }

    public void setServerControls(LDAPControl lDAPControl) {
        this.m_serverControls = new LDAPControl[1];
        this.m_serverControls[0] = lDAPControl;
    }

    public void setServerControls(LDAPControl[] lDAPControlArray) {
        this.m_serverControls = lDAPControlArray;
    }

    public void setMaxBacklog(int n) {
        this.m_maxBacklog = n;
    }

    public int getMaxBacklog() {
        return this.m_maxBacklog;
    }

    public Object clone() {
        int n;
        LDAPSearchConstraints lDAPSearchConstraints = new LDAPSearchConstraints();
        lDAPSearchConstraints.timeLimit = this.timeLimit;
        lDAPSearchConstraints.deref = this.deref;
        lDAPSearchConstraints.maxRes = this.maxRes;
        lDAPSearchConstraints.referrals = this.referrals;
        lDAPSearchConstraints.batch = this.batch;
        lDAPSearchConstraints.m_rebind_proc = this.m_rebind_proc;
        lDAPSearchConstraints.m_hop_limit = this.m_hop_limit;
        if (this.m_clientControls != null && this.m_clientControls.length > 0) {
            lDAPSearchConstraints.m_clientControls = new LDAPControl[this.m_clientControls.length];
            n = 0;
            while (n < this.m_clientControls.length) {
                lDAPSearchConstraints.m_clientControls[n] = this.m_clientControls[n];
                ++n;
            }
        }
        if (this.m_serverControls != null && this.m_serverControls.length > 0) {
            lDAPSearchConstraints.m_serverControls = new LDAPControl[this.m_serverControls.length];
            n = 0;
            while (n < this.m_serverControls.length) {
                lDAPSearchConstraints.m_serverControls[n] = this.m_serverControls[n];
                ++n;
            }
        }
        return lDAPSearchConstraints;
    }
}

