/*
 *  handling of ICQ (sound) events 
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "events.h"
#include "gnomeicu.h"
#include <gdk/gdk.h>

void gnomeicu_event(ICQEvType event)
{
#ifdef TRACE_FUNCTION
  g_print( "gnomeicu_event(%d)\n", event );
#endif

#ifdef SOUND
  if(sound_toggle && !sound_disable)
    {
      switch(event)
	{
	case EV_MSGRECV: 
	  gnome_triggers_do("", "program", "GnomeICU", "message", NULL); 
	  break;
	case EV_USERON: 
	  gnome_triggers_do("", "program", "GnomeICU", "online", NULL);
	  break;
	case EV_USEROFF:
	  gnome_triggers_do("", "program", "GnomeICU", "offline", NULL); 
	  break;
	case EV_CHATREQ: 
	  gnome_triggers_do("", "program", "GnomeICU", "chat", NULL); 
	  break;
	case EV_CHATBEEP:
	  gnome_triggers_do("", "program", "GnomeICU", "chatbeep", NULL); 
	  break;
	case EV_URLRECV: 
	  gnome_triggers_do("", "program", "GnomeICU", "url", NULL); 
	  break;
	case EV_AUTHREQ:
	  gnome_triggers_do("", "program", "GnomeICU", "authreq", NULL);
	  break;
	case EV_AUTH:
	  gnome_triggers_do("", "program", "GnomeICU", "auth", NULL); 
	  break;
	case EV_FILEREQ:
	  gnome_triggers_do("", "program", "GnomeICU", "file", NULL);
	  break;
	case EV_LISTADD:
	  gnome_triggers_do("", "program", "GnomeICU", "notify", NULL);
	  break;
	}
    }

  if(beep_toggle)
    {
      gdk_beep();
    }
#endif
}

