/*
 *	Configuration Parser
 *
 * Reads variables from gnome storage
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gnomeicu.h"

void str2col( GdkColor *color, char *str );

int Read_RC_File( void )
{
	int size;
	char *value, *true_value;
	char *temp_uin;
	char *temp_nick;
	int first = TRUE;

	/* To be used in the new config section */
	void *iter;
	char *iterKey = NULL;
	char *iterData = NULL;

	gnome_config_push_prefix( configfilename );

	/* User info */
	if( our_info->uin == 0 )
		our_info->uin = gnome_config_get_int_with_default( "User/UIN=0", NULL );
	if( !strcmp( passwd, "" ) )
		strcpy( passwd, gnome_config_get_string_with_default( "User/Password=", NULL ) );
	
	Current_Status = atoi( gnome_config_get_string_with_default( "User/Status=0", NULL ) );
	if( our_info->nick == NULL )
	{
		our_info->nick = (char*)g_malloc( 30 );
		strncpy( our_info->nick, gnome_config_get_string_with_default( "User/Nickname=User", NULL ), 29 );
	}
	strcpy( Away_Message, gnome_config_get_string_with_default( "User/AwayMessage=User is currently away.  Please leave a message and have a great day! :)", NULL ) );

	our_info->first = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/First=", NULL ) ) + 1 );
	strcpy( our_info->first, gnome_config_get_string_with_default( "User/First=", NULL ) );

	our_info->last = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/Last=", NULL ) ) + 1 );
	strcpy( our_info->last, gnome_config_get_string_with_default( "User/Last=", NULL ) );

	our_info->sex = gnome_config_get_int_with_default( "User/Sex=0", NULL );

	our_info->age = gnome_config_get_int_with_default( "User/Age=0", NULL );

	our_info->auth = gnome_config_get_int_with_default( "User/Auth=1", NULL );

	our_info->birth_year = gnome_config_get_int_with_default( "User/Birth_Year=0", NULL );

	our_info->birth_month = gnome_config_get_int_with_default( "User/Birth_Month=1", NULL );

	our_info->birth_day = gnome_config_get_int_with_default( "User/Birth_Day=1", NULL );

	our_info->email = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/Email=", NULL ) ) + 1 );
	strcpy( our_info->email, gnome_config_get_string_with_default( "User/Email=", NULL ) );

	our_info->email2 = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/Email2=", NULL ) ) + 1 );
	strcpy( our_info->email2, gnome_config_get_string_with_default( "User/Email2=", NULL ) );

	our_info->email3 = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/Email3=", NULL ) ) + 1 );
	strcpy( our_info->email3, gnome_config_get_string_with_default( "User/Email3=", NULL ) );

	our_info->phone = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/Phone=", NULL ) ) + 1 );
	strcpy( our_info->phone, gnome_config_get_string_with_default( "User/Phone=", NULL ) );

	our_info->fax = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/Fax=", NULL ) ) + 1 );
	strcpy( our_info->fax, gnome_config_get_string_with_default( "User/Fax=", NULL ) );

	our_info->cellular = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/Cellular=", NULL ) ) + 1 );
	strcpy( our_info->cellular, gnome_config_get_string_with_default( "User/Cellular=", NULL ) );

	our_info->street = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/Street=", NULL ) ) + 1 );
	strcpy( our_info->street, gnome_config_get_string_with_default( "User/Street=", NULL ) );

	our_info->city = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/City=", NULL ) ) + 1 );
	strcpy( our_info->city, gnome_config_get_string_with_default( "User/City=", NULL ) );

	our_info->state = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/State=", NULL ) ) + 1 );
	strcpy( our_info->state, gnome_config_get_string_with_default( "User/State=", NULL ) );

	our_info->zip = gnome_config_get_int_with_default( "User/Zip=0", NULL );

	our_info->country = gnome_config_get_int_with_default( "User/Country=0", NULL );

	our_info->zip = gnome_config_get_int_with_default( "User/Zip=0", NULL );

	our_info->c_status = gnome_config_get_int_with_default( "User/C_Status=0", NULL );

	our_info->hide_email = gnome_config_get_int_with_default( "User/Hide_Email=0 ", NULL );

	our_info->homepage = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/Homepage=", NULL ) ) + 1 );
	strcpy( our_info->homepage, gnome_config_get_string_with_default( "User/Homepage=", NULL ) );

	our_info->about = (char*)g_malloc( strlen( gnome_config_get_string_with_default( "User/About=", NULL ) ) + 1 );
	strcpy( our_info->about, gnome_config_get_string_with_default( "User/About=", NULL ) );

	/* Server info */
	strcpy( server, gnome_config_get_string_with_default( "Server/Server=icq.mirabilis.com", NULL ) );
	remote_port = gnome_config_get_int_with_default( "Server/Port=4000", NULL );

	/* Window info */
	sscanf( gnome_config_get_string_with_default( "Window/Size=160x330", NULL ), "%dx%d", &WindowWidth, &WindowHeight );
	if( WindowWidth > 500 )
		WindowWidth = 500;
	if( WindowHeight > 1200 )
		WindowWidth = 1200;

	strcpy( WindowTitle, gnome_config_get_string_with_default( "Window/Title=GnomeICU", NULL ) );

	/* Toggles */
	sound_toggle = gnome_config_get_int_with_default( "Toggles/Sound=1", NULL );
	beep_toggle = gnome_config_get_int_with_default( "Toggles/Beep=0", NULL );
	packet_toggle = gnome_config_get_int_with_default( "Toggles/PacketDump=0", NULL );
	force_toggle = gnome_config_get_int_with_default( "Toggles/Force=0", NULL );

	/* Chat font */
	strcpy( ChatFontString, gnome_config_get_string_with_default( "Color/ChatFont=-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1", NULL ) );

	/* Color section */
	str2col(&color_online, gnome_config_get_string_with_default( "Color/Online=#000000009a69009a", NULL ) );
	color_online_set = TRUE;
	str2col(&color_offline, gnome_config_get_string_with_default( "Color/Offline=#75d675d675d67575", NULL ) );
	color_offline_set = TRUE;
	str2col(&color_away, gnome_config_get_string_with_default( "Color/Away=#0000820700008200", NULL ) );
	color_away_set = TRUE;
	str2col(&color_na, gnome_config_get_string_with_default( "Color/NotAvailable=#0000820700008200", NULL ) );
	color_na_set = TRUE;
	str2col(&color_ffc, gnome_config_get_string_with_default( "Color/FreeForChat=#0000000075300075", NULL ) );
	color_ffc_set = TRUE;
	str2col(&color_occ, gnome_config_get_string_with_default( "Color/Occupied=#0000000075300075", NULL ) );
	color_occ_set = TRUE;
	str2col(&color_dnd, gnome_config_get_string_with_default( "Color/DoNotDisturb=#0000000075300075", NULL ) );
	color_dnd_set = TRUE;
	str2col(&color_inv, gnome_config_get_string_with_default( "Color/Invisible=#9a692ed2810c2e81", NULL ) );
	color_inv_set = TRUE;

	/* New Contacts section */
	if( gnome_config_has_section( "NewContacts" ) )
	{
		iter = gnome_config_init_iterator( "NewContacts" );
		while( 1 )
		{
			iter = gnome_config_iterator_next( iter, &iterKey, &iterData );
			if( iter == NULL )
				break;
			if( strstr( iterData, "Sinv" ) )
				Contacts[ Num_Contacts ].invis_list = TRUE;
			else if( strstr( iterData, "Svis" ) )
				Contacts[ Num_Contacts ].vis_list = TRUE;
			else
			{
				Contacts[ Num_Contacts ].invis_list = FALSE;
				Contacts[ Num_Contacts ].vis_list = FALSE;
			}
		
			Contacts[ Num_Contacts ].uin = atoi( iterKey );

			if( iterData[ 0 ] == ',' )
				sprintf( Contacts[ Num_Contacts ].nick, "%s", iterKey );
			else
			{
				if( strchr( iterData, ',' ) != NULL )
					strncpy( Contacts[ Num_Contacts ].nick, iterData,
					         ( strchr( iterData, ',' ) - iterData ) );
				else
					strncpy( Contacts[ Num_Contacts ].nick, iterData,
					         sizeof( Contacts[ Num_Contacts].nick ) );
			}

			Contacts[ Num_Contacts ].oneline = NULL;
			Contacts[ Num_Contacts ].sok = 0;
			Contacts[ Num_Contacts ].chat_away = 0;
			Contacts[ Num_Contacts ].chat_window = NULL;
			Contacts[ Num_Contacts ].chat_frame = NULL;
			Contacts[ Num_Contacts ].chat_sok = 0;
			Contacts[ Num_Contacts ].chat_seq = 0;
			Contacts[ Num_Contacts ].chat_active = FALSE;
			Contacts[ Num_Contacts ].chat_active2 = FALSE;
			Contacts[ Num_Contacts ].chat_port = 0;
			Contacts[ Num_Contacts ].chat_history = NULL;
			Contacts[ Num_Contacts ].chat_bg_red =
			Contacts[ Num_Contacts ].chat_bg_green =
			Contacts[ Num_Contacts ].chat_bg_blue = 0;
			Contacts[ Num_Contacts ].chat_fg_red =
			Contacts[ Num_Contacts ].chat_fg_green =
			Contacts[ Num_Contacts ].chat_fg_blue = 255;
			Contacts[ Num_Contacts ].log_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
			Contacts[ Num_Contacts ].tcp_gdk_input = 0;
			Contacts[ Num_Contacts ].chat_gdk_input = 0;
			Contacts[ Num_Contacts ].pdata = NULL;
			Contacts[ Num_Contacts ].file_name = NULL;
			Contacts[ Num_Contacts ].file_short_name = NULL;
			Contacts[ Num_Contacts ].file_fd = 0;
			Contacts[ Num_Contacts ].file_offset = 0;
			Contacts[ Num_Contacts ].file_sending = FALSE;
			gtk_signal_connect( GTK_OBJECT( Contacts[ Num_Contacts ].log_window ), "delete_event", GTK_SIGNAL_FUNC( gtk_widget_hide_on_delete ), NULL );
			gtk_widget_set_usize( Contacts[ Num_Contacts ].log_window, 625, 250 );
			Contacts[ Num_Contacts ].log_list = gtk_text_new( NULL, NULL );
			gtk_text_set_editable( GTK_TEXT( Contacts[ Num_Contacts ].log_list ), FALSE );
			gtk_container_add( GTK_CONTAINER( Contacts[ Num_Contacts ].log_window ), Contacts[ Num_Contacts ].log_list );
			gtk_widget_show( Contacts[ Num_Contacts ].log_list );
			Contacts[ Num_Contacts ].message = NULL;
			Contacts[ Num_Contacts ].messages = 0;
			Contacts[ Num_Contacts ].status = STATUS_OFFLINE;
			Contacts[ Num_Contacts ].true_status = STATUS_OFFLINE;
			Contacts[ Num_Contacts ].last_time = -1L;
			Contacts[ Num_Contacts ].current_ip = -1L;
			Contacts[ Num_Contacts ].gdk_input_tag = 0;
			Contacts[ Num_Contacts ].file_info = NULL;
			Contacts[ Num_Contacts ].show_again = TRUE;
			Contacts[ Num_Contacts ].chat_reason = NULL;
			Contacts[ Num_Contacts ].info = (USER_INFO_PTR)g_malloc0( sizeof( USER_INFO_STRUCT ) );

			Num_Contacts ++;
		}
	}

	/* Contacts section */
	else
	{
		value = gnome_config_get_string_with_default( "Contacts/Contacts=4664755,GnomeICU Author", NULL );

		size = strlen( value ) + 1;
		value = (char*)g_malloc( size );
		true_value = value;
		strcpy( value, gnome_config_get_string_with_default( "Contacts/Contacts=4664755,GnomeICU Author", NULL ) );

		while( ( temp_uin = strtok( ( first ? value : NULL ), "," ) ) != NULL )
		{
			first = FALSE;
			temp_nick = strtok( NULL, "," );

			if( temp_uin[ 0 ] == '*' )
			{
				Contacts[ Num_Contacts ].invis_list = TRUE;
				Contacts[ Num_Contacts ].uin = atoi( &temp_uin[ 1 ] );
			}
			else if( temp_uin[ 0 ] == '~' )
			{
				Contacts[ Num_Contacts ].vis_list = TRUE;
				Contacts[ Num_Contacts ].uin = atoi( &temp_uin[ 1 ] );
			}
			else
			{
				Contacts[ Num_Contacts ].invis_list = FALSE;
				Contacts[ Num_Contacts ].vis_list = FALSE;
				Contacts[ Num_Contacts ].uin = atoi( temp_uin );
			}
			Contacts[ Num_Contacts ].oneline = NULL;
			Contacts[ Num_Contacts ].sok = 0;
			Contacts[ Num_Contacts ].chat_away = 0;
			Contacts[ Num_Contacts ].chat_window = NULL;
			Contacts[ Num_Contacts ].chat_frame = NULL;
			Contacts[ Num_Contacts ].chat_sok = 0;
			Contacts[ Num_Contacts ].chat_seq = 0;
			Contacts[ Num_Contacts ].chat_active = FALSE;
			Contacts[ Num_Contacts ].chat_active2 = FALSE;
			Contacts[ Num_Contacts ].chat_port = 0;
			Contacts[ Num_Contacts ].chat_history = NULL;
			Contacts[ Num_Contacts ].chat_bg_red =
			Contacts[ Num_Contacts ].chat_bg_green =
			Contacts[ Num_Contacts ].chat_bg_blue = 0;
			Contacts[ Num_Contacts ].chat_fg_red =
			Contacts[ Num_Contacts ].chat_fg_green =
			Contacts[ Num_Contacts ].chat_fg_blue = 255;
			Contacts[ Num_Contacts ].log_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
			Contacts[ Num_Contacts ].tcp_gdk_input = 0;
			Contacts[ Num_Contacts ].chat_gdk_input = 0;
			Contacts[ Num_Contacts ].pdata = NULL;
			Contacts[ Num_Contacts ].file_name = NULL;
			Contacts[ Num_Contacts ].file_short_name = NULL;
			Contacts[ Num_Contacts ].file_fd = 0;
			Contacts[ Num_Contacts ].file_offset = 0;
			Contacts[ Num_Contacts ].file_sending = FALSE;
			gtk_signal_connect( GTK_OBJECT( Contacts[ Num_Contacts ].log_window ), "delete_event", GTK_SIGNAL_FUNC( gtk_widget_hide_on_delete ), NULL );
			gtk_widget_set_usize( Contacts[ Num_Contacts ].log_window, 625, 250 );
			Contacts[ Num_Contacts ].log_list = gtk_text_new( NULL, NULL );
			gtk_text_set_editable( GTK_TEXT( Contacts[ Num_Contacts ].log_list ), FALSE );
			gtk_container_add( GTK_CONTAINER( Contacts[ Num_Contacts ].log_window ), Contacts[ Num_Contacts ].log_list );
			gtk_widget_show( Contacts[ Num_Contacts ].log_list );
			Contacts[ Num_Contacts ].message = NULL;
			Contacts[ Num_Contacts ].messages = 0;
			Contacts[ Num_Contacts ].status = STATUS_OFFLINE;
			Contacts[ Num_Contacts ].true_status = STATUS_OFFLINE;
			Contacts[ Num_Contacts ].last_time = -1L;
			Contacts[ Num_Contacts ].current_ip = -1L;
			Contacts[ Num_Contacts ].gdk_input_tag = 0;
			Contacts[ Num_Contacts ].file_info = NULL;
			Contacts[ Num_Contacts ].show_again = TRUE;
			Contacts[ Num_Contacts ].chat_reason = NULL;
			Contacts[ Num_Contacts ].info = (USER_INFO_PTR)g_malloc0( sizeof( USER_INFO_STRUCT ) );

			if( temp_nick )
			{
				strncpy(Contacts[Num_Contacts].nick, temp_nick, sizeof(Contacts->nick));
				Contacts[ Num_Contacts ].nick[ sizeof( Contacts->nick ) ] = 0;
			}
			else
				Contacts[ Num_Contacts ].nick[ 0 ] = 0;

			Num_Contacts++;
		}

		g_free( true_value );
	}

	gnome_config_pop_prefix();

	return 1;
}

int Initialize_RC_File( void )
{
	char command[ 256 ];
#ifdef TRACE_FUNCTION
	g_print( "Initialize_RC_File\n" );
#endif

	sprintf( command, "mkdir -p %s/.icq/history", getenv( "HOME" ) );
	system( command ); 

	sprintf( command, "chmod 700 %s/.icq", getenv( "HOME" ) );
	system( command );
            
	NewUserSignup();

	return 1;
}

/*
 *	Config File Save
 *
 * Jeremy Wise (jwise@pathwaynet.com) 02/27/1999
 *
 */

int Save_RC( void )
{
#if 0
	char *value;
	char *temp_uin;
	char *temp_nick;
#endif
	char uin_str[64];
	int cx;
	char *contactKey, *contactStr;

	Contact_Member *copy_Contacts = NULL;

	gnome_config_push_prefix( configfilename );

	/* User info */
	gnome_config_set_int( "User/UIN", our_info->uin );
	gnome_config_set_string( "User/Password", passwd );
	gnome_config_set_int( "User/Status", ( Current_Status != STATUS_OFFLINE ? Current_Status : STATUS_ONLINE ) );
	gnome_config_set_string( "User/Nickname", our_info->nick );
	gnome_config_set_string( "User/First", our_info->first );
	gnome_config_set_string( "User/Last", our_info->last );
	gnome_config_set_int( "User/Sex", our_info->sex );
	gnome_config_set_int( "User/Age", our_info->age );
	gnome_config_set_int( "User/Auth", our_info->auth );
	gnome_config_set_int( "User/Birth_Year", our_info->birth_year );
	gnome_config_set_int( "User/Birth_Month", our_info->birth_month );
	gnome_config_set_int( "User/Birth_Day", our_info->birth_day );
	gnome_config_set_string( "User/Email", our_info->email );
	gnome_config_set_string( "User/Email2", our_info->email2 );
	gnome_config_set_string( "User/Email3", our_info->email3 );
	gnome_config_set_string( "User/Phone", our_info->phone );
	gnome_config_set_string( "User/Fax", our_info->fax );
	gnome_config_set_string( "User/Cellular", our_info->cellular );
	gnome_config_set_string( "User/Street", our_info->street );
	gnome_config_set_string( "User/City", our_info->city );
	gnome_config_set_string( "User/State", our_info->state );
	gnome_config_set_int( "User/Zip", our_info->zip );
	gnome_config_set_int( "User/Country", our_info->country );
	gnome_config_set_int( "User/C_Status", our_info->c_status );
	gnome_config_set_string( "User/Homepage", our_info->homepage );
	gnome_config_set_string( "User/About", our_info->about );
	gnome_config_set_int( "User/Hide_Email", our_info->hide_email );
	gnome_config_set_string( "User/AwayMessage", Away_Message );

	/* Server info */
	gnome_config_set_string( "Server/Server", server );
	gnome_config_set_int( "Server/Port", remote_port );

	/* Window info */
   sprintf( uin_str, "%dx%d", WindowWidth, WindowHeight );
	gnome_config_set_string( "Window/Size", uin_str );
	gnome_config_set_string( "Window/Title", WindowTitle );

	/* Toggles */
	gnome_config_set_int( "Toggles/Sound", sound_toggle );
	gnome_config_set_int( "Toggles/Beep", beep_toggle );
	gnome_config_set_int( "Toggles/PacketDump", packet_toggle );
	gnome_config_set_int( "Toggles/Force", force_toggle );

	/* Color Section */
	sprintf( uin_str, "#%04x%04x%04x%04x",
	         color_online.red & 0xffff,
	         color_online.green & 0xffff,
	         color_online.blue & 0xffff,
	         (unsigned int)color_online.pixel & 0xffff );
	gnome_config_set_string( "Color/Online", uin_str );

	sprintf( uin_str, "#%04x%04x%04x%04x",
	         color_offline.red & 0xffff,
	         color_offline.green & 0xffff,
	         color_offline.blue & 0xffff,
	         (unsigned int)color_offline.pixel & 0xffff );
	gnome_config_set_string( "Color/Offline", uin_str );

	sprintf( uin_str, "#%04x%04x%04x%04x",
	         color_away.red & 0xffff,
	         color_away.green & 0xffff,
	         color_away.blue & 0xffff,
	         (unsigned int)color_away.pixel & 0xffff );
	gnome_config_set_string( "Color/Away", uin_str );

	sprintf( uin_str, "#%04x%04x%04x%04x",
	         color_na.red & 0xffff,
	         color_na.green & 0xffff,
	         color_na.blue & 0xffff,
	         (unsigned int)color_na.pixel & 0xffff );
	gnome_config_set_string( "Color/NotAvailable", uin_str );

	sprintf( uin_str, "#%04x%04x%04x%04x",
	         color_ffc.red & 0xffff,
	         color_ffc.green & 0xffff,
	         color_ffc.blue & 0xffff,
	         (unsigned int)color_ffc.pixel & 0xffff);
	gnome_config_set_string( "Color/FreeForChat", uin_str );

	sprintf( uin_str, "#%04x%04x%04x%04x",
	         color_occ.red & 0xffff,
	         color_occ.green & 0xffff,
	         color_occ.blue & 0xffff,
	         (unsigned int)color_occ.pixel & 0xffff );
	gnome_config_set_string( "Color/Occupied", uin_str );

	sprintf( uin_str, "#%04x%04x%04x%04x",
	         color_dnd.red & 0xffff,
	         color_dnd.green & 0xffff,
	         color_dnd.blue & 0xffff,
	         (unsigned int)color_dnd.pixel & 0xffff );
	gnome_config_set_string( "Color/DoNotDisturb", uin_str );

	sprintf( uin_str, "#%04x%04x%04x%04x",
	         color_inv.red & 0xffff,
	         color_inv.green & 0xffff,
	         color_inv.blue & 0xffff,
	         (unsigned int)color_inv.pixel & 0xffff );
	gnome_config_set_string( "Color/Invisible", uin_str );

	/* Chat font */
	gnome_config_set_string( "Color/ChatFont", ChatFontString );

	copy_Contacts = (Contact_Member*)g_malloc( sizeof( Contact_Member ) * Num_Contacts );
	memcpy( copy_Contacts, &Contacts[ 0 ], sizeof( Contact_Member ) * Num_Contacts );

#if 0
	/* Contacts section */
	contacts_str_length = Num_Contacts * 12;
	for( cx = 0; cx < Num_Contacts; cx ++ )
		contacts_str_length += strlen( copy_Contacts[ cx ].nick );

	contacts_str = (char*)g_malloc( contacts_str_length + 1 );
	strcpy( contacts_str, "" );

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( strcmp( copy_Contacts[ marked ].nick, copy_Contacts[ cx ].nick ) > 0 )
			marked = cx;
		copy_Contacts[ cx ].lb_index = 0;
	}

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( copy_Contacts[ marked ].uin > 0 )
		{
			if( strlen( copy_Contacts[ marked ].nick ) == 0 )
				strcpy( copy_Contacts[ marked ].nick, "Unnamed" );
			sprintf( uin_str, "%s%s%ld,%s,",
			         ( copy_Contacts[ marked ].invis_list ? "*" : "" ),
						( copy_Contacts[ marked ].vis_list ? "~" : "" ),
			         copy_Contacts[ marked ].uin,
			         copy_Contacts[ marked ].nick );
			strcat( contacts_str, uin_str );
		}
		copy_Contacts[ marked ].lb_index = 1;

		for( cz = 0; cz < Num_Contacts; cz ++ )
		{
			if( !copy_Contacts[cz].lb_index )
			{
				marked = cz;
				break;
			}
		}

		for( cz = 0; cz < Num_Contacts; cz ++ )
		{
			if( strcmp( copy_Contacts[ marked ].nick, copy_Contacts[ cz ].nick ) > 0 && !copy_Contacts[ cz ].lb_index )
				marked = cz;
		}
	}

	g_free( copy_Contacts );

	contacts_str[ strlen( contacts_str ) - 1 ] = 0x00;

	gnome_config_set_string( "Contacts/Contacts", contacts_str );
	g_free( contacts_str );
#endif

	/* New Contact Section */
	gnome_config_clean_section( "NewContacts" );

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		contactKey = (char*)g_malloc( 64 );
		sprintf( contactKey, "NewContacts/%u", Contacts[ cx ].uin );

		contactStr = (char*)g_malloc( 256 );
		sprintf( contactStr, "%s%s%s%s%s",
					Contacts[ cx ].nick,
					( Contacts[ cx ].invis_list || Contacts[ cx ].vis_list ? "," : "" ),
		         ( Contacts[ cx ].invis_list ? "Sinv" : "" ),
		         ( Contacts[ cx ].invis_list && Contacts[ cx ].vis_list ? "," : "" ),
		         ( Contacts[ cx ].vis_list ? "Svis" : "" ) );
		gnome_config_set_string( contactKey, contactStr );
		g_free( contactKey );
		g_free( contactStr );
	}

	gnome_config_set_int( "Existence/exists", 1 );

	gnome_config_sync();

	gnome_config_pop_prefix();

	return 0;
}

void str2col(GdkColor *color, char *str) {
    guint r, g, b;
    guint pix;

    sscanf(str, "#%04x%04x%04x%04x", &r, &g, &b, &pix);
    color->red = r;
    color->green = g;
    color->blue = b;
    color->pixel = pix;
}
