/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#define SKIPGNOME
#include <string.h>
#include <stdlib.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "xchat.h"
#include "userlist.h"
#include "menu.h"

extern GSList *sess_list;
extern GSList *fkey_list;
extern GSList *replace_list;
extern GSList *command_list;
extern void PrintText (struct session *sess, char *text);
extern struct commands cmds[1];
extern GtkWidget *main_book;
extern GtkWidget *main_window;
extern struct xchatprefs prefs;

int key_handle_key_press (GtkWidget * wid, GdkEventKey * evt);

#define STATE_SHIFT     GDK_SHIFT_MASK
#define	STATE_ALT	GDK_MOD1_MASK
#define STATE_CTRL	GDK_CONTROL_MASK

void
replace_handle (GtkWidget * t)
{
   char *text, *postfix_pnt;
   struct popup *pop;
   GSList *list = replace_list;
   char word[140];
   char postfix[140];
   char outbuf[4096];
   int c, len, xlen;

   text = gtk_entry_get_text (GTK_ENTRY(t));

   len = strlen (text);
   for (c = len - 1; c > 0; c--)
   {
      if (text[c] == ' ')
         break;
   }
   if (text[c] == ' ')
      c++;
   xlen = c;
   if (len - c >= (sizeof (word) - 12))
      return;
   memcpy (word, &text[c], len - c);
   word[len - c] = 0;
   len = strlen (word);
   if (word[0] == '\'' && word[len] == '\'')
      return;
   postfix_pnt = NULL;
   for (c = 0; c < len; c++)
   {
      if (word[c] == '\'')
      {
         postfix_pnt = &word[c + 1];
         word[c] = 0;
         break;
      }
   }

   if (postfix_pnt != NULL)
   {
      if (strlen (postfix_pnt) > sizeof (postfix) - 12)
         return;
      strcpy (postfix, postfix_pnt);
   }
   while (list)
   {
      pop = (struct popup *) list->data;
      if (strcmp (pop->name, word) == 0)
      {
         memcpy (outbuf, text, xlen);
         outbuf[xlen] = 0;
         if (postfix_pnt == NULL)
            snprintf (word, sizeof (word), "%s", pop->cmd);
         else
            snprintf (word, sizeof (word), "%s%s", pop->cmd, postfix);
         strcat (outbuf, word);
         gtk_entry_set_text (GTK_ENTRY (t), outbuf);
         return;
      }
      list = list->next;
   }
}

struct session *
find_session_from_inputgad (GtkWidget * w)
{
   GSList *list = sess_list;
   struct session *sess;

   /* First find the session from the widget */
   while (list)
   {
      sess = (struct session *) list->data;
      if (sess->inputgad == w)
         break;
      list = list->next;
   }
   if (!list)
   {
      /*Erm, we didn't find ANY valid session, HELP! */
      return NULL;
   }
   return sess;
}

int
text_is_more_than_just_nick (char *tx)
{
   int c, len = strlen (tx);

   for (c = 0; c < len; c++)
   {
      if (tx[c] == ' ' || tx[c] == ':' || tx[c] == '.' || tx[c] == '?')
         return 1;
   }
   return 0;
}

int
nick_comp_get_nick (char *tx, char *n)
{
   int c, len = strlen (tx);

   for (c = 0; c < len; c++)
   {
      if (tx[c] == ':')
      {
         n[c] = 0;
         return 0;
      }
      if (tx[c] == ' ' || tx[c] == '.' || tx[c] == 0)
         return -1;
      n[c] = tx[c];
   }
   return -1;
}

void
nick_comp_chng (GtkWidget * t, int updown)
{
   struct session *sess;
   struct user *user, *last = NULL;
   char *text, nick[64];
   int len, slen;

   sess = find_session_from_inputgad (t);
   if (sess == NULL)
      return;

   text = gtk_entry_get_text (GTK_ENTRY (t));
   
   if (nick_comp_get_nick (text, nick) == -1)
      return;
   user = sess->userlist;
   len = strlen (nick);

   while (user)
   {
      slen = strlen (user->user);
      if (len != slen)
      {
         last = user;
         user = user->next;
         continue;
      }
      if (strncasecmp (user->user, nick, len) == 0)
      {
         if (updown == 0)
         {
            if (user->next == NULL)
               return;
            user->weight--;
            user->next->weight++;
            snprintf (nick, sizeof (nick), "%s: ", user->next->user);
         } else
         {
            if (last == NULL)
               return;
            user->weight--;
            last->weight++;
            snprintf (nick, sizeof (nick), "%s: ", last->user);
         }
         gtk_entry_set_text (GTK_ENTRY (t), nick);
         return;
      }
      last = user;
      user = user->next;
   }
}

void
tab_comp_find_common (char *a, char *b)
{
   int c;
   int alen = strlen (a), blen = strlen (b),
       len;

   if (blen > alen)
      len = alen;
   else
      len = blen;
   for (c = 0; c < len; c++)
   {
      if (a[c] != b[c])
      {
         a[c] = 0;
         return;
      }
   }
   a[c] = 0;
}

void
tab_comp_cmd (GtkWidget * t)
{
   char *text, *last = NULL, *cmd, *postfix = NULL;
   GSList *list = command_list;
   struct popup *pop;
   int len, i, slen;
   struct session *sess;
   char buf[2048];
   char lcmd[2048];

   text = gtk_entry_get_text (GTK_ENTRY (t));

   sess = find_session_from_inputgad (t);

   text++;
   len = strlen (text);
   if (len == 0)
      return;
   for (i = 0; i < len; i++)
   {
      if (text[i] == ' ')
      {
         postfix = &text[i + 1];
         text[i] = 0;
         len = strlen (text);
         break;
      }
   }

   while (list)
   {
      pop = (struct popup *) list->data;
      slen = strlen (pop->name);
      if (len > slen)
      {
         list = list->next;
         continue;
      }
      if (strncasecmp (pop->name, text, len) == 0)
      {
         if (last == NULL)
         {
            last = pop->name;
            snprintf (lcmd, sizeof (lcmd), "%s", last);
         } else if (last > (char *) 1)
         {
            PrintText (sess, last);
            PrintText (sess, "\t");
            PrintText (sess, pop->name);
            PrintText (sess, "\t");
            last = (void *) 1;
            tab_comp_find_common (lcmd, pop->name);
         } else if (last == (void *) 1)
         {
            PrintText (sess, pop->name);
            PrintText (sess, "\t");
            tab_comp_find_common (lcmd, pop->name);
         }
      }
      list = list->next;
   }

   i = 0;
   while (cmds[i].name != NULL)
   {
      cmd = cmds[i].name;
      slen = strlen (cmd);
      if (len > slen)
      {
         i++;
         continue;
      }
      if (strncasecmp (cmd, text, len) == 0)
      {
         if (last == NULL)
         {
            last = cmd;
            snprintf (lcmd, sizeof (lcmd), "%s", last);
         } else if (last > (char *) 1)
         {
            PrintText (sess, last);
            PrintText (sess, "\t");
            PrintText (sess, cmd);
            PrintText (sess, "\t");
            last = (void *) 1;
            tab_comp_find_common (lcmd, cmd);
         } else if (last == (void *) 1)
         {
            PrintText (sess, cmd);
            PrintText (sess, "\t");
            tab_comp_find_common (lcmd, cmd);
         }
      }
      i++;
   }

   if (last == NULL)
      return;
   if (last == (void *) 1)
      PrintText (sess, "\n");

   if (last > (char *) 1)
   {
      if (strlen (last) > (sizeof (buf) - 1))
         return;
      if (postfix == NULL)
         snprintf (buf, sizeof (buf), "/%s ", last);
      else
         snprintf (buf, sizeof (buf), "/%s %s", last, postfix);
      gtk_entry_set_text (GTK_ENTRY (t), buf);
      return;
   } else if (strlen (lcmd) > (sizeof (buf) - 1))
      return;
   if (postfix == NULL)
      snprintf (buf, sizeof (buf), "/%s", lcmd);
   else
      snprintf (buf, sizeof (buf), "/%s %s", lcmd, postfix);
   gtk_entry_set_text (GTK_ENTRY (t), buf);
}

/* In the following 'b4' is *before* the text (just say b4 and before out loud)
   and c5 is *after* (because c5 is next after b4, get it??) --AGL */

int
tab_nick_comp_next (struct session *sess, GtkWidget * wid, char *b4,
      char *nick, char *c5, int shift)
{
   struct user *user, *last = NULL;
   char buf[4096];

   user = sess->userlist;
   while (user)
   {
      if (strcmp (user->user, nick) == 0)
         break;
      last = user;
      user = user->next;
   }
   if (!user)
      return 0;
   if (shift)
   {
      if (last)
         snprintf (buf, 4096, "%s %s%s", b4, last->user, c5);
      else
         snprintf (buf, 4096, "%s %s%s", b4, nick, c5);
   } else
   {
      if (user->next)
         snprintf (buf, 4096, "%s %s%s", b4, user->next->user, c5);
      else
      {
         if (sess->userlist)
            snprintf (buf, 4096, "%s %s%s", b4, sess->userlist->user, c5);
         else
            snprintf (buf, 4096, "%s %s%s", b4, nick, c5);
      }
   }
   gtk_entry_set_text (GTK_ENTRY (wid), buf);

   return 1;
}

int
tab_nick_comp (GtkWidget * t, int shift)
{
   struct session *sess;
   struct user *user, *best = NULL;
   char *text;
   int len, slen, highest = -10000, first = 0, i, j;
   char buf[16384], *b4 = NULL, *c5 = NULL;

   text = gtk_entry_get_text (GTK_ENTRY (t));

   sess = find_session_from_inputgad (t);
   if (sess->is_dialog)
      return 0;
   if (sess == NULL)
      return 0;

   len = strlen (text);
   if (!strchr (text, ' '))
   {
      if (text[0] == '/')
      {
         tab_comp_cmd (t);
         return 0;
      }
   }
   if (text_is_more_than_just_nick (text))
   {
      j = GTK_EDITABLE (t)->current_pos;
      b4 = (char *) malloc (len + 1);
      c5 = (char *) malloc (len + 1);
      memcpy (c5, &text[j], len - j);
      c5[len - j] = 0;
      memcpy (b4, text, len + 1);

      for (i = j - 1; i > -1; i--)
      {
         if (b4[i] == ' ')
         {
            b4[i] = 0;
            break;
         }
         b4[i] = 0;
      }
      memcpy (text, &text[i + 1], (j - i) + 1);
      text[(j - i) - 1] = 0;

      if (tab_nick_comp_next (sess, t, b4, text, c5, shift))
      {
         free (b4);
         free (c5);
         return 1;
      }
      first = 0;
   } else
      first = 1;

   user = sess->userlist;
   len = strlen (text);

   if (text[0] == 0)
      return -1;
   while (user)
   {
      slen = strlen (user->user);
      if (len > slen)
      {
         user = user->next;
         continue;
      }
      if (strncasecmp (user->user, text, len) == 0)
      {
         if (user->weight > highest)
         {
            best = user;
            highest = user->weight;
         }
      }
      user = user->next;
   }
   if (best == NULL)
      return 0;

   if (first)
      snprintf (buf, sizeof (buf), "%s: ", best->user);
   else
   {
      snprintf (buf, sizeof (buf), "%s %s%s", b4, best->user, c5);
      GTK_EDITABLE (t)->current_pos = strlen (b4) + strlen (best->user);
      free (b4);
      free (c5);
   }
   gtk_entry_set_text (GTK_ENTRY (t), buf);
   return 0;
}

void
history_add (struct history *his, char *text)
{
   if (his->lines[his->realpos])
      free (his->lines[his->realpos]);
   his->lines[his->realpos] = strdup (text);
   his->realpos++;
   if (his->realpos == HISTORY_SIZE)
      his->realpos = 0;
   his->pos = his->realpos;
}

void
history_free (struct history *his)
{
   int i;
   for (i = 0; i < HISTORY_SIZE; i++)
   {
      if (his->lines[i])
	{
         free (his->lines[i]);
	   his->lines[i] = 0;
	}
   }
}

void
history_down (GtkWidget * widget, struct history *his)
{
   his->pos++;
   if (his->pos == HISTORY_SIZE)
      his->pos = 0;
   if (his->lines[his->pos])
   {
      gtk_entry_set_text (GTK_ENTRY (widget), his->lines[his->pos]);
   } else
   {
      if (his->pos != 0)
         his->pos--;
      else
         his->pos = (HISTORY_SIZE - 1);
   }
}

void
history_up (GtkWidget * widget, struct history *his)
{
   if (his->pos == 0)
      his->pos = (HISTORY_SIZE - 1);
   else
      his->pos--;
   if (his->lines[his->pos])
   {
      gtk_entry_set_text (GTK_ENTRY (widget), his->lines[his->pos]);
   } else
   {
      if (his->pos == (HISTORY_SIZE - 1))
         his->pos = 0;
      else
         his->pos++;
   }
}
