/*-
 * Copyright (c) 1990 The Regents of the University of California
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1990 The Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char rcsid[] = "$Id: sliplogin.c,v 1.6.1 1995/08/01 root Exp root $";
#endif /* not lint */

/*
 * sliplogin.c
 * [MUST BE RUN SUID ROOT]
 *
 * This program initializes its own tty port to be an async TCP/IP interface.
 * It sets the line discipline to slip, invokes a shell script to initialize
 * the network interface, then pauses forever waiting for hangup.
 *
 * It is a remote descendant of several similar programs with incestuous ties:
 * - Kirk Smith's slipconf, modified by Richard Johnsson @ DEC WRL.
 * - slattach, probably by Rick Adams but touched by countless hordes.
 * - the original sliplogin for 4.2bsd, Doug Kingston the mover behind it.
 *
 * There are two forms of usage:
 *
 * "sliplogin"
 * Invoked simply as "sliplogin", the program looks up the username
 * in the file /etc/slip.hosts.
 * If an entry is found, the line on fd0 is configured for SLIP operation
 * as specified in the file.
 *
 * "sliplogin slipuser < /dev/ttyb"
 * Invoked by root with a username, the name is looked up in the
 * /etc/slip.hosts file and if found fd0 is configured as in case 1.
 */

#define _POSIX_SOURCE 1
#include <sys/types.h>
#include <stdlib.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <sys/file.h>
#include <sys/syslog.h>
#include <netdb.h>
#include <pwd.h>
#include <sys/stat.h>

#include <sys/termios.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h>

#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include "pathnames.h"

#ifndef N_SLIP
#define N_SLIP SLIPDISC /* slip line discipline */
#endif


int	slip_mode;
int	linespeed;
int	uid;
char loginargs[BUFSIZ];
char loginfile[MAXPATHLEN];
char loginname[BUFSIZ];
char slopt[5][16];
char laddr[16];
char raddr[16];
char unit[32];
volatile int HUP=-1;

void findid(char *name)
{
	static char *nisdomain=NULL;
	char *outval,*c;
	int status,outvallen;
	FILE *fp;
	static char mask[16];
	char user[16];
	int i, j, n;

	strcpy(loginname, name);
	if ((fp = fopen(_PATH_ACCESS, "r")) == NULL)
	{
	 fprintf(stderr,"sliplogin: %s: %s\n", _PATH_ACCESS, strerror(errno));
	 syslog(LOG_ERR, "%s: %m\n", _PATH_ACCESS);
	 exit(1);
	}
	while (fgets(loginargs, sizeof(loginargs) - 1, fp))
	{
	 if (ferror(fp)) break;
	 if (loginargs[0]=='#') continue;
	 if (loginargs[0]=='+') {
		if(__yp_check(NULL)!=1) {
			fprintf(stderr,"sliplogin: YP not running\n",name);
			continue;
		}
		if(nisdomain==NULL)
			yp_get_default_domain(&nisdomain);
		status=yp_match(nisdomain,"slip.hosts",name,strlen(name),&outval,&outvallen);
		if(status!=0) {
			fprintf(stderr,"sliplogin: %s Not in nis map\n",name);
			continue;
		}
		n = sscanf(outval, "%15s%15s%15s%15s%15s%15s%15s%15s%15s",
			user, laddr, raddr, mask, slopt[0], slopt[1], 
			slopt[2], slopt[3], slopt[4]);
		if(strlen(loginargs+1)>1) {
			if((c=strchr(loginargs,'\n'))!=NULL) *c='\0';
			strncpy(laddr,loginargs+1,15);
		}
	 } else {
		 n = sscanf(loginargs, "%15s%15s%15s%15s%15s%15s%15s%15s%15s",
						user, laddr, raddr, mask, slopt[0], slopt[1], 
						slopt[2], slopt[3], slopt[4]);
		 if ( (strcmp(user, name) != 0) && strcmp(user, "*") != 0) continue;
	 }
	 fclose(fp);
	 /* Found user - now check for dynamic IP assigning */
	 if (strcmp(raddr, "DYNAMIC")==0)
	 {
	  char *ttyn,sliptty[20],dynamic[80];
	  ttyn=ttyname(0);
      if ((fp = fopen(_PATH_SLIPTTY, "r")) == NULL)
	  {
		fprintf(stderr,"sliplogin: %s: %s\n", _PATH_SLIPTTY, strerror(errno));
		syslog(LOG_ERR, "%s: %m\n", _PATH_SLIPTTY);
		exit(1);
	  }
	  while (fgets(dynamic, 79, fp))
	  {
		if (ferror(fp)) break;
		if (dynamic[0]=='#') continue;
		sscanf(dynamic, "%15s%15s", sliptty,raddr);
		if (strcmp(ttyn, sliptty) != 0) continue;
		fclose(fp);
		fp=NULL;
		break;
	  }
	  if (fp!=NULL)
	  {
		fclose(fp);
		fprintf(stderr,"sliplogin: %s not found in %s\n", ttyn,_PATH_SLIPTTY);
		syslog(LOG_ERR,"%s not found in %s\n",ttyn,_PATH_SLIPTTY);
		syslog(LOG_ERR,"Couldn't start slip session for %s\n",name);
		exit(-1);
	  }
	  sprintf(loginargs, "%s %s %s %s %s %s %s %s %s", user, laddr, raddr,
				mask, slopt[0], slopt[1], slopt[2], slopt[3], slopt[4]);
	 } /* end if DYNAMIC */
	 return;
	}

	fclose(fp);
	(void)fprintf(stderr, "SLIP access denied for %s\n", name);
	syslog(LOG_ERR, "SLIP access denied for %s\n", name);
	exit(4);
}

int main(argc, argv)
	int argc;
	char *argv[];
{
	int fd, s, ldisc, odisc, pid, unitnumber;
	speed_t speed;
	struct sigaction sa;
	char *name;
	struct termios tios, otios;
	struct passwd *pw;
	char logincmd[2*BUFSIZ+32];
	extern uid_t getuid();

	if ((name = strrchr(argv[0], '/')) == NULL)
		name = argv[0];
	s = (int) getdtablesize();
	for (fd = 3 ; fd < s ; fd++)
		(void) close(fd);
	openlog(name, LOG_PID, LOG_DAEMON);
	uid = getuid();

	/* security */
	unsetenv("IFS");
	setenv("PATH","/bin:/usr/bin:/sbin:/etc:/usr/sbin",1);

	if (argc > 1) 
	{
	 name=argv[1];
	 if (uid!=0) 
	 {
	  fprintf(stderr,"Only root may use arguments\n");
	  exit(-1);
	 }
	}
	else
	{
		pw = getpwuid(uid);
		if (pw == NULL)
		{
			(void) fprintf(stderr, "access denied - no username\n");
			syslog(LOG_ERR, "access denied - getpwuid returned 0\n");
			exit(1);
		}
		name=pw->pw_name;
	}

	findid(name);
	
	sprintf(logincmd,"%s:%s",laddr,raddr);
	execl("/usr/sbin/pppd","pppd","modem","crtscts","proxyarp","lock","passive","asyncmap","0",logincmd,NULL);
	exit(-1);
}
