
static void TAG(WriteSpanRGBA)( const GLcontext *ctx, 
				  GLuint n, GLint x, GLint y, 
				  const GLubyte rgba[][4], 
				  const GLubyte mask[] )
{
   GLuint i;
   LOCAL_VARS;

   SYNC_HARDWARE;
   y = FLIP(y);

   if (mask)
   {
      for (i=0;i<n;i++,x++)
	 if (mask[i])
	    WRITE_RGBA( x, y, rgba[i][0], rgba[i][1], rgba[i][2], rgba[i][3] );
   }
   else
   {
      for (i=0;i<n;i++,x++)
	 WRITE_RGBA( x, y, rgba[i][0], rgba[i][1], rgba[i][2], rgba[i][3] );
   }
}

static void TAG(WriteSpan)( const GLcontext *ctx,
			     GLuint n, GLint x, GLint y,
			     const GLubyte rgb[][3], 
			     const GLubyte mask[] )
{
   GLuint i;
   LOCAL_VARS;

   SYNC_HARDWARE;
   y = FLIP(y);
   if (mask)
   {
      for (i=0;i<n;i++,x++)
	 if (mask[i])
	    WRITE_RGBA( x, y, rgb[i][0], rgb[i][1], rgb[i][2], 0 );
   }
   else
   {
      for (i=0;i<n;i++,x++)
	 WRITE_RGBA( x, y, rgb[i][0], rgb[i][1], rgb[i][2], 0 );
   }
}

static void TAG(WritePixels)( const GLcontext *ctx,
			       GLuint n, 
			       const GLint x[], 
			       const GLint y[],
			       const GLubyte rgba[][4], 
			       const GLubyte mask[] )
{
   GLuint i;
   LOCAL_VARS;

   SYNC_HARDWARE;
   for (i=0;i<n;i++)
   {
      if (mask[i])
	 WRITE_RGBA( x[i], FLIP(y[i]), 
		     rgba[i][0], rgba[i][1], rgba[i][2], rgba[i][3] );
   }
}


static void TAG(WriteSpanMono)( const GLcontext *ctx,	
				GLuint n, GLint x, GLint y, 
				const GLubyte mask[] )
{
   GLuint i;
   LOCAL_VARS;
   INIT_MONO_PIXEL(p);

   SYNC_HARDWARE;
   y = FLIP( y );

   for (i=0;i<n;i++,x++)
      if (mask[i])
	 WRITE_PIXEL( x, y, p );
}


static void TAG(WritePixelsMono)( const GLcontext *ctx,
				  GLuint n, 
				  const GLint x[], const GLint y[],
				  const GLubyte mask[] ) 
{
   GLuint i;
   LOCAL_VARS;
   INIT_MONO_PIXEL(p);

   SYNC_HARDWARE;
   for (i=0;i<n;i++)
      if (mask[i])
	 WRITE_PIXEL( x[i], FLIP(y[i]), p );
}



/*
 * Read a horizontal span of color pixels.
 */
static void TAG(ReadRGBASpan)( const GLcontext *ctx,
			       GLuint n, GLint x, GLint y,
			       GLubyte rgba[][4])
{
   GLuint i;
   LOCAL_VARS;

   SYNC_HARDWARE;

   y = FLIP(y);

   for (i=0;i<n;i++)
      READ_RGBA( rgba[i], x+i, y );
}

static void TAG(ReadRGBAPixels)( const GLcontext *ctx,
				 GLuint n, const GLint x[], const GLint y[],
				 GLubyte rgba[][4], const GLubyte mask[] )
{
   GLuint i;
   LOCAL_VARS;

   SYNC_HARDWARE;
   for (i=0;i<n;i++)
      if (mask[i])
	 READ_RGBA( rgba[i], x[i], FLIP( y[i] ) );
}




