/* $XFree86: xc/programs/Xserver/hw/xfree86/drivers/tdfx/tdfx_priv.c,v 1.7 2000/02/18 12:20:05 tsi Exp $ */


#if 0
#include <sys/time.h>
#endif
#include "xf86.h"
#include "xf86_OSproc.h"
#include "xf86_ansic.h"
#include "xf86fbman.h"
#include "compiler.h"
#include "tdfx.h"

/*
  Memory layout of card is as follows:

  000000-003fff: Cursor 
  001000-xxxxxx: Fifo (Min of CMDFIFO pages)
  xxxxxx-420fff: Texture maps
  421000- A-1  : Framebuffer
   A    - B-1  : Offscreen pixmaps
   B    - C-1  : Back buffer
   C    - D-1  : Z buffer
*/

void TDFXSendNOPPrivate2D(TDFXPtr pTDFX)
{
  TDFXAllocateSlots(pTDFX, 2);
  SET_3DPK4_HEADER(1, 0x48);
  WRITE_FIFO(pTDFX, 0, 0);
}

void TDFXSendNOPPrivate3D(TDFXPtr pTDFX)
{
  TDFXAllocateSlots(pTDFX, 2);
  SET_PKT2_HEADER(SSTCP_COMMAND);
  WRITE_FIFO(pTDFX, SST_2D_COMMAND, SST_2D_NOP|SST_2D_GO);
}  

void TDFXSendNOPPrivate(TDFXPtr pTDFX)
{
  TDFXSendNOPPrivate2D(pTDFX);
  TDFXSendNOPPrivate3D(pTDFX);
}

void InstallFifo(TDFXPtr pTDFX)
{
  /* Install the fifo */
  TDFXWriteLongMMIO(pTDFX, SST_FIFO_BASEADDR0, pTDFX->fifoOffset>>12);
  TDFXWriteLongMMIO(pTDFX, SST_FIFO_BUMP0, 0);
  TDFXWriteLongMMIO(pTDFX, SST_FIFO_RDPTRL0, pTDFX->fifoOffset);
  TDFXWriteLongMMIO(pTDFX, SST_FIFO_RDPTRH0, 0);
  TDFXWriteLongMMIO(pTDFX, SST_FIFO_AMIN0, pTDFX->fifoOffset-4);
  TDFXWriteLongMMIO(pTDFX, SST_FIFO_AMAX0, pTDFX->fifoOffset-4);
  TDFXWriteLongMMIO(pTDFX, SST_FIFO_DEPTH0, 0);
  TDFXWriteLongMMIO(pTDFX, SST_FIFO_HOLECNT0, 0);
  if (pTDFX->PciInfo->chipType == PCI_CHIP_BANSHEE) 
    TDFXWriteLongMMIO(pTDFX, SST_FIFO_FIFOTHRESH, (0x9<<5) | 0x2);
  else 
    TDFXWriteLongMMIO(pTDFX, SST_FIFO_FIFOTHRESH, (0xf<<5) | 0x8);
  TDFXWriteLongMMIO(pTDFX, SST_FIFO_BASESIZE0, ((pTDFX->fifoSize>>12)-1) | 
		    SST_EN_CMDFIFO);
  /* Set the internal state */
  pTDFX->fifoRead = pTDFX->fifoBase;
  pTDFX->fifoPtr = pTDFX->fifoBase;
  pTDFX->fifoSlots = (pTDFX->fifoSize>>2) - 1;
  pTDFX->fifoEnd = pTDFX->fifoBase+pTDFX->fifoSlots;
  TDFXSendNOPPrivate(pTDFX);
}

void TDFXResetFifo(TDFXPtr pTDFX)
{
  int oldValue;
  CARD32 start_sec, end_sec, dummy;

  ErrorF("Resetting FIFO\n");
  /* Shut down the fifo */
  TDFXWriteLongMMIO(pTDFX, SST_FIFO_BASESIZE0, 0);
  /* Toggle the reset bits */
  oldValue=TDFXReadLongMMIO(pTDFX, MISCINIT0);
  TDFXWriteLongMMIO(pTDFX, MISCINIT0, oldValue|0x23);
  xf86getsecs(&start_sec, &dummy);
  do {
    xf86getsecs(&end_sec, &dummy);
  } while (end_sec-start_sec<2);
  TDFXWriteLongMMIO(pTDFX, MISCINIT0, oldValue);
  oldValue=TDFXReadLongMMIO(pTDFX, MISCINIT1);
  TDFXWriteLongMMIO(pTDFX, MISCINIT1, oldValue|BIT(19));
  xf86getsecs(&start_sec, &dummy);
  do {
    xf86getsecs(&end_sec, &dummy);
  } while (end_sec-start_sec<2);
  TDFXWriteLongMMIO(pTDFX, MISCINIT1, oldValue);
  InstallFifo(pTDFX);
}

/*
  There are two steps to fully syncing the board:
  
  1) Send a NOP, which waits for any commands in progress
  2) Read the status register for 3 consecutive non-busy

  !!! We should use expedential backoff in our reads !!!
*/
void TDFXSyncFifo(ScrnInfoPtr pScrn)
{
  TDFXPtr pTDFX;
  int i, cnt;
  int stat;
  CARD32 start_sec, end_sec, dummy;

  TDFXTRACEACCEL("TDFXSyncFifo start\n");
  pTDFX=TDFXPTR(pScrn);
  TDFXSendNOPPrivate(pTDFX);
  i=0;
  cnt=0;
  start_sec=0;
  do {
    stat=TDFXReadLongMMIO(pTDFX, 0);
    if (stat&SST_BUSY) i=0; else i++;
    cnt++;
    if (cnt==1000) {
      if (!start_sec) {
	xf86getsecs(&start_sec, &dummy);
      } else {
	xf86getsecs(&end_sec, &dummy);
	if (end_sec-start_sec>3) {
	  TDFXResetFifo(pTDFX);
	  start_sec=0;
        }
      }
      cnt=0;
    }
  } while (i<3);
  pTDFX->PciCnt=stat&0x1F;
  pTDFX->prevBlitDest.x1=pTDFX->prevBlitDest.y1=0;
  pTDFX->prevBlitDest.x2=pTDFX->prevBlitDest.y2=0;
}

Bool TDFXInitPrivate(ScreenPtr pScreen)
{
  ScrnInfoPtr pScrn;
  TDFXPtr pTDFX;

  pScrn = xf86Screens[pScreen->myNum];
  pTDFX=TDFXPTR(pScrn);
#ifdef DEBUG_FIFO
  pTDFX->fifoMirrorBase=0;
#endif
  pTDFX->fifoBase = (uint32*)(pTDFX->FbBase+pTDFX->fifoOffset);
#ifdef DEBUG_FIFO
  pTDFX->fifoMirrorBase = xalloc(pTDFX->fifoSize);
  pTDFX->fifoMirrorPtr = pTDFX->fifoMirrorBase;
#endif
  pTDFX->sync=TDFXSyncFifo;
  InstallFifo(pTDFX);
  return TRUE;
}

void TDFXShutdownPrivate(ScreenPtr pScreen)
{
  ScrnInfoPtr pScrn;
  TDFXPtr pTDFX;

  pScrn = xf86Screens[pScreen->myNum];
  pTDFX=TDFXPTR(pScrn);
  TDFXWriteLongMMIO(pTDFX, SST_FIFO_BASESIZE0, 0);
  pTDFX->sync=TDFXSync;
#ifdef DEBUG_FIFO
  if (pTDFX->fifoMirrorBase) xfree(pTDFX->fifoMirrorBase);
  pTDFX->fifoMirrorBase=0;
#endif
}

static uint32 
GetReadPtr(TDFXPtr pTDFX)
{
  uint32 read_ptr, dummy;

  do {
    dummy = TDFXReadLongMMIO(pTDFX, SST_FIFO_RDPTRL0);
    read_ptr = TDFXReadLongMMIO(pTDFX, SST_FIFO_RDPTRL0);
  } while (read_ptr != dummy);
  return read_ptr;
}

#ifdef XF86DRI
void TDFXSwapContextPrivate(ScreenPtr pScreen)
{
  ScrnInfoPtr pScrn;
  TDFXPtr pTDFX;
  int dummy, readPos;
  int offset;
  TDFXSAREAPriv *sPriv;

  pScrn = xf86Screens[pScreen->myNum];
  pTDFX=TDFXPTR(pScrn);
  sPriv=(TDFXSAREAPriv*)DRIGetSAREAPrivate(pScreen);
  /* if (sPriv)
     ErrorF("In FifoPtr=%d FifoRead=%d\n", sPriv->fifoPtr, sPriv->fifoRead); */
#if 1
  do {
    dummy=TDFXReadLongMMIO(pTDFX, SST_FIFO_DEPTH0);
    readPos=TDFXReadLongMMIO(pTDFX, SST_FIFO_DEPTH0);
  } while (dummy || readPos);
  readPos=(GetReadPtr(pTDFX)-pTDFX->fifoOffset)>>2;
  pTDFX->fifoPtr = pTDFX->fifoBase+readPos;
  pTDFX->fifoRead = pTDFX->fifoPtr;
#else
  sPriv=(TDFXSAREAPriv*)DRIGetSAREAPrivate(pScreen);
  if (!sPriv) return;
  if ((sPriv->fifoPtr<pTDFX->fifoOffset) || 
      (sPriv->fifoPtr>(int)pTDFX->fifoOffset+pTDFX->fifoSize) ||
      (sPriv->fifoRead<pTDFX->fifoOffset) ||
      (sPriv->fifoRead>(int)pTDFX->fifoOffset+pTDFX->fifoSize)) {
    ErrorF("Invalid offsets passed between client and X server\n");
    ResetFifo(pTDFX);
  } else {
    pTDFX->fifoPtr = (unsigned int *)(pTDFX->FbBase+sPriv->fifoPtr);
    pTDFX->fifoRead = (unsigned int *)(pTDFX->FbBase+sPriv->fifoRead);
  }
#endif
  if (pTDFX->fifoRead>pTDFX->fifoPtr)
    pTDFX->fifoSlots = pTDFX->fifoRead-pTDFX->fifoPtr-1-8;
  else 
    pTDFX->fifoSlots = pTDFX->fifoEnd-pTDFX->fifoPtr-8;
}    

void TDFXLostContext(ScreenPtr pScreen) {
  ScrnInfoPtr pScrn;
  TDFXPtr pTDFX;
  TDFXSAREAPriv *sPriv;

  pScrn = xf86Screens[pScreen->myNum];
  pTDFX=TDFXPTR(pScrn);
  sPriv=(TDFXSAREAPriv*)DRIGetSAREAPrivate(pScreen);
  if (!sPriv) return;
  if (sPriv->fifoPtr!=(((unsigned char*)pTDFX->fifoPtr)-pTDFX->FbBase) ||
      sPriv->fifoRead!=(((unsigned char*)pTDFX->fifoRead)-pTDFX->FbBase)) {
    sPriv->fifoPtr=(((unsigned char*)pTDFX->fifoPtr)-pTDFX->FbBase);
    sPriv->fifoRead=(((unsigned char*)pTDFX->fifoRead)-pTDFX->FbBase);
    sPriv->fifoOwner=DRIGetContext(pScreen);
    /* ErrorF("Out FifoPtr=%d FifoRead=%d\n", sPriv->fifoPtr, sPriv->fifoRead); */
  }
}
#endif

static void 
TDFXMakeSpace(TDFXPtr pTDFX, uint32 slots)
{
  uint32 slots_available;

  /*
  ** Check to see if we have to wrap to get enough space.
  */
  if (slots > pTDFX->fifoEnd-pTDFX->fifoPtr) {
    /*
    ** Make sure that the read pointer is not ahead of us in the
    ** the command fifo before wrapping.
    ** This insures two things:
    **   1) There is room at fifo_ptr for the JMP packet.
    **   2) There are slots available at the beginning of the fifo up to the read_ptr.
    **
    ** Since we are wrapping, insure that the read pointer is not at the
    ** beginning of the fifo to prevent the ambiguous situation described
    ** below.
    */
    do {
      pTDFX->fifoRead = (uint32*)(pTDFX->FbBase + GetReadPtr(pTDFX));
    }
    while (pTDFX->fifoRead>pTDFX->fifoPtr || 
	   pTDFX->fifoRead == pTDFX->fifoBase);
    /*
    ** Put a jump command in command fifo to wrap to the beginning.
    */
    *pTDFX->fifoPtr = (pTDFX->fifoOffset >> 2) << SSTCP_PKT0_ADDR_SHIFT |
      SSTCP_PKT0_JMP_LOCAL;
    FLUSH_WCB();

    /*
    ** Reset the fifo_ptr to the beginning of the command fifo.
    */
    pTDFX->fifoPtr = pTDFX->fifoBase;
#ifdef DEBUG_FIFO
    pTDFX->fifoMirrorPtr = pTDFX->fifoMirrorBase;
#endif
  }

  /*
  ** Wait for enough slots to satisfy the request.
  */
  do {
    pTDFX->fifoRead = (uint32*)(pTDFX->FbBase + GetReadPtr(pTDFX));

    /*
    ** If the HW read_ptr is ahead the SW fifo_ptr, we don't allocate the
    ** fifo slot immediately behind the HW read_ptr.  This is to prevent
    ** the following ambiguous situation...
    **
    ** If (HW read_ptr == SW fifo_ptr) is it because the HW read_ptr has
    ** caught up to the SW fifo_ptr and the fifo is completely empty
    ** OR is it because the SW fifo_ptr has caught up to the HW read_ptr
    ** and the fifo is completely full?
    */
    if ((uint32*)pTDFX->fifoRead > pTDFX->fifoPtr)
      slots_available = pTDFX->fifoRead - pTDFX->fifoPtr - 1;
    else
      slots_available = pTDFX->fifoEnd - pTDFX->fifoPtr;
  } while (slots > slots_available);

  pTDFX->fifoSlots = slots_available-slots;
}

void 
TDFXAllocateSlots(TDFXPtr pTDFX, int slots) {
#ifdef TDFX_DEBUG_FIFO
  if (pTDFX->fifoEnd-pTDFX->fifoPtr<pTDFX->fifoSlots)
    ErrorF("FIFO overrun\n");
#endif
  pTDFX->fifoSlots-=slots;
  if (pTDFX->fifoSlots<0) TDFXMakeSpace(pTDFX, slots);
}
