/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifndef GLOBAL_H
#define GLOBAL_H


#include <kfiledialog.h>
#include <time.h>
#include <qcolor.h>
#include <qfont.h>
#include <qlist.h>
#include <qwidget.h>
#include <stdlib.h>


#define MAX_CHAN 250
#define FRAMESIZE 256


#define USE_NONBLOCKING


class connCall
{
public:
   connCall( const char *rxcall ) { _call = (char *) strdup(rxcall); }
   ~connCall() { free(_call); }

   char * call() { return _call; }
private:
   char *_call;
};


typedef struct
{
   int txText;              // zu sendender Text
   int rxText;              // empfangener Text
   int statusText;          // Statustexte
   int background;          // Hintergrundfarbe
   bool qsowin_bold;        // Soll das QSO-Fenster fette Schriften bekommen?
   bool txwin_bold;         // Vorschreibfenster fette Schrift?
   int txwin;
   int txbackground;

   int qsoWinMarkColor;     // Farbe von markiertem Text im QSO-Fenster
   int qsoWinMarkBack;      // Hintergrund von markiertem Text im QSO-Fenster
   bool mark_bold;          // markierten Text fett schreiben?
} s_conf_colors;


// Filenamen der WAV-Files, die abgespielt werden.
#define SOUND_CONNECT 0
#define SOUND_DISCONNECT 1
#define SOUND_RING 2
#define SOUND_KLACK 3
typedef struct
{
   bool enabled;

   char *connect;
   char *disconnect;
   char *ring;
   bool klack;
   char *klackfile;
} s_conf_sound;


typedef struct _s_listCalls
{
   struct _s_listCalls *next;
   char *call;
} s_listCalls;


typedef struct
{
   unsigned char wo;      // 0 = hier
                          // 1 = telefon
                          // 2 = schlafen
                          // 3 = eigener Text
   char text[61];
   time_t awaytime;

   char *phone;
   char *bed;
   char *back;
   char *away;
} s_away;


typedef struct
{
   char call[10];       // Dieses Rufzeichen soll gesucht werden
   bool ssid;           // SSID-Sensitiv?
} s_callKey;


#define BARFLG_SHOW 1		// Buttonleiste ueberhaupt anzeigen?
#define BARFLG_RIGHT 2		// Buttonleiste rechts (true)?
#define BARFLG_PERSIST 4	// Kaesten immer um die Buttons?

typedef struct
{
   s_away away;

   s_listCalls *listento_calls;
   s_listCalls *discon_calls;
   char send_mycall[10];
   char *shortcuts[10];
   s_callKey *callKey[10];
   char *maindir;
   char *driverdir;
   int framesize;
   time_t starttime;
   int rx_buffersize;
   int tx_buffersize;
   char *ports;          // Namen der Ports, die benutzt werden sollen

   // Bildschirm-Infos
   int chbutton_pos;    // Y-Position der Kanal-Knoepfe im Hauptfenster
   int screen_x;         // X-Groesse des Hauptfensters
   int screen_y;         // Y-Groesse des Hauptfensters

   s_conf_colors *colors;
   s_conf_sound *sound;

   // Verzeichnisse
   char *dir7plus;
   char *dirABin;
   char *dirDown;
   char *dirUp;

   // Soll das Fenster geschlossen werden, wenn die Gegenstation
   // disconnected?
   bool closeWinOnDisc;
   // Soll das Fenster versteckt werden, wenn der Kanal gewechselt wird?
   bool hideWinOnSwitch;
   // Sollen schon vorhandene AutoBIN/Auto7plus-Files ueberschrieben werden?
   bool overwriteExisting;
   // Lokales Echo?
   bool localEcho;
   // Piepen, wenn CTRL-G empfangen wurde?
   bool beepCtrlG;
   // Zeilenumbruch?
   bool zeilenumbruch;
   int umbruchpos;
   // SSID 'rauszaehlen wenn bereits mit diesem Rufzeichen eine Verbindung
   // besteht?
   bool autoIncSSID;
   // Automatisch den eigenen Namen aussenden, wenn die Gegenstation ihn
   // noch nicht kennt?
   bool autosendName;
   // Die BoxCheck-Liste sortieren?
   bool sortBoxCheck;
   // Soll bei einem neuen Connect das neue Kanalfenster sofort geoeffnet
   // werden? false = nein, nur in der Kanalliste anzeigen
   bool openChannelWin;
   // Soll bei YAPP der Resume-Mode aktiviert werden? Achtung, Dateien
   // koennen dadurch zerstoert werden!
   bool yappResume;
   // Soll das Info-Fenster beim Filetransfer ganz unten im QSO-Fenster
   // oder als eigenes Fenster angezeigt werden?
   bool extraTransferWin;
   // Logbuch fuehren?
   bool useLogbook;
   // ANSI-Codes dekodieren?
   bool allowANSI;
   // Aussehen der Buttonbar. Siehe BARFLG_*
   int buttonbar;

   // Ist das RX- oder das Vorschreibfenster oben?
   bool txWinOben;
   int txWinSize;       // Groesse des tx-Windows beim Initialisieren
                        // in Prozent

   QFont *rx_font;
   QFont *tx_font;
   char *rxfontstr;
   char *txfontstr;
   char *bcfontstr;
   int qsofontsize;
   int txfontsize;
   int bcfontsize;

   // Liste der letzten 15 Rufzeichen (mit Pfad, halt so, wie sie eingegeben
   // wurden), die connected wurden
   QList<connCall> *connCallsList;
} s_config;

extern s_config *config;

// Dieses Fenster hatte gerade den Focus
extern QWidget *focusWidget;

extern QColor colors[17];


// Hier werden die Informationen ueber den BoxCheck abgespeichert

#define BOXCHECK_SENDER 0
#define BOXCHECK_RUBRIK 1
#define BOXCHECK_MAILNR 2
#define BOXCHECK_DATUM 3
#define BOXCHECK_MBX 4
#define BOXCHECK_BYTES 5
#define BOXCHECK_LT 6
#define BOXCHECK_TITEL 7

// The following defines specify the type of the bbs. We
// distinguish between german-style, board oriented bbs
// like diebox, baybox, dpbox and old style rli-like bbs
// like fbb
#define BOXC_TYPE_DIEBOX 0 // bbs uses "boards"
#define BOXC_TYPE_RLI 1 //msg-number oriented bbs

typedef struct
{
   unsigned char pos;
   unsigned char len;
} s_checkpos;

typedef struct
{
   int pos;
   char zeichen;
} s_checkmust;


#define BCTYPE_BAYBOX 1

#define BCFIELD_BOARD 1
#define BCFIELD_NUMBER 2
#define BCFIELD_LIFETIME 4
#define BCFIELD_SIZE 8
#define BCFIELD_SENDER 16

typedef struct _s_boxcheck
{
	struct _s_boxcheck *next;
	bool enabled;
	char *desc;						// Kurze Beschreibung
   int type;						// BCTYPE_*
   char *title;					// Titelzeile
   s_checkpos *board;
   s_checkpos *number;
   s_checkpos *lifetime;
   s_checkpos *size;
   s_checkpos *sender;
   s_checkmust must[10];		// Maximal 10 feste Zeichen
   int mustcount;
   unsigned short minlen;
   int fields;
} s_boxcheck;

extern s_boxcheck *boxcheckroot;


#define COLOR_BLACK 0
#define COLOR_WHITE 1
#define COLOR_DARKGRAY 2
#define COLOR_GRAY 3
#define COLOR_LIGHTGRAY 4
#define COLOR_RED 5
#define COLOR_GREEN 6
#define COLOR_BLUE 7
#define COLOR_CYAN 8
#define COLOR_MAGENTA 9
#define COLOR_YELLOW 10
#define COLOR_DARKRED 11
#define COLOR_DARKGREEN 12
#define COLOR_DARKBLUE 13
#define COLOR_DARKCYAN 14
#define COLOR_DARKMAGENTA 15
#define COLOR_DARKYELLOW 16


#endif   /* GLOBAL_H */

