/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/stat.h>

#include "interface.h"
#include "global.h"
#include "main.h"
#include "toolbox.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>


// Das Rufzeichen, das connected werden soll, ist nicht im Router
// eingetragen
#define ERR_NOT_IN_ROUTER "1"
#define ERR_INVALID_PARM "2"
#define ERR_OPEN_SOCKET "3"
#define ERR_BIND_SOCKET "4"
#define ERR_CONNECT_TWICE "5"
#define ERR_INCREMENT_SSID "6"
#define ERR_UNKNOWN_PORT "7"

extern TopLevel *toplevel;



InterfaceVerwaltung::InterfaceVerwaltung() : QObject()
{
   struct sockaddr_un serv_addr;
   int servlen;
   char socket_path[500];


   sprintf(socket_path,"%s/iface_socket", config->maindir);

   if ((fd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0)
   {
      printf("ERROR: Can't open stream socket\n");
      return;
   }

   bzero((char *) &serv_addr, sizeof(serv_addr));
   serv_addr.sun_family = AF_UNIX;
   strcpy(serv_addr.sun_path, socket_path);
   servlen = strlen(serv_addr.sun_path) + sizeof(serv_addr.sun_family);

   unlink(serv_addr.sun_path);

   if (bind(fd, (struct sockaddr *) &serv_addr, servlen) < 0)
   {
      printf("ERROR: Can't bind socket\n");
      return;
   }

   if (listen(fd, 4) < 0)
   {
      printf("ERROR: Can't listen to socket\n");
      return;
   }

   chmod(socket_path, S_IWUSR|S_IRUSR|S_IXUSR);


   connections = new QList<Interface>();


   sock = new QSocketNotifier( fd, QSocketNotifier::Read, this );
   connect( sock, SIGNAL(activated(int)), this, SLOT(connectionGot(int)) );
}


InterfaceVerwaltung::~InterfaceVerwaltung()
{
}


//   void InterfaceVerwaltung::connectionGot()
//
// Ein weiteres Programm will uns connecten
void InterfaceVerwaltung::connectionGot(int)
{
   int newfd;
#ifdef __GLIBC__
   socklen_t clilen;
#else
   int clilen;
#endif
   struct sockaddr_un cli_addr;

   clilen = sizeof(cli_addr);
   if ((newfd = accept(fd, (struct sockaddr *) &cli_addr, &clilen)) < 0)
   {
      printf("ERROR: Cannot accept connection\n");
      return;
   }

   connections->append(new Interface(newfd));
}


//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////



Interface::Interface(int _fd) : QObject()
{
   fd = _fd;

   sock = new QSocketNotifier( fd, QSocketNotifier::Read, this );
   connect( sock, SIGNAL(activated(int)), this, SLOT(rxData(int)) );

   rxlen = 0;
   rxsave = NULL;
}


Interface::~Interface()
{
}


void Interface::rxData(int)
{
   char tmp[1001],*tmp2;
   int tmplen;
   unsigned short len;
   s_ifaceframe frame;


   if ((tmplen = read(fd, tmp, 1000)) == 0) return;

   // Empfangenen Text hinter den alten empfangenen haengen.
   tmp2 = rxsave;
   rxsave = (char *) malloc(rxlen+tmplen);
   memcpy(rxsave, tmp2, rxlen);
   memcpy(rxsave+rxlen, tmp, tmplen);
   rxlen += tmplen;
   free(tmp2);

   // Gucken, ob ein Frame komplett empfangen wurde.
   for (;;)
   {
      memcpy(&len, rxsave, 2);
      if (len < rxlen-3) return;

      // Mindestens ein Frame wurde komplett empfangen. In die entsprechende
      // struct packen und FrameReady aufrufen.
      frame.id = rxsave[2];
      frame.len = len;
      frame.data = (char *) malloc(len);
      memcpy(frame.data, rxsave+3, len);
      rxlen -= len+3;
      memmove(rxsave, rxsave+len+3, rxlen);

      FrameReady(&frame);
   }
}


//   void Interface::SendFrame(unsigned char frameid, char *data, unsigned short len)
//
// Sendet ein Datenframe an die andere Software
//
// Format:
//     <Laenge (2 bytes)> <Frame-ID (1 byte)> <Daten>
void Interface::SendFrame(unsigned char frameid, char *data, unsigned short len)
{
   char *tmp;

   tmp = (char *) malloc(len+3);

   memcpy(tmp, &len, 2);
   memcpy(tmp+2, &frameid, 1);
   memcpy(tmp+3, data, len);

   write(fd, tmp, len+3);

   free(tmp);
}


//   void Interface::FrameReady()
//
// Ein neues Frame ist komplett empfangen worden und kann weiterverarbeitet
// werden.
void Interface::FrameReady(s_ifaceframe *frame)
{
   printf("frame received. id: %i\n", frame->id);

   switch (frame->id)
   {
      case IBLOCK_CONNECT:  // Ein Connect soll aufgebaut werden
           makeConnect(frame);
           break;
   }
}


//   void Interface::makeConnect(s_ifaceframe *frame)
//
// Von aussen soll ein Connect aufgebaut werden.
void Interface::makeConnect(s_ifaceframe *frame)
{
   s_ifaceconnect *conn;
   bool changed, ready=false;
   char port[500], call[500], digis[500], mycall[100];
   int fd, error, i, len;
   Channel *chan;


   strcpy(mycall, config->send_mycall);

   conn = (s_ifaceconnect *)frame->data;

   strcpy(call, conn->call);

   toplevel->router->getPath( call, changed );

   if (changed)
      if ((i = POS(' ', call)) > -1)
      {
         memcpy(port, call, i);
         port[i] = '\0';
         len = strlen(call)-i-1;
         memmove(call, call+i+1, len);
         call[len] = '\0';
      }
   else
   {
      // Fehlermeldung: Der Router kennt die Gegenstation nicht
      SendFrame( IBLOCK_ERROR, ERR_NOT_IN_ROUTER, strlen(ERR_NOT_IN_ROUTER));
      return;
   }

   // Die Digis 'raussuchen
   if ((i = POS(' ',call)) > -1)
   {
      COPY(digis, call, i+1, strlen(call)-i-1);
      call[i] = '\0';
   }
   else
      digis[0] = '\0';



   do
   {
      fd = toplevel->makeConnect( call, digis, mycall, port, &error );

      if (fd == -1)
      {
         switch (error)
         {
            case 1: // invalid parameter
                    SendFrame( IBLOCK_ERROR, ERR_INVALID_PARM, strlen(ERR_INVALID_PARM));
                    ready = true;
                    break;
            case 2: // cannot open socket
                    SendFrame( IBLOCK_ERROR, ERR_OPEN_SOCKET, strlen(ERR_OPEN_SOCKET));
                    ready = true;
                    break;
            case 3: // cannot bind socket
                    SendFrame( IBLOCK_ERROR, ERR_BIND_SOCKET, strlen(ERR_BIND_SOCKET));
                    ready = true;
                    break;
            case 4: // cannot connect twice
                    if (!config->autoIncSSID)
                    {
                       SendFrame( IBLOCK_ERROR, ERR_CONNECT_TWICE, strlen(ERR_CONNECT_TWICE));
                       ready = true;
                    }
                    else
                       if (!toplevel->incSSID(mycall))
                       {
                          SendFrame( IBLOCK_ERROR, ERR_INCREMENT_SSID, strlen(ERR_INCREMENT_SSID));
                          ready = true;
                       }
                    break;
            case 0xFF: // unknown port name
                    SendFrame( IBLOCK_ERROR, ERR_UNKNOWN_PORT, strlen(ERR_UNKNOWN_PORT));
                    ready = true;
                    break;
         }
      }
      else
      {
         chan = toplevel->addChannelList()->channel = new Channel( 0,
                                                                   port,
                                                                   mycall,
                                                                   call,
                                                                   digis,
                                                                   fd,
                                                                   false);
         chan->setIfaceConnection(this);

         if (config->hideWinOnSwitch)
            if (toplevel->currentChannel != NULL)
               toplevel->currentChannel->hide();
         ready = true;
      }
   }
   while (!ready);
}




#include "interface.moc"

