/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PASSWORDS_H
#define PASSWORDS_H


#include <kmsgbox.h>
#include <qwidget.h>

#include <stdio.h>
#include <stdlib.h>

#include "userinfo.h"


struct s_dieboxtime
{
   int tag;
   int minute;
   int stunde;
};


class Passwords
{
public:
   Passwords(QWidget *rxchan);
   ~Passwords();

   void proceed( const char *data, int len );
   void transmit();
   void activatePassword();

private:
   QWidget *chan;
   UserInfo *uinfo;
   int mode;
   int line;

   int pwtype;          // Welches Password wird gewuenscht? Siehe PW_*
   char *pwstr;

   struct s_dieboxtime *dbtime;

   void checkForPwline( const char *data, int len );
   void checkDieBoxPrompt( const char *data, int len );

   void sendTheboxOldPw();

   void checkPromptBaybox( const char *data, int len );
   void checkPromptFlexOld( const char *data, int len );
   void checkPromptMD5( const char *data, int len );
   void checkPromptAK1A( const char *data, int len );

   void generateRandomChars( char *random, int count );


   void calc_MD5_pw(char *MD5prompt, char *MD5pw, char *MD5result);
};


#endif // PASSWORDS_H

