/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef ROUTER_H
#define ROUTER_H


typedef struct _s_routenode
{
   char *call;
   struct _s_routenode *leaf;    // Ein Blatt -> eine Ebene weiter
   struct _s_routenode *same;    // Das naechste Call auf der gleichen Ebene
   struct _s_routenode *parent;  // Eine Ebene davor
} s_routenode;


class Router
{
public:
   Router();
   ~Router();

   void addRoute(char *call, char *path);
   void showRoutes();
   void getPath( char *call, bool & changed );
   s_routenode * getMajorNode();
   void saveRoutes();
   void readRoutes();
   void deleteNode( char *call );

private:
   s_routenode * getCallInLeaf(char *call, s_routenode *node);
   s_routenode * addCallToLeaf(char *call, s_routenode *last);
   void showThisNode(s_routenode *node, int ebene);
   s_routenode * getCallPtrNode(s_routenode *node, char *call);
   s_routenode * getCallPtr( char *call );
   void saveRoutesShowNode(s_routenode *node, char *path, char *port, int fd);

   // Routinen zum Loeschen von Nodes
   void deleteInParentNode(s_routenode *node);
   void deleteThisNode(s_routenode *node);

   s_routenode *majornode;
};


#endif

