/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <qfiledialog.h>
#include <qbuttongroup.h>

#include "settingsdlg.h"
#include "channel.h"
#include "flags.h"
#include "toolbox.h"
#include <kapp.h>
#include <kmsgbox.h>

#include <stdlib.h>
#include <stdio.h>



void SettingsDlg::generateConfRemotesWidget()
{
   conf_remotes = new QWidget(this);

   quit = new QCheckBox( conf_remotes );
   quit->setGeometry( 30, 30, 130, 20 );
   quit->setText("QUIT" );
   quit->setAutoResize( TRUE );

   version = new QCheckBox( conf_remotes );
   version->setGeometry( 30, 50, 130, 20 );
   version->setText("VERSION");
   version->setAutoResize( TRUE );

   cs = new QCheckBox( conf_remotes );
   cs->setGeometry( 30, 70, 130, 20 );
   cs->setText( "CS" );
   cs->setAutoResize( TRUE );

   setname = new QCheckBox( conf_remotes );
   setname->setGeometry( 30, 90, 130, 20 );
   setname->setText( "NAME" );
   setname->setAutoResize( TRUE );

   comp = new QCheckBox( conf_remotes );
   comp->setGeometry( 30, 110, 130, 20 );
   comp->setText( "COMP" );
   comp->setAutoResize( TRUE );

   write = new QCheckBox( conf_remotes );
   write->setGeometry( 30, 130, 130, 20 );
   write->setText( "WRITE" );
   write->setAutoResize( TRUE );
   write->setEnabled(false);

   read = new QCheckBox( conf_remotes );
   read->setGeometry( 30, 150, 130, 20 );
   read->setText( "READ" );
   read->setAutoResize( TRUE );
   read->setEnabled(false);

   info = new QCheckBox( conf_remotes );
   info->setGeometry( 30, 170, 130, 20 );
   info->setText( "INFO" );
   info->setAutoResize( TRUE );

   help = new QCheckBox( conf_remotes );
   help->setGeometry( 30, 190, 130, 20 );
   help->setText( "HELP" );
   help->setAutoResize( TRUE );

   ring = new QCheckBox( conf_remotes );
   ring->setGeometry( 170, 30, 130, 20 );
   ring->setText( "RING" );
   ring->setAutoResize( TRUE );

   echo = new QCheckBox( conf_remotes );
   echo->setGeometry( 170, 50, 130, 20 );
   echo->setText( "ECHO" );
   echo->setAutoResize( TRUE );

   rtt = new QCheckBox( conf_remotes );
   rtt->setGeometry( 170, 70, 130, 20 );
   rtt->setText( "RTT" );
   rtt->setAutoResize( TRUE );

   dir = new QCheckBox( conf_remotes );
   dir->setGeometry( 170, 90, 130, 20 );
   dir->setText( "DIR" );
   dir->setAutoResize( TRUE );
   dir->setEnabled(false);

   news = new QCheckBox( conf_remotes );
   news->setGeometry( 170, 110, 130, 20 );
   news->setText( "NEWS" );
   news->setAutoResize( TRUE );

   talk = new QCheckBox( conf_remotes );
   talk->setGeometry( 170, 130, 130, 20 );
   talk->setText( "TALK" );
   talk->setAutoResize( TRUE );

   date = new QCheckBox( conf_remotes );
   date->setGeometry( 170, 150, 130, 20 );
   date->setText( "DATE" );
   date->setAutoResize( TRUE );

   ddate = new QCheckBox( conf_remotes );
   ddate->setGeometry( 170, 170, 130, 20 );
   ddate->setText( "DDATE" );
   ddate->setAutoResize( TRUE );

   cookie = new QCheckBox( conf_remotes );
   cookie->setGeometry( 170, 190, 130, 20 );
   cookie->setText( "COOKIE" );
   cookie->setAutoResize( TRUE );
}


void SettingsDlg::generateConfSettingsWidget()
{
   conf_settings = new QWidget(this);

   seven_autosave = new QCheckBox( conf_settings );
   seven_autosave->setGeometry( 260, 10, 130, 20 );
   seven_autosave->setText( klocale->translate ( "7plus - Autosave") );
   seven_autosave->setAutoResize( true );

   bin_autosave = new QCheckBox( conf_settings );
   bin_autosave->setGeometry( 260, 30, 120, 20 );
   bin_autosave->setText( klocale->translate ("BIN - Autosave" ));
   bin_autosave->setAutoResize( true );

   didadit = new QCheckBox( conf_settings );
   didadit->setGeometry( 260, 50, 120, 20 );
   didadit->setText( klocale->translate ("DIDADIT - Autosave" ));
   didadit->setAutoResize( true );

   rec_con = new QCheckBox( conf_settings );
   rec_con->setGeometry( 260, 70, 170, 20 );
   rec_con->setText(klocale->translate( "recognize 'connected to'") );
   rec_con->setAutoResize( true );

   rec_discon = new QCheckBox( conf_settings );
   rec_discon->setGeometry( 260, 90, 180, 20 );
   rec_discon->setText( klocale->translate ("recognize 'reconnected to'") );
   rec_discon->setAutoResize( true );

   autosend_pw = new QCheckBox( conf_settings );
   autosend_pw->setGeometry( 260, 110, 190, 20 );
   autosend_pw->setText( klocale->translate("Autosend passwords") );
   autosend_pw->setAutoResize( true );

   remotes = new QCheckBox( conf_settings );
   remotes->setGeometry( 260, 130, 130, 20 );
   remotes->setText( klocale->translate("remote access") );
   remotes->setAutoResize( true );

   huf_allowed = new QCheckBox( conf_settings );
   huf_allowed->setGeometry( 260, 150, 180, 20 );
   huf_allowed->setText( klocale->translate("#HUF# allowed") );
   huf_allowed->setAutoResize( true );
   connect( huf_allowed, SIGNAL(toggled(bool)), this, SLOT(slotHufAllowToggled(bool)) );


   onlinecomp = new QCheckBox( conf_settings );
   onlinecomp->setGeometry( 260, 170, 190, 20 );
   onlinecomp->setText( klocale->translate( "//COMP active" ));
   onlinecomp->setAutoResize( true );

   hufcomptx = new QCheckBox( conf_settings );
   hufcomptx->setGeometry( 260, 190, 190, 20 );
   hufcomptx->setText( klocale->translate( "#HUF# TX active" ));
   hufcomptx->setAutoResize( true );

   hufcomprx = new QCheckBox( conf_settings );
   hufcomprx->setGeometry( 260, 210, 190, 20 );
   hufcomprx->setText( klocale->translate( "#HUF# RX active" ));
   hufcomprx->setAutoResize( true );

	allowANSI = new QCheckBox( conf_settings );
   allowANSI->setGeometry( 260, 230, 190, 20 );
   allowANSI->setText( klocale->translate( "Allow ANSI-Codes" ));
   allowANSI->setAutoResize( true );
   allowANSI->setEnabled( false );



   QLabel* label;
   label = new QLabel( conf_settings );
   label->setGeometry( 20, 10, 30, 20 );
   label->setText( "Call" );
   label->setAlignment( 289 );
   label->setMargin( -1 );

   call = new QLineEdit( conf_settings );
   call->setGeometry( 20, 30, 100, 20 );
   call->setText( "" );
   call->setMaxLength( 10 );
   call->setEchoMode( QLineEdit::Normal );
   call->setFrame( TRUE );
   call->setEnabled(false);

   label = new QLabel( conf_settings );
   label->setGeometry( 20, 55, 40, 20 );
   label->setText(klocale->translate( "Name" ));
   label->setAlignment( 289 );
   label->setMargin( -1 );

   name = new QLineEdit( conf_settings );
   name->setGeometry( 20, 75, 170, 20 );
   name->setText( "" );
   name->setMaxLength( 20 );
   name->setEchoMode( QLineEdit::Normal );
   name->setFrame( TRUE );


   label = new QLabel( conf_settings );
   label->setGeometry( 20, 100, 100, 20 );
   label->setText(klocale->translate( "Software-Type" ));
   label->setAlignment( 289 );
   label->setMargin( -1 );

   swtype = new QComboBox( conf_settings );
   swtype->setGeometry( 20, 120, 100, 20 );

   //////////////////// TYPE ///////////////////////////////////////
   QButtonGroup *buttongroup = new QButtonGroup( conf_settings );
   buttongroup->setGeometry( 20, 155, 200, 60 );

   buttongroup->setTitle( klocale->translate( "Type "));


   type_term = new QRadioButton( buttongroup );
   type_term->setText( klocale->translate("Terminal"));
   type_term->setGeometry( 10, 15, 90, 20 );
   buttongroup->insert( type_term );

   type_digi = new QRadioButton( buttongroup );
   type_digi->setText( klocale->translate("Digipeater") );
   type_digi->setGeometry( 10, 35, 90, 20 );
   buttongroup->insert( type_digi );

   type_bbs = new QRadioButton( buttongroup );
   type_bbs->setText( klocale->translate("Mailbox"));
   type_bbs->setGeometry( 100, 15, 70, 20 );
   buttongroup->insert( type_bbs );

   type_convers = new QRadioButton( buttongroup );
   type_convers->setText( klocale->translate("Convers"));
   type_convers->setGeometry( 100, 35, 70, 20 );
   buttongroup->insert( type_convers );
}


void SettingsDlg::generateConfPasswordWidget()
{
   QLabel *l;
   QButtonGroup *tmpbtngrp;

   conf_password = new QWidget(this);



   // Passwort-Typ
   tmpbtngrp = new QButtonGroup( conf_password );
   tmpbtngrp->setGeometry( 10, 10, 150, 150 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("PW-Type"));

   pw_baybox = new QRadioButton( tmpbtngrp );
   pw_baybox->setText( klocale->translate("BayBox / FlexNet"));
   pw_baybox->setGeometry( 10, 20, 130, 20 );
   tmpbtngrp->insert( pw_baybox );
   connect(pw_baybox, SIGNAL(toggled(bool)), this, SLOT(slotPwBayBoxToggled(bool)));

   pw_flexnet = new QRadioButton( tmpbtngrp );
   pw_flexnet->setText( klocale->translate("FlexNet (old)"));
   pw_flexnet->setGeometry( 10, 40, 130, 20 );
   tmpbtngrp->insert( pw_flexnet );
   connect(pw_flexnet, SIGNAL(toggled(bool)), this, SLOT(slotPwFlexnetToggled(bool)));

   pw_thebox = new QRadioButton( tmpbtngrp );
   pw_thebox->setText( klocale->translate("TheBox"));
   pw_thebox->setGeometry( 10, 60, 130, 20 );
   tmpbtngrp->insert( pw_thebox );

   pw_theboxold = new QRadioButton( tmpbtngrp );
   pw_theboxold->setText( klocale->translate("TheBox (old)"));
   pw_theboxold->setGeometry( 10, 80, 130, 20 );
   tmpbtngrp->insert( pw_theboxold );
   connect(pw_theboxold, SIGNAL(toggled(bool)), this, SLOT(slotPwTheboxOldToggled(bool)));

   pw_md5 = new QRadioButton( tmpbtngrp );
   pw_md5->setText( "MD5" );
   pw_md5->setGeometry( 10, 100, 130, 20 );
   tmpbtngrp->insert( pw_md5 );
   connect(pw_md5, SIGNAL(toggled(bool)), this, SLOT(slotPwMD5Toggled(bool)));

   pw_ak1a = new QRadioButton( tmpbtngrp );
   pw_ak1a->setText( klocale->translate("AK1A-Cluster"));
   pw_ak1a->setGeometry( 10, 120, 130, 20 );
   tmpbtngrp->insert( pw_ak1a );
   connect(pw_ak1a, SIGNAL(toggled(bool)), this, SLOT(slotPwAK1AToggled(bool)));



   tmpbtngrp = new QButtonGroup( conf_password );
   tmpbtngrp->setGeometry( 170, 10, 120, 60 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("Command"));

   pw_cmd = new QLineEdit( tmpbtngrp );
   pw_cmd->setGeometry( 10, 30, 100, 20 );
   pw_cmd->setText( "" );
   pw_cmd->setMaxLength( 20 );
   pw_cmd->setEchoMode( QLineEdit::Normal );
   pw_cmd->setFrame( TRUE );



   tmpbtngrp = new QButtonGroup( conf_password );
   tmpbtngrp->setGeometry( 170, 80, 120, 60 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("Length of answer"));

   pw_answlen = new KIntLineEdit( tmpbtngrp );
   pw_answlen->setGeometry( 10, 30, 40, 20 );
   pw_answlen->setMaxLength(2);

   incAnswLen = new QPushButton( tmpbtngrp );
   incAnswLen->setGeometry( 50, 30, 10, 10 );
   incAnswLen->setText("+");
   connect( incAnswLen, SIGNAL(clicked()), this, SLOT(slotIncPwLen()) );

   decAnswLen = new QPushButton( tmpbtngrp );
   decAnswLen->setGeometry( 50, 40, 10, 10 );
   decAnswLen->setText("-");
   connect( decAnswLen, SIGNAL(clicked()), this, SLOT(slotDecPwLen()) );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 70, 30, 40, 20 );
   l->setText("bytes");



   tmpbtngrp = new QButtonGroup( conf_password );
   tmpbtngrp->setGeometry( 300, 10, 120, 130 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("answer-chars"));

   pwa_pwchars = new QCheckBox( tmpbtngrp );
   pwa_pwchars->setText( klocale->translate("all pw-chars"));
   pwa_pwchars->setGeometry( 10, 20, 100, 20 );
   connect(pwa_pwchars, SIGNAL(toggled(bool)), this, SLOT(slotPwaToggled(bool)));

   pwa_spec = new QCheckBox( tmpbtngrp );
   pwa_spec->setText( " " );
   pwa_spec->setGeometry( 10, 40, 20, 20 );
   connect(pwa_spec, SIGNAL(toggled(bool)), this, SLOT(slotPwaSpecToggled(bool)));

   pwa_az = new QCheckBox( tmpbtngrp );
   pwa_az->setText( "a..z" );
   pwa_az->setGeometry( 10, 60, 100, 20 );
   connect(pwa_az, SIGNAL(toggled(bool)), this, SLOT(slotPwaToggled(bool)));

   pwa_AZ = new QCheckBox( tmpbtngrp );
   pwa_AZ->setText( "A..Z" );
   pwa_AZ->setGeometry( 10, 80, 100, 20 );
   connect(pwa_AZ, SIGNAL(toggled(bool)), this, SLOT(slotPwaToggled(bool)));

   pwa_09 = new QCheckBox( tmpbtngrp );
   pwa_09->setText( "0..9" );
   pwa_09->setGeometry( 10, 100, 100, 20 );
   connect(pwa_09, SIGNAL(toggled(bool)), this, SLOT(slotPwaToggled(bool)));

   pwa_string = new QLineEdit( tmpbtngrp );
   pwa_string->setGeometry( 30, 40, 80, 20 );



   tmpbtngrp = new QButtonGroup( conf_password );
   tmpbtngrp->setGeometry( 10, 160, 410, 70 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("Password"));

   pw_label = new QLabel( tmpbtngrp );
   pw_label->setGeometry( 10, 20, 310, 20 );
   pw_label->setText(klocale->translate("Please enter the Password:"));

   pw_password = new QLineEdit( tmpbtngrp );
   pw_password->setGeometry( 10, 40, 310, 20 );

   pw_browse = new QPushButton( tmpbtngrp );
   pw_browse->setGeometry( 330, 40, 70, 20 );
   pw_browse->setText(klocale->translate("browse"));
   pw_browse->setToggleButton( false );
   connect(pw_browse, SIGNAL(clicked()), this, SLOT(slotPwBrowse()));
}


void SettingsDlg::generateOthersWindow()
{
   QButtonGroup *tmpbtngrp;
   s_boxcheck *tmp;
   char str[500];
   bool found=false;


   winOthers = new QWidget(this);

   // Zeilenumbruch
   tmpbtngrp = new QButtonGroup( winOthers );
   tmpbtngrp->setGeometry( 10, 10, 200, 80 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("line-break"));


   zeilenumbruch = new QCheckBox( tmpbtngrp );
   zeilenumbruch->setGeometry( 10, 25, 180, 20 );
   zeilenumbruch->setText( klocale->translate ("automatic line-break") );
   connect(zeilenumbruch, SIGNAL(toggled(bool)), this, SLOT(slotToggleUmbruch(bool)));

   lUmbruch = new QLabel( tmpbtngrp );
   lUmbruch->setGeometry( 30, 45, 60, 20 );
   lUmbruch->setText( klocale->translate ("in row") );
   lUmbruch->resize(lUmbruch->sizeHint());

   position = new myNumLineEdit( tmpbtngrp );
   position->setGeometry( 35+lUmbruch->width(), 45, 50, 20);
   position->setMaxLength( 3 );


   // BoxCheck-Konfiguration
   tmpbtngrp = new QButtonGroup( winOthers );
   tmpbtngrp->setGeometry( 10, 100, 200, 70 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("BoxCheck"));

   lBoxCheck = new QLabel( tmpbtngrp );
   lBoxCheck->setGeometry( 10, 20, 180, 20 );
   lBoxCheck->setText( klocale->translate("Use that configuration:") );
   lBoxCheck->resize(lBoxCheck->sizeHint());

   boxcheck_soft = new QComboBox( tmpbtngrp );
   boxcheck_soft->setGeometry( 10, 40, 180, 20 );

   boxcheck_soft->insertItem(klocale->translate("no boxcheck"));
   strcpy(str, ((Channel *)chan)->userinfo->getBoxCheck());
   for (tmp=boxcheckroot; tmp; tmp=tmp->next)
   	if (tmp->enabled)
	   {
	      boxcheck_soft->insertItem(tmp->desc);
	      if (!strcmp(str, tmp->desc))
	      {
	         found = true;
	         boxcheck_soft->setCurrentItem(boxcheck_soft->count()-1);
	      }
	   }

   if (!found)
      boxcheck_soft->setCurrentItem(0);
}



void SettingsDlg::setSettings()
{
  int remote;
  int i;
  char tmp[100];


  char *rx_call = ((Channel *)chan)->getCall();
  if (rx_call == NULL)
     call->setText( "" );
  else
     call->setText( rx_call );

  char *rx_name = ((Channel *)chan)->userinfo->getName();
  if (rx_name == NULL)
     name->setText( "" );
  else
     name->setText( rx_name );

  switch (((Channel *)chan)->userinfo->getType())
  {
    case TYPE_TERMINAL:
         type_term->setChecked( true );
         break;
    case TYPE_MAILBOX:
         type_bbs->setChecked( true );
         break;
    case TYPE_DIGI:
         type_digi->setChecked( true );
         break;
    case TYPE_CONVERS:
         type_convers->setChecked( true );
         break;
  }

  // Online-Komprimierung (//COMP oder #HUF#)
  onlinecomp->setChecked((((Channel *)chan)->flags & CH_COMP) != 0);
  hufcomptx->setChecked((((Channel *)chan)->flags & CH_HUF_TX) != 0);
  hufcomprx->setChecked((((Channel *)chan)->flags & CH_HUF_RX) != 0);

  int flags = ((Channel *)chan)->userinfo->getFlags();
  if ((flags & CH_CHECK7PLUS) != 0)
     seven_autosave->setChecked( true );

  if ((flags & CH_CHECKAUTOBIN) != 0)
     bin_autosave->setChecked( true );

  if ((flags & CH_CHECKDIDADIT) != 0)
     didadit->setChecked( true );

  if ((flags & CH_CHECKCONN) != 0)
     rec_con->setChecked( true );

  if ((flags & CH_CHECKDISC) != 0)
     rec_discon->setChecked( true );

  if ((flags & CH_REMOTE) != 0)
     remotes->setChecked( true );

  if ((flags & CH_AUTOSEND_PW) != 0)
     autosend_pw->setChecked( true );

//	allowANSI->setEnabled( config->allowANSI );
   allowANSI->setChecked( flags & CH_ALLOWANSI );

  // Darf die Gegenstation #HUF# anfordern?
  if ((flags & CH_HUFALLOW) != 0)
  {
     huf_allowed->setChecked( true );
     slotHufAllowToggled( huf_allowed->isChecked() );
  }
  else
     slotHufAllowToggled( huf_allowed->isChecked() );


  remote = ((Channel *)chan)->userinfo->getRemotes();
  if ((remote & REMOTE_QUIT) != 0)
     quit->setChecked( true );

  if ((remote & REMOTE_VERSION) != 0)
     version->setChecked( true );

  if ((remote & REMOTE_CS) != 0)
     cs->setChecked( true );

  if ((remote & REMOTE_NAME) != 0)
     setname->setChecked( true );

  if ((remote & REMOTE_COMP) != 0)
     comp->setChecked( true );

  if ((remote & REMOTE_WRITE) != 0)
     write->setChecked( true );

  if ((remote & REMOTE_READ) != 0)
     read->setChecked( true );

  if ((remote & REMOTE_INFO) != 0)
     info->setChecked( true );

  if ((remote & REMOTE_HELP) != 0)
     help->setChecked( true );

  if ((remote & REMOTE_RING) != 0)
     ring->setChecked( true );

  if ((remote & REMOTE_ECHO) != 0)
     echo->setChecked( true );

  if ((remote & REMOTE_RTT) != 0)
     rtt->setChecked( true );

  if ((remote & REMOTE_DIR) != 0)
     dir->setChecked( true );

  if ((remote & REMOTE_NEWS) != 0)
     news->setChecked( true );

  if ((remote & REMOTE_TALK) != 0)
     talk->setChecked( true );

  if ((remote & REMOTE_DATE) != 0)
     date->setChecked( true );

  if ((remote & REMOTE_DDATE) != 0)
     ddate->setChecked( true );

  if ((remote & REMOTE_COOKIE) != 0)
     cookie->setChecked( true );


  if (!remotes->isChecked())
  {
    // Keine Remote-Befehle - die entsprechenden Boxen ausschalten
    toggleRemoteSettings(false);
  }


  if (((Channel *)chan)->userinfo->getPwd() != NULL)
     pw_password->setText( ((Channel *)chan)->userinfo->getPwd() );
  else
     pw_password->setText( "" );


   //////////////////////// PASSWORT ///////////////////////////
   sprintf(tmp, "%i", ((Channel *)chan)->userinfo->getPwAnswerLen());
   pw_answlen->setText( tmp );

   pw_cmd->setText( ((Channel *)chan)->userinfo->getPwCommand() );
   pwa_string->setText( ((Channel *)chan)->userinfo->getPwAnswerStr() );
   if (((Channel *)chan)->userinfo->getPwd() == NULL)
      pw_password->setText( "" );
   else
      pw_password->setText( ((Channel *)chan)->userinfo->getPwd() );

   // Noch nicht implementierte Passwoerter deaktivieren
   pw_thebox->setEnabled( false );

   switch (((Channel *)chan)->userinfo->getPwmode())
   {
      case PW_BAYBOX:
           pw_baybox->setChecked( true );
           slotPwBayBoxToggled( true );
           break;
      case PW_FLEXNET_OLD:
           pw_flexnet->setChecked( true );
           slotPwFlexnetToggled( true );
           break;
      case PW_DIEBOX:
           pw_thebox->setChecked( true );
           break;
      case PW_DIEBOX_OLD:
           pw_theboxold->setChecked( true );
           slotPwTheboxOldToggled( true );
           break;
      case PW_MD5:
           pw_md5->setChecked( true );
           slotPwMD5Toggled( true );
           break;
      case PW_AK1A:
           pw_ak1a->setChecked( true );
           slotPwAK1AToggled( true );
           break;
      default: pw_baybox->setChecked( true );
   }

   i = ((Channel *)chan)->userinfo->getPwAnswer();

   if ((i & PWA_ALLPWCHARS) != 0)
      pwa_pwchars->setChecked( true );
   if ((i & PWA_SPECIFIED) != 0)
   {
      pwa_spec->setChecked( true );
      pwa_string->setEnabled( true );
   }
   else pwa_string->setEnabled( false );
   if ((i & PWA_AtoZ) != 0)
      pwa_AZ->setChecked( true );
   if ((i & PWA_atoz) != 0)
      pwa_az->setChecked( true );
   if ((i & PWA_0to9) != 0)
      pwa_09->setChecked( true );

   // Zeilenumbruch
   zeilenumbruch->setChecked( ((Channel *)chan)->userinfo->getUmbruch() );
   if (!((Channel *)chan)->userinfo->getUmbruch())
   {
      position->setEnabled( false );
      lUmbruch->setEnabled( false );
   }
   sprintf(tmp,"%i", ((Channel *)chan)->userinfo->getUmbruchPos());
   position->setText( tmp );


   // Software-Typen
   for (i=0;i<SW_ANZ;i++)
   {
      swtype->insertItem(swType[i].text);
      if (swType[i].id == ((Channel *)chan)->userinfo->getSwType())
         swtype->setCurrentItem( swtype->count()-1 );
   }
}


void SettingsDlg::saveEntries()
{
   int i;


   ((Channel *)chan)->userinfo->autoSave = false;

   int flags = ((Channel *)chan)->userinfo->getFlags();

   if (seven_autosave->isChecked())
      flags |= CH_CHECK7PLUS;
   else
      flags &= ~CH_CHECK7PLUS;

   if (bin_autosave->isChecked())
      flags |= CH_CHECKAUTOBIN;
   else
      flags &= ~CH_CHECKAUTOBIN;

   if (didadit->isChecked())
      flags |= CH_CHECKDIDADIT;
   else
      flags &= ~CH_CHECKDIDADIT;

   if (rec_con->isChecked())
      flags |= CH_CHECKCONN;
   else
      flags &= ~CH_CHECKCONN;

   if (rec_discon->isChecked())
      flags |= CH_CHECKDISC;
   else
      flags &= ~CH_CHECKDISC;

   if ( autosend_pw->isChecked() )
      flags |= CH_AUTOSEND_PW;
   else
      flags &= ~CH_AUTOSEND_PW;

   if (remotes->isChecked())
      flags |= CH_REMOTE;
   else
      flags &= ~CH_REMOTE;

   // Darf die Gegenstation #HUF# anfordern?
   if (huf_allowed->isChecked())
      flags |= CH_HUFALLOW;
   else
      flags &= ~CH_HUFALLOW;

   // Geaenderte Flags speichern
   ((Channel *)chan)->userinfo->setFlags(flags);

   if (onlinecomp->isChecked())
      ((Channel *)chan)->flags |= CH_COMP;
   else
      ((Channel *)chan)->flags &= ~CH_COMP;

   if (hufcomptx->isChecked())
      ((Channel *)chan)->flags |= CH_HUF_TX;
   else
      ((Channel *)chan)->flags &= ~CH_HUF_TX;

   if (hufcomprx->isChecked())
      ((Channel *)chan)->flags |= CH_HUF_RX;
   else
      ((Channel *)chan)->flags &= ~CH_HUF_RX;


   // Name
   ((Channel *)chan)->userinfo->setName ( name->text() );

   // Stations-Typ
   if (type_term->isChecked())
      ((Channel *)chan)->userinfo->setType( TYPE_TERMINAL );
   else if (type_digi->isChecked())
           ((Channel *)chan)->userinfo->setType( TYPE_DIGI );
        else if (type_bbs->isChecked())
                ((Channel *)chan)->userinfo->setType( TYPE_MAILBOX );
             else if (type_convers->isChecked())
                     ((Channel *)chan)->userinfo->setType( TYPE_CONVERS );

   // Remotes
   int remote = 0;
   if (remotes->isChecked())
   {
      if (quit->isChecked())
         remote |= REMOTE_QUIT;
      if (version->isChecked())
         remote |= REMOTE_VERSION;
      if (cs->isChecked())
         remote |= REMOTE_CS;
      if (setname->isChecked())
         remote |= REMOTE_NAME;
      if (comp->isChecked())
         remote |= REMOTE_COMP;
      if (write->isChecked())
         remote |= REMOTE_WRITE;
      if (read->isChecked())
         remote |= REMOTE_READ;
      if (info->isChecked())
         remote |= REMOTE_INFO;
      if (help->isChecked())
         remote |= REMOTE_HELP;
      if (ring->isChecked())
         remote |= REMOTE_RING;
      if (echo->isChecked())
         remote |= REMOTE_ECHO;
      if (rtt->isChecked())
         remote |= REMOTE_RTT;
      if (dir->isChecked())
         remote |= REMOTE_DIR;
      if (news->isChecked())
         remote |= REMOTE_NEWS;
      if (talk->isChecked())
         remote |= REMOTE_TALK;
      if (date->isChecked())
         remote |= REMOTE_DATE;
      if (ddate->isChecked())
         remote |= REMOTE_DDATE;
      if (cookie->isChecked())
         remote |= REMOTE_COOKIE;
   }
   ((Channel *)chan)->userinfo->setRemotes( remote );


   // ******** Passwort-Konfiguration *************
   if (pw_baybox->isChecked())
      ((Channel *)chan)->userinfo->setPwmode(PW_BAYBOX);
   if (pw_flexnet->isChecked())
      ((Channel *)chan)->userinfo->setPwmode(PW_FLEXNET_OLD);
   if (pw_thebox->isChecked())
      ((Channel *)chan)->userinfo->setPwmode(PW_DIEBOX);
   if (pw_theboxold->isChecked())
      ((Channel *)chan)->userinfo->setPwmode(PW_DIEBOX_OLD);
   if (pw_md5->isChecked())
      ((Channel *)chan)->userinfo->setPwmode(PW_MD5);
   if (pw_ak1a->isChecked())
      ((Channel *)chan)->userinfo->setPwmode(PW_AK1A);

   if (pw_password->text()[0] == '\0')
      ((Channel *)chan)->userinfo->setPwd( NULL );
   else
      ((Channel *)chan)->userinfo->setPwd( pw_password->text() );

   i = 0;
   if (pwa_pwchars->isChecked())
      i |= PWA_ALLPWCHARS;
   if (pwa_spec->isChecked())
      i |= PWA_SPECIFIED;
   if (pwa_AZ->isChecked())
      i |= PWA_AtoZ;
   if (pwa_az->isChecked())
      i |= PWA_atoz;
   if (pwa_09->isChecked())
      i |= PWA_0to9;

   ((Channel *)chan)->userinfo->setPWInfos( i,
                                            pw_cmd->text(),
                                            pwa_string->text());

   i = pw_answlen->getValue();
   if (i < 5)
      ((Channel *)chan)->userinfo->setPwAnswerLen( 5 );
   else
      if (i > 80)
         ((Channel *)chan)->userinfo->setPwAnswerLen( 80 );
      else
         ((Channel *)chan)->userinfo->setPwAnswerLen( i );

   ((Channel *)chan)->userinfo->setBoxCheck( boxcheck_soft->currentText() );
   ((Channel *)chan)->updateBoxcheckCfg();

   // Daten in Userinfo abspeichern
   ((Channel *)chan)->userinfo->setUmbruch( zeilenumbruch->isChecked(), atoi(position->text()) );

   // Software-Type
   ((Channel *)chan)->userinfo->setSwType( swType[swtype->currentItem()].id );

   ((Channel *)chan)->userinfo->autoSave = true;
   ((Channel *)chan)->userinfo->writeData();
}


void SettingsDlg::toggleRemoteSettings(bool status)
{
  quit->setEnabled(status);
  version->setEnabled(status);
  cs->setEnabled(status);
  setname->setEnabled(status);
  comp->setEnabled(status);
//  write->setEnabled(status);
//  read->setEnabled(status);
  info->setEnabled(status);
  help->setEnabled(status);
  ring->setEnabled(status);
  echo->setEnabled(status);
  rtt->setEnabled(status);
//  dir->setEnabled(status);
  news->setEnabled(status);
  talk->setEnabled(status);
  date->setEnabled(status);
  ddate->setEnabled(status);
  cookie->setEnabled(status);
}


SettingsDlg::SettingsDlg(QWidget *parent)
                   : QTabDialog(0, klocale->translate("configure"), TRUE)
{
   setFixedSize(455, 330);

   chan = parent;

   setCaption(klocale->translate("configure"));

   generateConfSettingsWidget();
   addTab(conf_settings, klocale->translate("&Settings"));

   generateConfRemotesWidget();
   addTab(conf_remotes, klocale->translate("&Remotes"));

   generateConfPasswordWidget();
   addTab(conf_password, klocale->translate("&Password"));

   generateOthersWindow();
   addTab(winOthers, klocale->translate("&Others"));


   setSettings();

   setCancelButton();

   // OK/Apply-Button bemerken
   connect( this, SIGNAL(applyButtonPressed()), SLOT(saveEntries()));

   // Wenn die Remote-Befehle ganz abgeschaltet werden, werden die
   // einzelnen Remote-Buttons inaktiv gemacht
   connect( remotes, SIGNAL(toggled(bool)), SLOT(toggleRemoteSettings(bool)));
}


void SettingsDlg::slotPwaSpecToggled(bool active)
{
   pwa_string->setEnabled(active);

   if (!pwa_pwchars->isChecked() &&
       !pwa_spec->isChecked() &&
       !pwa_AZ->isChecked() &&
       !pwa_az->isChecked() &&
       !pwa_09->isChecked())
   {
      pw_answlen->setEnabled( false );
      incAnswLen->setEnabled( false );
      decAnswLen->setEnabled( false );
   }
   else
   {
      pw_answlen->setEnabled( true );
      incAnswLen->setEnabled( true );
      decAnswLen->setEnabled( true );
   }
}


void SettingsDlg::slotPwaToggled(bool)
{
   if (!pwa_pwchars->isChecked() &&
       !pwa_spec->isChecked() &&
       !pwa_AZ->isChecked() &&
       !pwa_az->isChecked() &&
       !pwa_09->isChecked())
   {
      pw_answlen->setEnabled( false );
      incAnswLen->setEnabled( false );
      decAnswLen->setEnabled( false );
   }
   else
   {
      pw_answlen->setEnabled( true );
      incAnswLen->setEnabled( true );
      decAnswLen->setEnabled( true );
   }
}


void SettingsDlg::slotPwBrowse()
{
   char tmp[200];
   QString fname = QFileDialog::getOpenFileName(tmp);

   // Cancel
   if (fname.isEmpty()) return;

   strcpy(tmp, (const char *)fname);

   if (!file_exist(tmp))
   {
      KMsgBox::message(NULL, klocale->translate("File not found"),
                             klocale->translate("Cannot find specified file."));
      return;
   }

   // Beim alten DieBox-Passwort wird der Dateiname unter pw_password
   // abgespeichert.

   if (pw_theboxold->isChecked())
   {
      pw_password->setText(tmp);
      return;
   }

   // Die Datei oeffnen und die erste Zeile auslesen.
   FILE *f = fopen(tmp, "r");

   if (fgets(tmp, 199, f) != NULL)
      pw_password->setText(tmp);

   fclose(f);
}


void SettingsDlg::slotPwBayBoxToggled(bool active)
{
   if (active)
   {
      pwa_pwchars->setEnabled( true );
      pwa_spec->setEnabled( true );
      pwa_AZ->setEnabled( true );
      pwa_az->setEnabled( true );
      pwa_09->setEnabled( true );
      pw_answlen->setEnabled( true );
      incAnswLen->setEnabled( true );
      decAnswLen->setEnabled( true );
      if (pwa_spec->isChecked()) pwa_string->setEnabled(true);
      slotPwaToggled(true);
      pw_password->setMaxLength( 100 );
   }
}


void SettingsDlg::slotPwAK1AToggled(bool active)
{
   if (active)
   {
      pwa_pwchars->setEnabled( false );
      pwa_spec->setEnabled( false );
      pwa_AZ->setEnabled( false );
      pwa_az->setEnabled( false );
      pwa_09->setEnabled( false );
      pw_answlen->setEnabled( false );
      incAnswLen->setEnabled( false );
      decAnswLen->setEnabled( false );
      slotPwaToggled(true);
      pw_password->setMaxLength( 100 );
   }
}


void SettingsDlg::slotPwFlexnetToggled(bool active)
{
   if (active)
   {
      pwa_pwchars->setEnabled( false );
      pwa_spec->setEnabled( false );
      pwa_AZ->setEnabled( false );
      pwa_az->setEnabled( false );
      pwa_09->setEnabled( false );
      pw_answlen->setEnabled( false );
      incAnswLen->setEnabled( false );
      decAnswLen->setEnabled( false );
      pwa_string->setEnabled( false );
      pw_password->setMaxLength( 5 );
   }
}


void SettingsDlg::slotPwTheboxOldToggled( bool active )
{
   if (active)
   {
      pwa_pwchars->setEnabled( false );
      pwa_spec->setEnabled( false );
      pwa_AZ->setEnabled( false );
      pwa_az->setEnabled( false );
      pwa_09->setEnabled( false );
      pw_answlen->setEnabled( false );
      incAnswLen->setEnabled( false );
      decAnswLen->setEnabled( false );
      pwa_string->setEnabled( false );
      pw_password->setMaxLength( 100 );   // Filenamen
   }
}


void SettingsDlg::slotPwMD5Toggled(bool active)
{
   if (active)
   {
      pwa_pwchars->setEnabled( false );
      pwa_spec->setEnabled( false );
      pwa_AZ->setEnabled( false );
      pwa_az->setEnabled( false );
      pwa_09->setEnabled( false );
      pw_answlen->setEnabled( false );
      incAnswLen->setEnabled( false );
      decAnswLen->setEnabled( false );
      pwa_string->setEnabled( false );
      pw_password->setMaxLength( 100 );
   }
}



void SettingsDlg::slotToggleUmbruch(bool active)
{
   position->setEnabled( active );
   lUmbruch->setEnabled( active );
}


void SettingsDlg::slotHufAllowToggled( bool active )
{
     hufcomptx->setEnabled( active );
     hufcomprx->setEnabled( active );
}


void SettingsDlg::slotIncPwLen()
{
   int value = pw_answlen->getValue();
   char tmp[5];

   value += 5;
   if (value < 5) value = 5;
   if (value > 80) value = 80;
   sprintf(tmp, "%i", value);
   pw_answlen->setText( tmp );
}


void SettingsDlg::slotDecPwLen()
{
   int value = pw_answlen->getValue();
   char tmp[5];

   value -= 5;
   if (value > 80) value = 80;
   if (value < 5) value = 5;
   sprintf(tmp, "%i", value);
   pw_answlen->setText( tmp );
}


#include "settingsdlg.moc"

