/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef USERINFO_H
#define USERINFO_H



class UserInfo
{
public:
   UserInfo( char *rx_call );
   ~UserInfo();

   char * getName();
   int getFlags();
   int getPwmode();
   char * getPwd();
   int getType();
   long getRemotes();
   int getPwAnswer();
   int getPwAnswerLen();
   char * getPwCommand();
   char * getPwAnswerStr();
   bool getUmbruch();
   int getUmbruchPos();
   int getSwType();
   char * getBoxCheck();

   void setName( const char *newname );
   void setFlags( const int newflags );
   void setPwmode( const int newpwmode );
   void setPwd( const char *newPwd );
   void setType( const int newtype );
   void setRemotes( const long newremotes );
   void setPWInfos( const int answer, const char *command, const char *answerstr);
   void setPwAnswerLen( const int len );
   void setUmbruch( const bool _umbruch, const int _umbruchpos );
   void setSwType( const int _swtype );
   void setBoxCheck( const char *boxcheck );

   void writeData();
   bool autoSave;

private:
   // Userdaten
   char name[21];
   char call[10];
   int flags;
   int pwmode;
   char *password;
   int type;
   long remotes;
   int pwanswer;
   int pwanswerlen;
   char pwcommand[21];
   char pwanswerstr[52];
   bool umbruch;
   int umbruchpos;
   int swtype;
   char boxCheck[26];

   void clearData();
   bool readData();
};


#endif

