/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef VORSCHREIB_H
#define VORSCHREIB_H


#include <qwidget.h>
#include <qmultilinedit.h>

#include "chanlist.h"

// Implementation einer von QMultiLineEdit abgleiteten Klasse, die
// einen Vorschreibpuffer zur Verfuegung stellt, wie ich ihn mir vorstelle.


class myVorschreib : public QMultiLineEdit
{
   Q_OBJECT;
public:
   myVorschreib( ChanList *rxlist, QWidget *rxchan, QWidget *parent=0, const char *name=0 );

   void setMaxLines(int count=0);
   void setColors( QColor & font, QColor & back );

protected:
   void keyPressEvent( QKeyEvent *e);
   void focusInEvent(QFocusEvent *f);
   void setupPainter(QPainter *p);
   void paintCell( QPainter *p, int row, int col );
   void mousePressEvent( QMouseEvent *e );

signals:
   void signalPageUp();
   void signalPageDown();
   void signalFunctionKey(int id);
   void kontextMenu();

private:
   int maxlines;

   ChanList *list;
   QWidget *chan;
   QColor cFont, cBack;
};


#endif // VORSCHREIB_H

