/*
 *  MonKT - a monitor for LinKT
 *  Copyright (C) 1998-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "preferences.h"
#include "global.h"
#include "toolbox.h"
#include "main.h"

#include <qlabel.h>
#include <qbuttongroup.h>

#include <kapp.h>

// Um die vorhandenen Schriften vom X-Server einzulesen
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>



#define BTNLENGTH 80
#define BTNHEIGHT 25
#define ABSTAND_UNTEN 5



extern KApplication *mykapp;



//   DlgFontColor::DlgFontColor()
//
// Konstruktur - ein modaler Dialog
DlgFontColor::DlgFontColor( QWidget *parent ) : QTabDialog( parent, "", true )
{
   this->parent = parent;

   setCaption(klocale->translate("MonKT: Colors && Fonts"));

   setFixedSize(350,350);

   setupColorWindow();
   addTab(winColor, klocale->translate("&Colors"));

   setupFontWindow();
   addTab(winFont, klocale->translate("&Fonts"));

   setStandard();

   setCancelButton();
   connect( this, SIGNAL(applyButtonPressed()), SLOT(slotOkPressed()));
}


DlgFontColor::~DlgFontColor()
{
   delete desc;
   delete colors;
   delete winColor;
}


void DlgFontColor::setupColorWindow()
{
   winColor = new QWidget( this );

   desc = new QListBox( winColor );
   desc->setGeometry( 5, 5, 150, 220 );
   connect(desc, SIGNAL(highlighted(int)), this, SLOT(slotChangeField(int)));

   colors = new QListBox( winColor );
   colors->setGeometry( 175, 5, 150, 220 );
   connect(colors, SIGNAL(highlighted(int)), this, SLOT(slotChangeColor(int)));


   // Eintraege in die Desc- und die Colors-Liste
   desc->insertItem( klocale->translate("Background Monitor") );
   desc->insertItem( klocale->translate("Error") );
   desc->insertItem( klocale->translate("Port") );
   desc->insertItem( klocale->translate("Kiss") );
   desc->insertItem( klocale->translate("BPQ") );
   desc->insertItem( klocale->translate("Data") );
   desc->insertItem( klocale->translate("Protocol") );
   desc->insertItem( klocale->translate("AX25-Header") );
   desc->insertItem( klocale->translate("Address") );
   desc->insertItem( klocale->translate("IP-Header") );
   desc->insertItem( klocale->translate("TCP-Header") );
   desc->insertItem( klocale->translate("Rose-Header") );
   desc->insertItem( klocale->translate("Timestamp") );
   desc->insertItem( klocale->translate("Flexnet") );
   desc->insertItem( klocale->translate("Zierrat") );
   desc->insertItem( klocale->translate("Call") );
   desc->insertItem( klocale->translate("FromCall") );
   desc->insertItem( klocale->translate("ToCall") );
   desc->insertItem( klocale->translate("ViaCall") );
   desc->insertItem( klocale->translate("Hdr-Val") );
   desc->insertItem( klocale->translate("Mark-Color") );
   desc->insertItem( klocale->translate("Mark-Background") );
   desc->insertItem( klocale->translate("QSO-Spy-Color 1") );
   desc->insertItem( klocale->translate("QSO-Spy-Color 2") );
   desc->insertItem( klocale->translate("QSO-Spy-Status-Color") );


   colors->insertItem( klocale->translate("black") );
   colors->insertItem( klocale->translate("white") );
   colors->insertItem( klocale->translate("dark-gray") );
   colors->insertItem( klocale->translate("gray") );
   colors->insertItem( klocale->translate("light-gray") );
   colors->insertItem( klocale->translate("red") );
   colors->insertItem( klocale->translate("green") );
   colors->insertItem( klocale->translate("blue") );
   colors->insertItem( klocale->translate("cyan") );
   colors->insertItem( klocale->translate("magenta") );
   colors->insertItem( klocale->translate("yellow") );
   colors->insertItem( klocale->translate("dark-red") );
   colors->insertItem( klocale->translate("dark-green") );
   colors->insertItem( klocale->translate("dark-blue") );
   colors->insertItem( klocale->translate("dark-cyan") );
   colors->insertItem( klocale->translate("dark-magenta") );
   colors->insertItem( klocale->translate("dark-yellow") );


   hdrbold = new QCheckBox( winColor );
   hdrbold->setGeometry(10, 235, 230, 20);
   hdrbold->setText( klocale->translate("AX.25-Header bold?") );

   markbold = new QCheckBox( winColor );
   markbold->setGeometry(10, 255, 230, 20);
   markbold->setText( klocale->translate("Marked text bold?") );
}


void DlgFontColor::setupFontWindow()
{
   winFont = new QWidget( this );


   QButtonGroup *buttongroup = new QButtonGroup( winFont );
   buttongroup->setGeometry( 10, 10, 250, 50 );
   buttongroup->setFrameStyle( 49 );
   buttongroup->setTitle( klocale->translate("fonts") );

   lMoni = new QLabel( buttongroup );
   lMoni->setGeometry( 10, 20, 50, 20 );
   lMoni->setText( klocale->translate("monitor") );

   cmbMoni = new QComboBox( buttongroup );
   cmbMoni->setGeometry( 70, 20, 120, 20 );

   sizeMoni = new KIntLineEdit( buttongroup );
   sizeMoni->setGeometry( 200, 20, 40, 20 );
}


void DlgFontColor::setStandard()
{
   char tmp[100];


   changedColors[0] = config->colors->background;
   changedColors[1] = config->colors->colorError;
   changedColors[2] = config->colors->colorPort;
   changedColors[3] = config->colors->colorKiss;
   changedColors[4] = config->colors->colorBpq;
   changedColors[5] = config->colors->colorData;
   changedColors[6] = config->colors->colorProtocol;
   changedColors[7] = config->colors->colorAxhdr;
   changedColors[8] = config->colors->colorAddr;
   changedColors[9] = config->colors->colorIphdr;
   changedColors[10] = config->colors->colorTcphdr;
   changedColors[11] = config->colors->colorRosehdr;
   changedColors[12] = config->colors->colorTimestamp;
   changedColors[13] = config->colors->colorFlexnet,
   changedColors[14] = config->colors->colorZierrat;
   changedColors[15] = config->colors->colorCall;
   changedColors[16] = config->colors->colorFmCall;
   changedColors[17] = config->colors->colorToCall;
   changedColors[18] = config->colors->colorViaCall;
   changedColors[19] = config->colors->colorHdrVal;
   changedColors[20] = config->colors->qsoWinMarkColor;
   changedColors[21] = config->colors->qsoWinMarkBack;
   changedColors[22] = config->colors->spyColor1;
   changedColors[23] = config->colors->spyColor2;
   changedColors[24] = config->colors->spyColorStatus;

   if (config->colors->mark_bold) markbold->setChecked( true );
   if (config->colors->boldHeader) hdrbold->setChecked( true );

   // Die vorhandenen Fonts einlesen und anzeigen
   readFonts();

   sprintf(tmp, "%i", config->size_output);
   sizeMoni->setText( tmp );
}


void DlgFontColor::slotChangeField(int index)
{
   colors->setCurrentItem(changedColors[index]);
}


void DlgFontColor::slotChangeColor(int index)
{
   changedColors[desc->currentItem()] = index;
}


void DlgFontColor::slotOkPressed()
{
   saveData();
   close();
}


void DlgFontColor::saveData()
{
   KConfig *kconfig;
   char tmp[100];


   kconfig = mykapp->getConfig();

   kconfig->setGroup( "Colors" );

   config->colors->background = changedColors[0];
   sprintf(tmp, "%i", config->colors->background);
   kconfig->writeEntry("background", tmp);

   config->colors->colorError = changedColors[1];
   sprintf(tmp, "%i", config->colors->colorError);
   kconfig->writeEntry("error", tmp);

   config->colors->colorPort = changedColors[2];
   sprintf(tmp, "%i", config->colors->colorPort);
   kconfig->writeEntry("port", tmp);

   config->colors->colorKiss = changedColors[3];
   sprintf(tmp, "%i", config->colors->colorKiss);
   kconfig->writeEntry("kiss", tmp);

   config->colors->colorBpq = changedColors[4];
   sprintf(tmp, "%i", config->colors->colorBpq);
   kconfig->writeEntry("bpq", tmp);

   config->colors->colorData = changedColors[5];
   sprintf(tmp, "%i", config->colors->colorData);
   kconfig->writeEntry("data", tmp);

   config->colors->colorProtocol = changedColors[6];
   sprintf(tmp, "%i", config->colors->colorProtocol);
   kconfig->writeEntry("protocol", tmp);

   config->colors->colorAxhdr = changedColors[7];
   sprintf(tmp, "%i", config->colors->colorAxhdr);
   kconfig->writeEntry("ax25-hdr", tmp);

   config->colors->colorAddr = changedColors[8];
   sprintf(tmp, "%i", config->colors->colorAddr);
   kconfig->writeEntry("address", tmp);

   config->colors->colorIphdr = changedColors[9];
   sprintf(tmp, "%i", config->colors->colorIphdr);
   kconfig->writeEntry("ip-hdr", tmp);

   config->colors->colorTcphdr = changedColors[10];
   sprintf(tmp, "%i", config->colors->colorTcphdr);
   kconfig->writeEntry("tcp-hdr", tmp);

   config->colors->colorRosehdr = changedColors[11];
   sprintf(tmp, "%i", config->colors->colorRosehdr);
   kconfig->writeEntry("rose-hdr", tmp);

   config->colors->colorTimestamp = changedColors[12];
   sprintf(tmp, "%i", config->colors->colorTimestamp);
   kconfig->writeEntry("timestamp", tmp);

   config->colors->colorFlexnet = changedColors[13];
   sprintf(tmp, "%i", config->colors->colorFlexnet);
   kconfig->writeEntry("flexnet", tmp);

   config->colors->colorZierrat = changedColors[14];
   sprintf(tmp, "%i", config->colors->colorZierrat);
   kconfig->writeEntry("zierrat", tmp);

   config->colors->colorCall = changedColors[15];
   sprintf(tmp, "%i", config->colors->colorCall);
   kconfig->writeEntry("call", tmp);

   config->colors->colorFmCall = changedColors[16];
   sprintf(tmp, "%i", config->colors->colorFmCall);
   kconfig->writeEntry("fm-call", tmp);

   config->colors->colorToCall = changedColors[17];
   sprintf(tmp, "%i", config->colors->colorToCall);
   kconfig->writeEntry("to-call", tmp);

   config->colors->colorViaCall = changedColors[18];
   sprintf(tmp, "%i", config->colors->colorViaCall);
   kconfig->writeEntry("via-call", tmp);

   config->colors->colorHdrVal = changedColors[19];
   sprintf(tmp, "%i", config->colors->colorHdrVal);
   kconfig->writeEntry("hdr-val", tmp);

   config->colors->qsoWinMarkColor = changedColors[20];
   sprintf(tmp, "%i", config->colors->qsoWinMarkColor);
   kconfig->writeEntry("winMarkColor", tmp);

   config->colors->qsoWinMarkBack = changedColors[21];
   sprintf(tmp, "%i", config->colors->qsoWinMarkBack);
   kconfig->writeEntry("winMarkBack", tmp);

   config->colors->spyColor1 = changedColors[22];
   sprintf(tmp, "%i", config->colors->spyColor1);
   kconfig->writeEntry("spyColor1", tmp);

   config->colors->spyColor2 = changedColors[23];
   sprintf(tmp, "%i", config->colors->spyColor2);
   kconfig->writeEntry("spyColor2", tmp);

   config->colors->spyColorStatus = changedColors[24];
   sprintf(tmp, "%i", config->colors->spyColorStatus);
   kconfig->writeEntry("spyColorStatus", tmp);

   if (markbold->isChecked())
   {
      kconfig->writeEntry("winMarkBold","1");
      config->colors->mark_bold = true;
   }
   else
   {
      kconfig->writeEntry("winMarkBold","0");
      config->colors->mark_bold = false;
   }

   if (hdrbold->isChecked())
   {
      kconfig->writeEntry("bold-header","1");
      config->colors->boldHeader = true;
   }
   else
   {
      kconfig->writeEntry("bold-header","0");
      config->colors->boldHeader = false;
   }


   // Schriften und Schriftgroessen
   kconfig->setGroup( "Fonts&Sizes" );

   kconfig->writeEntry("font_output", cmbMoni->currentText());
   if (config->font_output != NULL)
      free(config->font_output);
   config->font_output = (char *) strdup(cmbMoni->currentText());

   kconfig->writeEntry("size_output", sizeMoni->text());
   config->size_output = atoi(sizeMoni->text());

   ((TopLevel *)parent)->updateFonts();


   kconfig->sync();
}


//   void DlgWindow::readFonts()
//
// Liest eine Liste aller Schriften ein, die unter X11 bekannt sind.
void DlgFontColor::readFonts()
{
   Display *kde_display;
   char **fontNames;
   char **fontNames_copy;
   int numFonts,k;
   QString qfontname;
   QStrList fontlist(true);
   bool foundmoni=false;


   kde_display = XOpenDisplay( NULL );

   fontNames = XListFonts(kde_display, "*", 32767, &numFonts);
   fontNames_copy = fontNames;

   for (k=0;k<numFonts;k++)
   {
      if (**fontNames != '-')   // Fontnamen starten nicht mit einem Minus-Zeichen -> ein Alias
      {
         fontNames++;
         continue;
      }

      qfontname = "";
      qfontname = *fontNames;
      int dash = qfontname.find('-',1,true);    // Find next dash

      if (dash == -1)  // Kein weiterer Strich. Das sollte eigentlich nicht
      {                // passieren. Ueberspringen.
         fontNames++;
         continue;
      }

      int dash_two = qfontname.find('-', dash+1, true);

      if (dash == -1)  // Kein weiterer Strich. Das sollte eigentlich nicht
      {                // passieren. Ueberspringen.
         fontNames++;
         continue;
      }

      // Font family name aus dem font-info-string holen
      qfontname = qfontname.mid(dash+1, dash_two-dash-1);

      if (fontlist.find(qfontname) == -1)
         fontlist.inSort(qfontname);

      fontNames++;

   }

   XFreeFontNames(fontNames_copy);
   XCloseDisplay(kde_display);

   k = 0;
   for (fontlist.first(); fontlist.current(); fontlist.next())
   {
      cmbMoni->insertItem(fontlist.current());

      if (!strcmp(fontlist.current(), config->font_output))
      {
         cmbMoni->setCurrentItem( k );
         foundmoni = true;
      }
      if (!strcmp(fontlist.current(),"courier"))
      {
         if (!foundmoni)
            cmbMoni->setCurrentItem( k );
      }

      k++;
   }
}



//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


DlgDX::DlgDX() : QDialog(0, "", true)
{
   setCaption(klocale->translate("MonKT: DX-Cluster"));

   setFixedSize( 300, 240 );

   setupWindow();
   setStandard();
}


DlgDX::~DlgDX()
{
   delete act;
   delete pos;
   delete ok;
   delete abort;
}


void DlgDX::setupWindow()
{

   act = new QCheckBox( this );
   act->setText(klocale->translate("activate dx-cluster-spy?"));
   act->setGeometry( 10, 10, 300, 20 );
   connect( act, SIGNAL(toggled(bool)), SLOT(slotActToggled(bool)) );



   QLabel* label;
   label = new QLabel( this );
   label->setGeometry( 10, 40, 300, 20 );
   label->setText( klocale->translate("Your QTH-Locator") );

   pos = new QLineEdit( this );
   pos->setGeometry( 10, 60, 60, 20 );
   pos->setMaxLength( 6 );



   label = new QLabel( this );
   label->setGeometry( 10, 90, 250, 20 );
   label->setText( klocale->translate("Position DX-data-file") );
   dxdata = new QLineEdit( this );
   dxdata->setGeometry( 10, 110, 250, 20 );


	lKmMiles = new QLabel( this );
	lKmMiles->setGeometry( 10, 140, 250, 20 );
	lKmMiles->setText( klocale->translate("Distances in kilometers or miles?") );

   btngrpKmMiles = new QButtonGroup( this );
   btngrpKmMiles->setGeometry(10, 160, 250, 20 );
   btngrpKmMiles->setFrameStyle( QButtonGroup::NoFrame );


   km = new QRadioButton( btngrpKmMiles );
   km->setGeometry( 0, 0, 100, 20 );
   km->setText( klocale->translate("Kilometers") );
   btngrpKmMiles->insert( km );

   mls = new QRadioButton( btngrpKmMiles );
   mls->setGeometry( 110, 0, 100, 20 );
   mls->setText( klocale->translate("Miles") );
   btngrpKmMiles->insert( mls );



   // OK- und Abbruch-Knopf
   int abstand = (width()-(2*BTNLENGTH))/3;
   ok = new QPushButton( this );
   ok->setText( klocale->translate("&Ok") );
   ok->setGeometry(abstand, height()-BTNHEIGHT-ABSTAND_UNTEN, BTNLENGTH, BTNHEIGHT);
   ok->setDefault( true );
   connect(ok, SIGNAL(clicked()), this, SLOT(slotOkPressed()));
   ok->setDefault(true);

   abort = new QPushButton( this );
   abort->setText( klocale->translate ("&Abort") );
   abort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-ABSTAND_UNTEN, BTNLENGTH, BTNHEIGHT);
   connect(abort, SIGNAL(clicked()), this, SLOT(reject()));
}


void DlgDX::setStandard()
{
   // Variablen besetzen
   act->setChecked( config->dxclusterspy );
   slotActToggled( config->dxclusterspy );

   // Ein QTH-Locator hier irgendwo in der Gegend von Muenster
   if (config->mypos == NULL)
      pos->setText("JO31UV");
   else
		pos->setText(config->mypos->m_getLocator().c_str());

	km->setChecked( config->distKM );
   mls->setChecked( !config->distKM );

   dxdata->setText( config->dxdata_file );
}


void DlgDX::slotOkPressed()
{
   KConfig *kconfig;



   kconfig = mykapp->getConfig();

   kconfig->setGroup( "DX-Cluster-Spy" );
   if (act->isChecked())
   {
      config->dxclusterspy = true;
      kconfig->writeEntry("active", "1");
   }
   else
   {
      config->dxclusterspy = false;
      kconfig->writeEntry("active", "0");
   }


   // Position abspeichern
   kconfig->writeEntry( "mypos", pos->text() );
   if (config->mypos == NULL)
      config->mypos = new Locator( pos->text() );
   else
      config->mypos->m_set( pos->text() );


   // dxc.dat - File
   // Nur, wenn der Text geaendert wurde
   if (strcmp(dxdata->text(), config->dxdata_file))
   {
      if (config->dxdata_file != NULL)
         free(config->dxdata_file);
      config->dxdata_file = (char *) strdup(dxdata->text());
      kconfig->writeEntry("dxdata_file", config->dxdata_file);
   }

	if (km->isChecked())
	{
		config->distKM = true;
		kconfig->writeEntry("distkm", "1");
	}
	else
	{
		config->distKM = false;
		kconfig->writeEntry("distkm", "0");
	}


   kconfig->sync();

   accept();
}


void DlgDX::slotActToggled( bool active )
{
   pos->setEnabled( active );
   dxdata->setEnabled( active );
   km->setEnabled( active );
   mls->setEnabled( active );
}


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////


DlgQSOSpy::DlgQSOSpy() : QTabDialog( 0, "", true)
{
   setCaption(klocale->translate("MonKT: QSO-Spy"));

   setupWindowGeneral();
   addTab(winGeneral, klocale->translate("&General"));

   setupWindowSpy();
   addTab(winSpy, klocale->translate("&Spy"));

   setupWindowIgnore();
   addTab(winIgnore, klocale->translate("&Ignore"));

   setStandard();
   setFixedSize( 270, 280);

   setCancelButton();
   connect( this, SIGNAL(applyButtonPressed()), SLOT(slotOkPressed()));
}


DlgQSOSpy::~DlgQSOSpy()
{
   delete act;

   delete winGeneral;
   delete winSpy;
}


void DlgQSOSpy::setupWindowGeneral()
{
   winGeneral = new QWidget( this );

   act = new QCheckBox( winGeneral );
   act->setText(klocale->translate("activate qso-spy?"));
   act->setGeometry( 20, 50, 300, 20 );
   connect( act, SIGNAL(toggled(bool)), this, SLOT(slotEnabled(bool)) );
}


void DlgQSOSpy::setupWindowSpy()
{
   winSpy = new QWidget( this );


   QButtonGroup *buttongroup = new QButtonGroup( winSpy );
   buttongroup->setGeometry( 10, 10, 230, 160 );
   buttongroup->setFrameStyle( QButtonGroup::NoFrame );

   spyAll = new QRadioButton( buttongroup );
   spyAll->setText( klocale->translate("spy everything"));
   spyAll->setGeometry( 10, 10, 200, 20 );
   buttongroup->insert( spyAll );

   spyNothing = new QRadioButton( buttongroup );
   spyNothing->setText( klocale->translate("spy nothing"));
   spyNothing->setGeometry( 10, 30, 200, 20 );
   buttongroup->insert( spyNothing );

   spyFollow = new QRadioButton( buttongroup );
   spyFollow->setText( klocale->translate("spy the following calls:"));
   spyFollow->setGeometry( 10, 50, 200, 20 );
   buttongroup->insert( spyFollow );
   connect( spyFollow, SIGNAL(toggled(bool)), this, SLOT(slotSpyFollow(bool)) );

   spy = new QMultiLineEdit( buttongroup );
   spy->setGeometry( 30, 70, 190, 100 );
}


void DlgQSOSpy::setupWindowIgnore()
{
   winIgnore = new QWidget( this );


   QButtonGroup *buttongroup = new QButtonGroup( winIgnore );
   buttongroup->setGeometry( 10, 10, 230, 160 );
   buttongroup->setFrameStyle( QButtonGroup::NoFrame );

   ignAll = new QRadioButton( buttongroup );
   ignAll->setText( klocale->translate("ignore everything"));
   ignAll->setGeometry( 10, 10, 200, 20 );
   buttongroup->insert( ignAll );

   ignNothing = new QRadioButton( buttongroup );
   ignNothing->setText( klocale->translate("ignore nothing"));
   ignNothing->setGeometry( 10, 30, 200, 20 );
   buttongroup->insert( ignNothing );

   ignFollow = new QRadioButton( buttongroup );
   ignFollow->setText( klocale->translate("ignore the following calls:"));
   ignFollow->setGeometry( 10, 50, 200, 20 );
   buttongroup->insert( ignFollow );
   connect( ignFollow, SIGNAL(toggled(bool)), this, SLOT(slotIgnoreFollow(bool)) );

   ignore = new QMultiLineEdit( buttongroup );
   ignore->setGeometry( 30, 70, 190, 100 );
}


void DlgQSOSpy::setStandard()
{
   char *tmp;


   act->setChecked( config->qsospy );

   switch (config->spywhat)
   {
      case SPY_EVERYTHING:
           spyAll->setChecked( true );
           break;
      case SPY_NOTHING:
           spyNothing->setChecked( true );
           break;
      case SPY_FOLLOWING:
           spyFollow->setChecked( true );
           break;
   }

   switch (config->ignorewhat)
   {
      case SPY_EVERYTHING:
           ignAll->setChecked( true );
           break;
      case SPY_NOTHING:
           ignNothing->setChecked( true );
           break;
      case SPY_FOLLOWING:
           ignFollow->setChecked( true );
           break;
   }


   if ((tmp = config->spy->first()) == NULL) return;
   do
   {
      spy->insertLine( tmp );
   }
   while ((tmp = config->spy->next()) != NULL);


   if ((tmp = config->ignore->first()) == NULL) return;
   do
   {
      ignore->insertLine( tmp );
   }
   while ((tmp = config->ignore->next()) != NULL);
}


void DlgQSOSpy::slotOkPressed()
{
   KConfig *kconfig;
   char str[1000], *str2;
   int i;


   kconfig = mykapp->getConfig();

   kconfig->setGroup( "QSO-Spy" );

   if (act->isChecked())
   {
      config->qsospy = true;
      kconfig->writeEntry("active", "1");
   }
   else
   {
      config->qsospy = false;
      kconfig->writeEntry("active", "0");
   }

   if (spyAll->isChecked())
   {
      kconfig->writeEntry("spyWhat", "1");
      config->spywhat = SPY_EVERYTHING;
   }
   if (spyNothing->isChecked())
   {
      kconfig->writeEntry("spyWhat", "2");
      config->spywhat = SPY_NOTHING;
   }
   if (spyFollow->isChecked())
   {
      kconfig->writeEntry("spyWhat", "3");
      config->spywhat = SPY_FOLLOWING;
   }

   if (ignAll->isChecked())
   {
      kconfig->writeEntry("ignoreWhat", "1");
      config->ignorewhat = SPY_EVERYTHING;
   }
   if (ignNothing->isChecked())
   {
      kconfig->writeEntry("ignoreWhat", "2");
      config->ignorewhat = SPY_NOTHING;
   }
   if (ignFollow->isChecked())
   {
      kconfig->writeEntry("ignoreWhat", "3");
      config->ignorewhat = SPY_FOLLOWING;
   }


   config->spy->clear();
   str[0] = '\0';
   for (i=0; i<spy->numLines(); i++)
   {
      str2 = (char *) strdup(spy->textLine(i));
      Gross(str2);
      if (str2[0] != '\0')
      {
         if (str[0] == '\0')
            strcpy( str, str2 );
         else
            sprintf( str+strlen(str), ",%s", str2 );
         config->spy->append( str2 );
      }
      free(str2);
   }
   kconfig->writeEntry("spy", str);


   config->ignore->clear();
   str[0] = '\0';
   for (i=0; i<ignore->numLines(); i++)
   {
      str2 = (char *) strdup(ignore->textLine(i));
      Gross(str2);
      if (str2[0] != '\0')
      {
         if (str[0] == '\0')
            strcpy( str, str2 );
         else
            sprintf( str+strlen(str), ",%s", str2 );
         config->ignore->append( str2 );
      }
      free(str2);
   }
   kconfig->writeEntry("ignore", str);

   kconfig->sync();

   accept();
}


void DlgQSOSpy::slotSpyFollow( bool toggled )
{
   spy->setEnabled( toggled );
}


void DlgQSOSpy::slotEnabled( bool toggled )
{
   spyAll->setEnabled( toggled );
   spyNothing->setEnabled( toggled );
   spyFollow->setEnabled( toggled );
   if (spyFollow->isChecked())
      spy->setEnabled( toggled );
   else
      spy->setEnabled( false );

   ignAll->setEnabled( toggled );
   ignNothing->setEnabled( toggled );
   ignFollow->setEnabled( toggled );
   if (ignFollow->isChecked())
      ignore->setEnabled( toggled );
   else
      ignore->setEnabled( false );
}


void DlgQSOSpy::slotIgnoreFollow( bool toggled )
{
   ignore->setEnabled( toggled );
}


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////





#include "preferences.moc"

