#include "toplevel.h"

#include <qpushbutton.h>
#include "themepage.h"
#include "intropage.h"
#include "linkpage.h"
#include "drivepage.h"
#include "printerpage.h"
#include "kwm.h"

#include <klocale.h>

TopLevel::TopLevel()
{
  setCaption(i18n("The KDE Setup Wizard"));

  _add(i18n("Introduction"), (new IntroPage(this))->widget());
  _add(i18n("Theme selection"), new ThemePage(this));
  _add(i18n("Drive configuration"), new DrivePage(this));
  _add(i18n("Printer integration"), new PrinterPage(this));
  _add(i18n("Link creation"), new LinkPage(this));

  resize(690,530);
  move((kapp->desktop()->width()-width()) / 2,
       (kapp->desktop()->height()-height()) /2);
  show();
}


void TopLevel::_add(QString title, QWidget *page)
{
  addPage(page, title);
  setFinishEnabled(page, true);
  if(title==i18n("Link creation"))
        {
        setNextEnabled ( page, false );
        }
  setHelpEnabled(page, false);
}
