/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __appletcontainer_h__
#define __appletcontainer_h__

#include <qframe.h>
#include <qpoint.h>

#include "global.h"

class QHBox;
class QXEmbed;
class QBoxLayout;

class PanelButton;
class InternalApplet;
class PanelAppletOpMenu;

class AppletContainer : public QFrame
{
  Q_OBJECT;

 public:
  AppletContainer(QWidget *parent=0);
  ~AppletContainer();

  virtual QCString objId() const=0;
  virtual QString command() const=0;

  float freeSpace() { return _fspace; }
  Position position() { return _pos; }
  Orientation orientation() { return _orient; }
  QString appletId() { return _aid; }

  QPoint moveOffset() { return _moveOffset; }

  virtual void setPosition(Position p) { _pos = p; }
  virtual void setOrientation(Orientation o) { _orient = o; }
  void setFreeSpace(float f) { _fspace = f; }
  void setAppletId(const QString& s) { _aid = s; }

  virtual int widthForHeight(int height) = 0;
  virtual int heightForWidth(int width) = 0;

  virtual QString configData() = 0;
  virtual QString appletType() = 0;

  QPoint getPopupPosition(QPopupMenu *menu, QPoint eventpos);

  virtual void configure() {}

 signals:
  void removeme(AppletContainer*);
  void moveme(AppletContainer*);
  void requestSave();

 protected:
  Position _pos;
  Orientation _orient;
  float _fspace;
  QPoint _moveOffset;
  QString _aid;
  PanelAppletOpMenu *_opMnu;
};

// base class for panel button containers
class ButtonContainer : public AppletContainer
{
  Q_OBJECT;
  
 public:
  ButtonContainer(QWidget* parent = 0);

  // not needed for buttons
  virtual QCString objId() const { return ""; }
  virtual QString command() const { return QString::null; }

  // buttons have a quadratic shape
  virtual int widthForHeight(int height) { return height; }
  virtual int heightForWidth(int width) { return width; } 

  virtual void setPosition(Position p);
  virtual void setOrientation(Orientation o);

  virtual QString configData();

  bool eventFilter (QObject *, QEvent *);

  void completeMoveOperation();

  virtual void configure();

 protected:
  void embedButton(PanelButton* p);

 protected:
  PanelButton *_button;
  QLayout *_layout;
  QPoint _oldpos;
};

// KMenuButton container
class KMenuButtonContainer : public ButtonContainer
{
 public:
  KMenuButtonContainer(QWidget* parent = 0);
  QString appletType() { return "KMenuButton"; }
};

// URLButton container
class URLButtonContainer : public ButtonContainer
{
 public:
  URLButtonContainer(const QString &url, QWidget* parent = 0);
  QString appletType() { return "URLButton"; }
};

// BrowserButton container
class BrowserButtonContainer : public ButtonContainer
{
 public:
  BrowserButtonContainer(const QString &startDir, QWidget* parent = 0);
  QString appletType() { return "BrowserButton"; }
};

// ExeButton container
class ExeButtonContainer : public ButtonContainer
{
 public:
  ExeButtonContainer(const QString &filePath, const QString &icon,
                 const QString &cmdLine, bool inTerm, QWidget *parent=0);
  ExeButtonContainer(const QString &configData, QWidget *parent=0);
  QString appletType() { return "ExeButton"; }
};

class AppletHandle : public QWidget
{
 public:
  AppletHandle(QWidget* parent = 0, const char* name = 0)
    : QWidget(parent, name)
    , _drawIt(false)
    , _fadeout_handle(false) {}

  void setOrientation(Orientation o) { _orient = o; }
  void setFadeOutHandle(bool);

 protected:
  void enterEvent(QEvent *);
  void leaveEvent(QEvent *);
  void paintEvent(QPaintEvent *);
  Orientation _orient;
  bool _drawIt;
  bool _fadeout_handle;
};

// base class for internal and external appllet containers
class AppletFrame : public AppletContainer
{
  Q_OBJECT;
  
 public:
  AppletFrame(QWidget* parent = 0);
  
  virtual QString command() const = 0;
  virtual QCString objId() const = 0;

  virtual int widthForHeight(int height) = 0;
  virtual int heightForWidth(int width) = 0;

  virtual int flags() { return _flags; }
  virtual int actions() { return _actions; }

  virtual void setPosition(Position p) = 0;
  virtual void setOrientation(Orientation o) = 0;

  bool eventFilter (QObject *, QEvent *);

  void resetLayout();

  virtual void configure();

 protected:
  AppletHandle *_handle;
  QHBox  *_appletframe;
  QBoxLayout *_layout;
  int _actions, _flags;
};

// container for external applets
class ExternalFrame : public AppletFrame
{
  Q_OBJECT;
  
 public:
  ExternalFrame(QCString application, QCString objId, QWidget* parent );
  ~ExternalFrame();
  
  QString command() const  { return _com; }
  QCString objId() const { return _obj; }
  WId window() const { return _win; }

  int widthForHeight(int height);
  int heightForWidth(int width);

  void setPosition(Position p);
  void setOrientation(Orientation o);

  QString configData();
  QString appletType() { return "ExternalApplet"; }

 signals:
  void embeddedWindowDestroyed();

 private:
  QXEmbed *_embed;
  QCString _app, _obj, _com;
  WId _win;
};

// container for internal applets
class InternalFrame : public AppletFrame
{
  Q_OBJECT;
  
 public:
  InternalFrame(const QString &aname, const QString &desktopFile, QWidget *parent);
  
  QString command() const { return _id; }
  QCString objId() const { return _id; }

  int widthForHeight(int height);
  int heightForWidth(int width);

  void setPosition(Position p);
  void setOrientation(Orientation o);

  QString configData() { return _deskFile; }
  QString appletType() { return "InternalApplet"; }

 signals:
  void sigUpdateLayout();

 protected slots:
  void slotActionsChanged();
  void slotFlagsChanged();

 private:
  QCString _id;
  QString _deskFile;
  InternalApplet *_applet;
};

#endif

