/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __CLOCK_H
#define __CLOCK_H

#include <qlcdnumber.h>
#include <qlabel.h>
#include <qtoolbutton.h>
#include <kdatepik.h>

#include "../../internalapplet.h"

class QTimer;
class QBoxLayout;

class DatePicker : public QFrame
{
public:
    DatePicker();
protected:
    void closeEvent(QCloseEvent *ev);
};

class Clock : public QLCDNumber
{
    Q_OBJECT
public:
    Clock(QWidget *parent=0, const char *name=0);
signals:
    void datePicker();
protected slots:
    void slotTimer();
protected:
    void mousePressEvent(QMouseEvent *ev);
    QTimer *timer;
    QString timeStr;
    bool blink;
    bool ampm;
};

class Date : public QLabel
{
    Q_OBJECT
public:
    Date(QWidget *parent=0, const char *name=0);
signals:
    void datePicker();
protected slots:
    void slotTimer();
protected:
    void mousePressEvent(QMouseEvent *ev);

    QString dateStr;
    QTimer *timer;
};

class ClockWidget : public InternalApplet
{
    Q_OBJECT
public:
    ClockWidget(QWidget *parent=0, const char *name=0);

    int widthForHeight(int h);
    int heightForWidth(int w);
protected slots:
    void slotDatePicker();
    void slotCalendarDeleted();
protected:
    void mousePressEvent(QMouseEvent *ev);
    void resizeEvent(QResizeEvent*);

    Clock *clock;
    Date *date;
    DatePicker *cal;
    QBoxLayout *layout;
};


#endif

