#include <qbutton.h>

#ifndef MINIBUTTON_H
#define MINIBUTTON_H

class KMiniPagerButton : public QButton
{
  Q_OBJECT
public:
    KMiniPagerButton(int desk, QWidget *parent=0, const char *name=0);
protected slots:
    void slotClicked();
signals:
    void deskChangeRequest(int desk);
    /**
     * Request to show a popup menu for window wid at position pos
     */
    void showPopupMenu(WId wid, QPoint pos);
protected:
    void paintEvent(QPaintEvent *ev);
    void mousePressEvent(QMouseEvent *ev);
    QString deskStr;
    int deskNum;
};

#endif
