/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __panelbutton_h__
#define __panelbutton_h__

#include "panelbuttonbase.h"
#include "global.h"
#include "menus.h"

class KPropertiesDialog;

class PanelButton: public PanelButtonBase
{
  Q_OBJECT;

 public:
  PanelButton(QWidget * parent, const char *name = 0);

  // used for menu popup
  void setPosition(Position p);
  void setOrientation(Orientation o){orient = o;}

  Position position(){return(pos);}
  Orientation orientation(){return(orient);}

  QPoint getPopupPosition(QPopupMenu *menu);

  // used for configuration
  virtual QString configData() = 0;

  virtual void properties()=0;
  virtual void configure();

 signals:
  void requestSave();

 protected:

  Position pos;
  Orientation orient;
};

/**
 * Simple URL button (applnks, files, whatever)
 */
class PanelURLButton : public PanelButton
{
  Q_OBJECT;

 public:
  PanelURLButton(const QString &url, QWidget *parent=0,
                 const char *name=0);

  virtual QString configData() { return urlStr; }

  virtual void properties();
  virtual void configure();

 protected slots:
  void slotExec();
  void updateURL();

 protected:
 virtual void dropEvent(QDropEvent *ev);
 virtual void dragEnterEvent(QDragEnterEvent *ev);
 virtual void resizeEvent(QResizeEvent*);

 QString urlStr;
 KPropertiesDialog *pDlg;
 bool local;
};

/**
 * Button that contains a Browser directory menu
 */
class PanelBrowserButton : public PanelButton
{
  Q_OBJECT;

 public:
  PanelBrowserButton(const QString &startDir, QWidget *parent=0,
                     const char *name=0);
  ~PanelBrowserButton(){;}

  QString configData() { return  topMenu->path(); }

 virtual void properties();
 virtual void configure();

 protected slots:
  void slotExecMenu();

 protected:
 virtual void resizeEvent(QResizeEvent*);

 PanelBrowserMenu *topMenu;
};

/**
 * Button that contains the PanelKMenu and client menu manager.
 */
class PanelKButton : public PanelButton
{
  Q_OBJECT;

 public:
  PanelKButton(QWidget *parent=0, const char *name=0);

  QString configData() { return QString::null; }

  virtual void properties();
  virtual void configure();

 protected slots:
  void slotExecMenu();
  void slotExecMenuAt(int x, int y);

 protected:
  virtual void resizeEvent(QResizeEvent*);

  PanelKMenu *topMenu;
  KickerMenuManager* menuMgr;
};

/**
 * Button that contains a non-KDE application
 */
class PanelExeButton : public PanelButton
{
  Q_OBJECT;

 public:
  PanelExeButton(const QString &filePath, const QString &icon,
                 const QString &cmdLine, bool inTerm, QWidget *parent=0,
                 const char *name=0);
  PanelExeButton(const QString &configData, QWidget *parent=0,
                 const char *name=0);

  QString configData();

  virtual void properties();
  virtual void configure();

 protected slots:
  void slotExec();

 protected:
 virtual void resizeEvent(QResizeEvent*);
 virtual void dropEvent(QDropEvent *ev);
 virtual void dragEnterEvent(QDragEnterEvent *ev);

 QString pathStr, iconStr, cmdStr;
 bool term;
};

#endif // __panelbutton_h__

