/* This file is part of the KDE libraries
   Copyright (C) 2000 Matej Koss <koss@miesto.sk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef __dlgprogress_h__
#define __dlgprogress_h__

#include <qlabel.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qdatetime.h>

#include <kprogress.h>

#include "bwdatetime.h"

class SearchList;
class Transfer;


class DlgIndividual : public QWidget {

  Q_OBJECT

public:
  DlgIndividual( Transfer *_item );
  ~DlgIndividual() {}

public slots:
  void setTotalSize( unsigned long bytes );
  void setTotalFiles( unsigned long files );
  void setTotalDirs( unsigned long  dirs );

  void setProcessedSize( unsigned long bytes );
  void setProcessedFiles( unsigned long files );
  void setProcessedDirs( unsigned long dirs );

  void setSpeed( unsigned long bytes_per_second, QTime remaining );
  void setPercent( unsigned long percent );

  void setCopying( const KURL& src, const KURL& dest );
  void setCanResume( bool );

protected slots:
  void slotToggleAdvanced( bool );

protected:
  QLabel* progressLabel;
  QLabel* sourceLabel;
  QLabel* destLabel;
  QLabel* speedLabel;
  QLabel* sizeLabel;
  QLabel* resumeLabel;

  KProgress* m_pProgressBar;

  QPushButton *pbAdvanced;
  QTabWidget *panelAdvanced;

  QDateTime qdt;
  BWDateTime *spins;

  // search stuff
  SearchList *listSearch;
  
  Transfer *item;

  QString m_sFilename;
  unsigned long m_iTotalSize;
  unsigned long m_iTotalFiles;
  unsigned long m_iTotalDirs;

  unsigned long m_iProcessedDirs;
  unsigned long m_iProcessedFiles;
};

#endif // __dlgprogress_h__
