/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <stdio.h>

#include <qbrush.h>
#include <qpainter.h>

#include <kapp.h>
#include <klocale.h>
#include <kstddirs.h>

#include "resultview.h"


ResultViewItem::ResultViewItem( QListView *parent, QString date,
				QString subject, QString url,
				QString forum, QString author )
    : QListViewItem(parent, date, subject, forum, author)
{
    m_url = url;
}

    
QString ResultViewItem::key(int col, bool ascending) const {
    static char strbuf[7];
    if (col == DateColumn) {
	QString date = text(DateColumn);
	if (date.length() != 8 || date[2] != '/' || date[5] != '/')
	    return "zzz";
	// month / day / year -> year,month,day
	date = date.right(2) + date.left(2) + date.mid(3, 2);
	return strcpy(strbuf, date.data());
    } else {
	return QListViewItem::key(col, ascending);
    }
}


ResultView::ResultView(QWidget *parent, const char *name)
    : QListView(parent, name)
{
    QFontMetrics fm(fontMetrics());
    addColumn(i18n("Date"), fm.width("99/99/1999")+5);
    addColumn(i18n("Subject"));
    addColumn(i18n("Forum"));
    addColumn(i18n("Author"));
    setAllColumnsShowFocus(true);
    setSorting(0, false);

    connect( this, SIGNAL(doubleClicked(QListViewItem*)),
	     SLOT(itemActivated(QListViewItem*)) );
}


void ResultView::insertItem(QString date, QString subject, QString url, 
			    QString forum, QString author) {
    (void) new ResultViewItem(this, date, subject, url, forum, author);
}


void ResultView::itemActivated(QListViewItem *item) {
    emit urlActivated(static_cast<ResultViewItem*>(item)->m_url);
}
