/*
* moncfg.h -- Declaration of class KMonitorCfg.
* Generated by newclass on Wed Jul 29 03:47:49 EST 1998.
*/
#ifndef SSK_MONCFG_H
#define SSK_MONCFG_H

#include<qobject.h>

class QWidget;
class KMailDrop;

/**
* Abstract superclass for all monitor configuration watchers.
*
* This class is used to add configuration pages to a maildrop
* configuration tab dialog. 
*
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: moncfg.h,v 1.1 1999/07/22 18:17:00 tibirna Exp $
*/
class KMonitorCfg : public QObject
{
	Q_OBJECT

private:
	KMailDrop *_drop;

public:
	/**
	* Constructor.
	*/
	KMonitorCfg( KMailDrop *drop );

	/**
	* KMonitorCfg Destructor
	*/
	virtual ~KMonitorCfg() {}

	/**
	* Returns a newly created configuration widget for a 
	* particular monitor type.
	* @param parent the widget which should be made the
	*		parent of the new widget.
	*/
	virtual QWidget *makeWidget( QWidget *parent ) = 0;

	/**
	* Should return a user-friendly name for the configuration
	* page. This will be used as the title of the tab dialog page.
	*/
	virtual const QString name() const = 0;

	/**
	* This will be called if the user has instructed the dialog
	* to update the configuration for the object associated with
	* this page.
	*/
	virtual void updateConfig() = 0;

signals:
	/**
	* Raised when the associated maildrop has raised
	* @ref KMaildrop::notifyDisconnect
	*/
	void dropDead( KMonitorCfg * );

protected:
	KMailDrop *drop() { return _drop; }
        QString monitorName;

private:
	KMonitorCfg& operator=( KMonitorCfg& );
	KMonitorCfg( const KMonitorCfg& );
	KMonitorCfg();

private slots :

	/**
	* Raises @ref ::dropDead when the associated monitor dies.
	*/
	void monitorDead() { emit dropDead( this ); }
};

#endif // SSK_MONCFG_H
