/*
* unixcfg.cpp -- Implementation of class KUnixCfg.
* Author:	Sirtaj Singh Kang
* Version:	$Id: unixcfg.cpp,v 1.1 1999/07/22 18:17:10 tibirna Exp $
* Generated:	Mon Aug  3 02:08:36 EST 1998
*/

#include <assert.h>
#include <qlined.h>
#include <qlabel.h>
#include <qlayout.h>

#include <kglobal.h>
#include <klocale.h>

#include "unixdrop.h"
#include "unixcfg.h"
//#include "typolayout.h"
#include "kfbrowsebtn.h"

KUnixCfg::KUnixCfg( KUnixDrop *drop ) 
	: KMonitorCfg( drop ),
	_fileEdit( 0 ) 
{
}

const QString KUnixCfg::name() const
{
	return i18n( "Mailbox" );
}

QWidget *KUnixCfg::makeWidget( QWidget *parent )
{
	KUnixDrop *d = (KUnixDrop *) drop();

	// layout

	QWidget *dlg = new QWidget( parent );
	QGridLayout *layout = new QGridLayout( dlg, 4, 2, 10 );
	layout->addRowSpacing(0, 10);
	layout->addRowSpacing(3, 10);

	// edit
	layout->addWidget(new QLabel( i18n( "Mbox Path" ), dlg ), 1, 0);

	_fileEdit = new QLineEdit( d->file(), dlg );
	layout->addWidget( _fileEdit, 1, 1);

	// browse button

	KFileBrowseButton *bt = new KFileBrowseButton( 0, d->file(), dlg, 0, true );
	connect( bt, SIGNAL(pathChanged(const QString &)),
		_fileEdit, SLOT(setText(const QString &)) );
	
	layout->addWidget( bt, 2, 1);

	return dlg;
}

void KUnixCfg::updateConfig()
{
	assert( _fileEdit != 0 );
	KUnixDrop *d = (KUnixDrop *) drop();
	
	d->setFile( _fileEdit->text() );
}

