/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _NEWSSEARCH_H_
#define _NEWSSEARCH_H_


#include "searchjob.h"
#include "site.h"


class NewsSite : public Site {

public:
  NewsSite() : Site() {}

  QString dateStart;
  QString dateEnd;
  QString subjectStart;
  QString subjectEnd;
  QString forumStart;
  QString forumEnd;
  QString authorStart;
  QString authorEnd;
};


class NewsSiteManager : public SiteManager {

public:
  NewsSiteManager();

protected:

  virtual Site *newSite() {
    return new NewsSite();
  }

  virtual void readInterpret(Site *site, SiteConfig *config);
};


class NewsSearch : public SearchJob {

  Q_OBJECT

public:
  NewsSearch(NewsSite *site) : SearchJob(site) {}

signals:
  void foundItem(QString date, QString subject, QString url,
		 QString forum, QString details);
  
protected:
  virtual void parseItem(QString item);
  NewsSite *site() {
    return static_cast<NewsSite*>(m_site);
  }
};

 
#endif 
