/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qlabel.h>
#include <qlayout.h>

#include <klocale.h>

#include "driver.h"
#include "geninfobox.h"


GeneralInfoBox::GeneralInfoBox(Device *device, QWidget *parent, 
                               const char *name) : QWidget(parent, name)
{
  QString  typestr, vendorstr;
  
  typestr   = device->deviceBaseClassName();
  vendorstr = device->vendorName();

  QLabel  *typelabel   = new QLabel(i18n("Device type:"),  this, "typelabel");
  QLabel  *typevalue   = new QLabel(typestr,               this, "typevalue");
  QLabel  *vendorlabel = new QLabel(i18n("Manufacturer:"), this, "vendorlabel");
  QLabel  *vendorvalue = new QLabel(vendorstr,             this, "vendorvalue");

  QHBoxLayout  *toplayout  = new QHBoxLayout(this, -1, -1, "toplayout");
  QGridLayout  *gridlayout = new QGridLayout(toplayout, 3, 3);
  
  gridlayout->addColSpacing(1, 8);
  gridlayout->addRowSpacing(1, 4);
  
  gridlayout->addWidget(typelabel,   0, 0);
  gridlayout->addWidget(typevalue,   0, 2);
  gridlayout->addWidget(vendorlabel, 2, 0);
  gridlayout->addWidget(vendorvalue, 2, 2);
  
  toplayout->addStretch(1);
  toplayout->activate();
}

