/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include "scsidevice.h"


SCSIDevice::SCSIDevice(const QString& vendorname, const QString& modelname, 
		       const QString& typestr, uint channel, 
		       uint id, uint lun, uint firm) : _vendorname(vendorname),
		       			               _modelname(modelname),
					               _typestr(typestr),
					               _channel(channel),
					               _id(id),
					               _lun(lun),
					               _firm(firm)
{
  lookupData();
}


/*
 * Public methods
 *****************/
 
QString  SCSIDevice::deviceClassName()
{ 
  switch (_class)
  {
    case SCSIClassDirectAccess     : return QString(i18n("Direct access device"));
    case SCSIClassSequentialAccess : return QString(i18n("Sequential access device"));
    case SCSIClassPrinter          : return QString(i18n("Printer"));
    case SCSIClassProcessor        : return QString(i18n("Processor"));
    case SCSIClassWORM             : return QString(i18n("WORM"));
    case SCSIClassCDROM            : return QString(i18n("CD-ROM drive"));
    case SCSIClassScanner          : return QString(i18n("Scanner"));
    case SCSIClassOptical          : return QString(i18n("Optical device"));
    case SCSIClassMediumChanger    : return QString(i18n("Medium changer"));
    case SCSIClassCommunications   : return QString(i18n("Communication device"));
    case SCSIClassEnclosure        : return QString(i18n("Enclosure"));
    default                        : return QString(i18n("Unknown device"));
  }
}


Device::devstate  SCSIDevice::deviceState()
{
  return DeviceStateReady;
}


/*
 * Private methods
 ******************/
 
void   SCSIDevice::lookupData()
{
  uint  type;
  char  typelist[][32] = { "Direct-Access", "Sequential-Access", "Printer", "Processor",
                           "WORM", "CD-ROM", "Scanner", "Optical Device", "Medium Changer",
                           "Communications", "Unknown", "Enclosure", "" };
			 
  for (type = 0; strlen(typelist[type]); type++)
    if (_typestr == typelist[type]) break;
    
  if (strlen(typelist[type]))
  {
    switch (type)
    {
      case 0  : _baseclass = BaseClassMassStorage;
      		_class     = SCSIClassDirectAccess;
      		break;
      case 1  : _baseclass = BaseClassMassStorage;
                _class     = SCSIClassSequentialAccess;
      		break;
      case 2  : _baseclass = BaseClassPrinter;
      		_class     = SCSIClassPrinter;
      		break;
      case 3  : _baseclass = BaseClassProcessor;
      		_class     = SCSIClassProcessor;
      		break;
      case 4  : _baseclass = BaseClassWORM;
      		_class     = SCSIClassWORM;
      		break;
      case 5  : _baseclass = BaseClassCDROM;
      		_class     = SCSIClassCDROM;
      		break;
      case 6  : _baseclass = BaseClassScanner;
      		_class     = SCSIClassScanner;
      		break;
      case 7  : _baseclass = BaseClassMassStorage;
      		_class     = SCSIClassOptical;
      		break;
      case 8  : _baseclass = BaseClassMassStorage;
      		_class     = SCSIClassMediumChanger;
      		break;
      case 9  : _baseclass = BaseClassCommunication;
      		_class     = SCSIClassCommunications;
      		break;
      case 10 : _baseclass = BaseClassNone;
      		_class     = SCSIClassUnknown;
      		break;
      case 11 : _baseclass = BaseClassEnclosure;
                _class     = SCSIClassEnclosure;
      		break;
      default : _baseclass = BaseClassNone;
      		_class     = SCSIClassUnknown;
    }
  }
}

 
 
