/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __SCSIDEVICE_H
#define __SCSIDEVICE_H

#include <qstring.h>

#include "device.h"


class SCSIDevice : public Device
{
  public:
  
    enum scsiclass { SCSIClassDirectAccess,
    	             SCSIClassSequentialAccess,
    	             SCSIClassPrinter,
    	             SCSIClassProcessor,
    	             SCSIClassWORM,
    	             SCSIClassCDROM,
    	             SCSIClassScanner,
    	             SCSIClassOptical,
    	             SCSIClassMediumChanger,
    	             SCSIClassCommunications,
    	             SCSIClassUnknown,
    	             SCSIClassEnclosure };
  
    SCSIDevice(const QString& vendorname, const QString& modelname, 
               const QString& typestr, uint channel, uint id, uint lun, uint firm);
	       
    ~SCSIDevice() {}
    
    virtual bustype   busType()          const { return BusSCSI; }
    
    virtual QString   deviceClassName();
    virtual QString   deviceName()             { return _vendorname+' '+_modelname; }
    virtual devstate  deviceState();
    virtual QString   vendorName()             { return _vendorname;		    }

            uint      targetID()         const { return _id;			    }
	    uint      logicalUnit()      const { return _lun;			    }
	    uint      firmwareRevision() const { return _firm;                      }

  private:
  
    QString    _vendorname, _modelname;
    QString    _typestr;
    scsiclass  _class;
    uint       _channel, _id, _lun, _firm;
    
    void  lookupData();
};


#endif

