/***************************************************************************
                          IOCore.cpp  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-2000 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/
#pragma implementation

#include <cerrno>

extern "C" {
#include <unistd.h>
}

#include <qfileinfo.h>
#include <qlist.h>

#include <kdebug.h>
#include <kapp.h>
#include <klocale.h>

#include "Data.h"
#include "IOCore.h"
#include "ksv_core.h"
#include "ksv_conf.h"

QString IOCore::relToAbs( QString dir, QString rel )
{
  QString _abs;

  if (rel.left(1) != "/")
    _abs = QDir::cleanDirPath( (dir + "/").data() + rel);
  else
    _abs = QDir::cleanDirPath( rel );
  return _abs;
}

QString IOCore::removeFile( const QFileInfo* info, QDir dir )
{
  if (!dir.remove(info->fileName(), FALSE))
    return QString("<error>FAILED</error> to remove <cmd>%1</cmd> from <cmd>%2</cmd>: \"%3\"<br/>")
      .arg(info->fileName())
      .arg(dir.path())
      .arg(strerror(errno));
  else
    return QString(i18n("removed <cmd>%1</cmd> from <cmd>%2</cmd><br/>")
		   .arg(info->fileName())
		   .arg(dir.path()));
}

void IOCore::dissectFilename( QString _file, QString& _base, int& _nr ) {
  QString tmp = _file.mid(1, _file.length());

  _nr = tmp.left(2).toInt();
  _base = tmp.mid(2, tmp.length());
}

QString IOCore::makeSymlink (const KSVData& data, int runlevel, bool start)
{
  kdDebug() << "Making symlink" <<endl;
  const QString symName = QString("%1%2%3").arg(start ? "S" : "K").arg(data.number(), 2).arg(data.label());
// 			data.number(),
// 			data.label().data());
  
  const QString symPath = QString("%1/rc%2.d/").arg(KSVConfig::self()->runlevelPath()).arg(runlevel);
  //			runlevel);

  const QString symbol = symPath + symName;
  QString target = data.filename();
  
  if (QDir::isRelativePath(target))
    target = IOCore::makeRelativePath(QDir::cleanDirPath(symPath),
				      QDir::cleanDirPath(data.path())) + data.filename();

  if (symlink(target.data(), symbol.data()) == 0)
    return i18n("created <cmd>%1</cmd> in <cmd>%2</cmd><br/>").arg(symName).arg(symPath);
  else
    return i18n("<font color=\"red\">FAILED</font> to create <cmd>%1</cmd> in <cmd>%2</cmd>: \"%3\"\n").arg(symName).arg(symPath).arg(strerror(errno));
// 			     symName.data(),
// 			     symPath.data(),
// 			     strerror(errno));
}

bool IOCore::copyFile (QString file1, QString file2)
{
  QFile f1 (file1);
  QFile f2 (file2);

  f1.open(IO_ReadOnly);
  f2.open(IO_WriteOnly | IO_Truncate);

  int nrOfBytes;
  char buffer[1024];

  while ((nrOfBytes = f1.readBlock(buffer, 1024)))
    {
      if (f2.writeBlock(buffer, nrOfBytes) == -1)
	{
	  f1.close();
	  f2.close();
	  
	  return false;
	}
    }

  f1.close();
  f2.close();

  return true;
}

QString IOCore::makeRelativePath (QString from, QString to)
{
  if (QDir::isRelativePath(from) || QDir::isRelativePath(to))
    return QString();

  int pos = 0;
  const int f_length = from.length();

  QList<QString> from_list;
  from_list.setAutoDelete(true);

  while (pos > -1)
    {
      const int old = pos + 1;
      const int res = from.find('/', old);

      int length = 0;

      if (res > -1)
	length = res - old + 1;
      else
	length = f_length - old;
      
      from_list.append( new QString(from.mid(old, length)));

      pos = res;
    }

  const int t_length = to.length();
  
  QList<QString> to_list;
  to_list.setAutoDelete(true);
  pos = 0;

  while (pos > -1)
    {
      const int old = pos + 1;
      const int res = to.find('/', old);
      
      int length = 0;
      
      if (res > -1)
	length = res - old + 1;
      else
	length = t_length - old;
      
      to_list.append( new QString(to.mid(old, length)));

      pos = res;
    }

  int lcp = 0; // longest common prefix
  const int f_c = from_list.count();
  const int t_c = to_list.count();

  while (lcp < f_c && lcp < t_c
	 && *from_list.at(lcp) == *to_list.at(lcp))
    lcp++;

  QString result;
  for (int i = f_c - lcp; i > 0; --i)
    result += "../";

  for (int i = lcp; i < t_c; ++i)
    result += *to_list.at(i) + "/";
  
  return result;
}

