/***************************************************************************
                          kservice.cpp  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1999 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#pragma implementation

#include <kservice.h>
#include "leveldb.h"

KService::KService (QString name, QString basedir)
  : name_ (name),
    base_ (basedir)
{

}

KService* KService::newService (QString name, QString basedir)
{
  struct service service;

  int result = ::readServiceInfo (basedir, name, &service );

  if (!result)
    {
      KService* tmp = new KService(name, basedir);
      tmp->desc_ = service.desc;
      tmp->levels = service.levels;
      tmp->kPriority = service.kPriority;
      tmp->sPriority = service.sPriority;

      return tmp;
    } 
  else
    {
      return 0L;
    }
}

KService::~KService()
{
}

bool KService::isOn (int level) const
{
  return !::isOn (base_, name_, level );
}

bool KService::isConfigured (int level) const
{
  return !::isConfigured (base_, name_, level);
}

int KService::set (int level, bool on)
{
  struct service service;
  service.name = (char*) name_.data();
  service.desc = (char*) desc_.data();
  service.levels = levels;
  service.kPriority = kPriority;
  service.sPriority = sPriority;

  return ::doSetService ("/etc/rc.d", service, level, on);
}

QString KService::description () const
{
  return desc_.stripWhiteSpace();
}
