/***************************************************************************
                          ksv_core.h  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#ifndef KSV_CORE_H
#define KSV_CORE_H

#pragma interface

class QPushButton;
class QStyleSheet;

class KAboutData;

class KSVItem;

class KSVCore
{
  /** 
   * static members (utility functions)
   */
public:
    
  /**
   * Sets a QPushbutton to a good size
   */
  static void goodSize (QPushButton* button);

  static bool getServiceDescription (const QString& path, QString& res);

  static QString breakWords (const QString& s, int amount);

  static inline KAboutData* about() { return mAbout; }
  static inline void setAbout (KAboutData* data) { mAbout = data; }

  /**
   * \return the Unicode string for the (c) symbol.
   */
  static const QString& copyrightSymbol ();

  /**
   * \return the hostname (or "Unknown Host")
   */
  static QString hostname ();

  static QStyleSheet* styleSheet ();

private:
  static KAboutData* mAbout;
};

#endif
