// MailValidator: Control behavior of QLineEdit requesting e-mail address

#include "MailValidator.moc"
#include <ctype.h>
#include <qstring.h>

MailValidator::MailValidator(QLineEdit *parent, const char * name):QValidator(parent,name)
{
}
MailValidator::~MailValidator()
{
}
QValidator::State MailValidator::validate(QString &input, int &) const
{
	char c;
	for(unsigned int i=0;i<strlen(input);i++) {
		c=input.mid(i,1).latin1()[0];
		if(!isalnum(c) && c!='@' && c!='.' && c!='_' && c!='+' && c!='-')
			return QValidator::Invalid;
	}
	if(input.find('@')!=input.findRev('@'))
		return QValidator::Invalid;
	if(input.mid(strlen(input)-1,1)=='@')
		return QValidator::Acceptable;
	return QValidator::Valid;
}
void MailValidator::fixup(QString &)
{
	// Not yet implemented...
}
