/*
*
* minicli.h
* Copyright (C) 1997 Matthias Ettrich <ettrich@kde.org>
* copyright (C) 1997 Torben Weis [ Added command completion ]
* Copyright (C) 1999 Preston Brown <pbrown@kde.org>
*
* Complete re-write:
* Copyright (C) 1999 - 2000 Dawit Alemayehu <adawit@kde.org>
* Copyright (C) 2000 Malte Starostik <starosti@zedat.fu-berlin.de>
*
* Kdesu integration:
* Copyright (C) 2000 Geert Jansen <jansen@kde.org>
*/

#ifndef MINICLI_H
#define MINICLI_H

#include <qstring.h>
#include <qstringlist.h>
#include <qdialog.h>
#include <qgroupbox.h>
#include <kurifilter.h>

class KLineEdit;
class KComboBox;
class KCompletion;
class QSlider;
class QLabel;
class QCheckBox;
class MinicliAdvanced;
class KPasswordEdit;

class Minicli : public QDialog
{
    Q_OBJECT

public:
    Minicli( QWidget *parent=0, const char *name=0 );
    virtual ~Minicli();
    void reset();

public slots:
    bool setCWD( const QString& );

protected:
    void loadConfig();
    void saveConfig();
    void loadStandardGUI();
    void loadTraditionalGUI(){};
    void keyPressEvent( QKeyEvent * );

protected slots:
    virtual void accept();
    virtual void reject();

private slots:
    void slotCmdChanged( const QString& );
    void slotParseTimer();
    void slotAdvanced();
    int run_command();

private:
    QLabel *m_runIcon;
    QCheckBox* m_terminalBox;
    QPushButton *mpAdvButton;
    QTimer* m_parseTimer;
    QString m_strCWD, m_IconName;
    QStringList m_History;

    bool mbAdvanced;
    MinicliAdvanced *mpAdvanced;
    uint m_iMaxHistory;
    KComboBox* m_runCombo;
    KCompletion* m_pCompletion;
};

class MinicliAdvanced : public QGroupBox
{
    Q_OBJECT;

public:
    MinicliAdvanced(QWidget *parent=0L, const char *name=0L);
    ~MinicliAdvanced();

    bool terminal() { return mbTerminal; }
    bool changeUid() { return mbChangeUid; }
    QString username() { return mUsername; }
    bool changeScheduler() { return mbChangeScheduler; }
    int priority() { return mPriority; }
    int scheduler() { return mScheduler; }
    const char *password();

    bool needsKDEsu();
    void reset();

private slots:
    void slotTerminal(bool);
    void slotChangeUid(bool);
    void slotChangeScheduler(bool);
    void slotScheduler(int);
    void slotPriority(int);
    void slotUsername(const QString &);

private:
    void updateAuthLabel();

    bool mbTerminal, mbChangeUid, mbChangeScheduler;
    int mScheduler, mPriority;

    QSlider *mpSlider;
    QCheckBox *mpCBTerm, *mpCBUser, *mpCBPrio;
    QLabel *mpAuthLabel;
    QString mUsername;
    KLineEdit *mpEdit;
    KComboBox *mpCombo;
    KPasswordEdit *mpPassword;
};

#endif
