#include "desktopicon.h"
#include <kapp.h>
#include <kwm.h>
#include <kdebug.h>
#include <qpainter.h>
#include <qpixmap.h>

#define SCR2PAGER(x) x*width()/kapp->desktop()->width()
#define PAGER2SCR(x) x*kapp->desktop()->width()/width()                                             

KPagerDesktop::WindowData *KPagerDesktopIcon::winData(WId id, WindowData * /*wd*/)
{
  WindowDataIcon *w=new WindowDataIcon;
  KPagerDesktop::winData(id,w);
  w->icon=new QPixmap(KWM::icon(id));
  return w;
}
    
KPagerDesktopIcon::KPagerDesktopIcon(int desk, class KWinModule *kwinmod, QWidget *parent)
   : KPagerDesktop(desk,kwinmod,parent)
{
}

QPixmap *KPagerDesktopIcon::paintWindow(const WindowData *wdd, QPoint *pos)
{
  QWMatrix matrix;
  QPixmap *window=KPagerDesktop::paintWindow(wdd,pos);
  if ( window->isNull() )
  {
    kdError() << "Null Pixmap" << endl;
    return window;
  }

  WindowDataIcon *wd=(WindowDataIcon *)wdd;
  if ( !wd->icon ) 
  {
    kdError() << "No Icon available" << endl;
    return window; 
  }

  // We first scale the icon
  double rx=(double)window->width()/wd->icon->width();
  double ry=(double)window->height()/wd->icon->height();
  rx=( rx < ry ) ? rx : ry;
  matrix.scale(rx,rx);
  QPixmap *tmpicon=new QPixmap(wd->icon->xForm(matrix));

  // Now we paint the reduced icon over the normal window
  QPainter paint;
  paint.begin(window);
  paint.drawPixmap((window->width()-tmpicon->width())/2,
     		      (window->height()-tmpicon->height())/2, *tmpicon);
  paint.end();

  delete tmpicon;

  return window;
}

