/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __panel_h__
#define __panel_h__

#include <qwidget.h>
#include <dcopobject.h>

#include "global.h"

class QBoxLayout;
class QPopupMenu;
class QVBox;
class QTimer;
class AppletArea;
class PanelOpMenu;
class HideButton;

class Panel : public QWidget, virtual public DCOPObject
{
  Q_OBJECT;
  K_DCOP;
  
 public:
  Panel();
  ~Panel();
  
  Orientation orientation() const {  return isHorizontal()?Horizontal:Vertical; }
  Position position() const { return _pos; }
  void setPosition(Position p);
  Size size() const { return _size; }
  void setSize(Size s);

  int panelSize() const { return _panelsize; }
  
  AppletArea *appletArea() { return(_appletArea); }
  
  bool eventFilter( QObject *, QEvent * );

  void writeConfig();
  void configure();

 signals:
  /**
   * Emitted to inform the appletarea, which doesn't have a notion about 
   * positions.
   */
  void orientationChanged(Orientation);  
  /**
   * Emitted to inform the applets. They can determine the orientation from the
   * position.
   */
  void positionChanged(Position);
  
 protected:
  bool isHorizontal() const { return _pos == Top || _pos == Bottom; }
  bool isVertical() const { return _pos == Left || _pos == Right; }
  void blockUserInput( bool block );
  void resetLayout();
  void closeEvent( QCloseEvent * );
  void updateWindowManager();
  void moveMe();
  void resetAutoHideTimer();
  void autoHide(bool hide);
  QRect initialGeometry();

  QPoint getPopupPosition(QPopupMenu *menu);
  
 protected slots:
  void hideLeft();
  void hideRight();
  void autoHideTimeout();
  void slotRestart();
 
 private:

  void animatedHide(bool left);

  Size _size;
  Position _pos;
  bool _showHBs;
  int _HBwidth;
  int _panelsize;
  bool _autoHide;
  bool _autoHidden;
  bool _userHidden;
  bool _hideAnim, _autoHideAnim;
  int _autoHideDelay;
  int _hideAnimSpeed, _autoHideAnimSpeed;

  bool _block_user_input;
  QPoint _last_lmb_press;

  QVBox      *_appletAreaBox;
  QBoxLayout *_layout;
  QTimer     *_autohideTimer;
  HideButton *_ltHB;
  HideButton *_rbHB;

  AppletArea *_appletArea;
  PanelOpMenu *_opMnu;
};

#endif // __panel_h__
