/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// QT includes
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>

// KDE includes
#include <klocale.h>
#include <kapp.h>
#include <kconfig.h>

// own includes
#include "optionsdlg.h"
#include "defines.h"

OptionsDlg::OptionsDlg(QWidget* parent, const char* name) : QDialog(parent, name, true)
{
 resize(500, 400);

 const int labelPos = 10;
 const int widgetPos = 300;
 int y = 0;

 QPushButton* ok = new QPushButton(i18n("OK"), this);
 //ok->move(this->width() /2 - ok->width() - 20, 350);
 ok->move(this->width() /4 - ok->width() /2, 350);
 ok->setDefault(true);
 connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
 
 QPushButton* cancel = new QPushButton(i18n("Cancel"), this);
 cancel->move(this->width() /2 + this->width() /4 - cancel->width() /2, 350);
 connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));

//TODO better read from game!
 KConfig* conf = kapp->config();
 conf->setGroup("General");
 conf->setGroup("Save");
 QString names[MAX_PLAYERS];
 names[0] = conf->readEntry("Name_0", i18n("You"));
 for (int i = 1; i < MAX_PLAYERS; i++) {
 	names[i] = conf->readEntry(QString("Name_%1").arg(i), i18n("Computer %1").arg(i));
 }


 y += 35;
 QLabel* player1NameLabel = new QLabel(i18n("Your Name"), this);
 player1NameLabel->adjustSize();
 player1NameLabel->move(labelPos, y);

 player1Name = new QLineEdit(names[0], this);
 player1Name->move(widgetPos, y);

 y += 40;
 QLabel* computerNamesLabel = new QLabel(i18n("The names of your enemies"), this);
 computerNamesLabel->adjustSize();
 computerNamesLabel->move(labelPos, y);

 computerNames = new QComboBox(true, this);
 computerNames->setInsertionPolicy(QComboBox::AtCurrent);
 computerNames->move(widgetPos, y);
 for (int i=1; i < MAX_PLAYERS; i++)
	 computerNames->insertItem(names[i]);


}

QString OptionsDlg::name(int nr)
{
if (computerNames->currentText() != computerNames->text(computerNames->currentItem()))
	computerNames->changeItem(computerNames->currentText(), computerNames->currentItem());
	
 if (nr == 0)
	return player1Name->text();
 if (nr <= computerNames->count())
	 return computerNames->text(nr-1);
 return i18n("Player");
}

int OptionsDlg::getMaxBet()
{
bool ok=true;
int a = maxBet->text().toInt(&ok);
if (!ok)
	return 20;
return a;
}

int OptionsDlg::getMinBet()
{

}

