/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */  

// QT includes
#include<qpopupmenu.h>
#include<qlayout.h>
#include<qpixmap.h>
#include<qkeycode.h>

// KDE includes
#include <kiconloader.h>
#include <kapp.h>
#include <ktmainwindow.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kmessagebox.h>

// own includes
#include "top.h"

#include "kpoker.h"
#include "global.h"
#include "version.h"
#include "defines.h"

PokerWindow::PokerWindow() : KTMainWindow()
{
	_kpok = new kpok(this,0);
	setView( _kpok, FALSE );
	_kpok->show();
	connect(_kpok, SIGNAL(changeLastHand(QString, bool)), this, SLOT(setHand(QString, bool)));
	
	LHLabel = new QLabel(statusBar());
	LHLabel->adjustSize();
	statusBar()->addWidget(LHLabel, 0, true);
	_kpok->updateLHLabel();

	connect(_kpok, SIGNAL(showClickToHold(bool)), this, SLOT(showClickToHold(bool)));

	menu = new KMenuBar(this, "_mainMenu" );
	menu->show();
	
	filePopup = new QPopupMenu(0,"fpopup");
	filePopup->insertItem(i18n("&New game"), ID_NEWGAME);
	filePopup->insertSeparator();
	filePopup->insertItem(i18n("&Save game"), ID_SAVEGAME);
	filePopup->insertSeparator();
	filePopup->connectItem(filePopup->insertItem(i18n("&Quit"), ID_EXIT), this, SLOT(close()));
	connect(filePopup, SIGNAL(activated(int)), _kpok, SLOT(commandCallback(int)));
	connect(filePopup, SIGNAL(activated(int)), this, SLOT(commandCallback(int)));

       	optionsPopup = new QPopupMenu(this, "oppup");
	optionsPopup->insertItem(i18n("&Sound"), ID_SOUND);
	optionsPopup->insertItem(i18n("&Blinking"), ID_BLINKING);
	optionsPopup->insertItem(i18n("&Adjust Bet is default"), ID_ADJUST);

	optionsPopup->setCheckable(true);
	connect(optionsPopup, SIGNAL(activated(int)), _kpok, SLOT(commandCallback(int)));
	connect(optionsPopup, SIGNAL(activated(int)), this, SLOT(commandCallback(int)));

	menu->insertItem(i18n("&File"), filePopup);
	menu->insertItem(i18n("&Options"), optionsPopup);
	
	menu->insertSeparator();
	menu->insertItem(i18n("&Help"), helpMenu(0, false)); // let's use the global about box

	setMenu( menu );

	if (_kpok->initSound()) 
	  optionsPopup->setItemChecked(ID_SOUND, true);
	else 
	  optionsPopup->setItemEnabled(ID_SOUND, false);
	

	conf = kapp->config();
	if (conf != 0) {
		int key = conf->readBoolEntry("Sound", true);
		_kpok->setSound(key);
		optionsPopup->setItemChecked(ID_SOUND, key);

		key = conf->readBoolEntry("Blinking", true);
		_kpok->setBlinking(key);
		optionsPopup->setItemChecked(ID_BLINKING, key);
		
		key = conf->readBoolEntry("Adjust", true);
		_kpok->setAdjust(key);
		optionsPopup->setItemChecked(ID_ADJUST, key);
	} else {
		_kpok->setSound(optionsPopup->isItemChecked(ID_SOUND));
		_kpok->setBlinking(true);
		_kpok->setAdjust(true);
		optionsPopup->setItemChecked(ID_BLINKING, true);
		optionsPopup->setItemChecked(ID_ADJUST, true);
	}
}

PokerWindow::~PokerWindow()
{
 conf->setGroup("General");

 conf->writeEntry("Sound", optionsPopup->isItemChecked(ID_SOUND));
 conf->writeEntry("Blinking", optionsPopup->isItemChecked(ID_BLINKING));
 conf->writeEntry("Adjust", optionsPopup->isItemChecked(ID_ADJUST));


//delete everything -> most handled by KDE and QT
 delete menu;
//? delete _kpok;
}


void PokerWindow::saveProperties(KConfig* conf)
{
  conf->writeEntry("Sound", optionsPopup->isItemChecked(ID_SOUND));
  conf->writeEntry("Blinking", optionsPopup->isItemChecked(ID_BLINKING));
  conf->writeEntry("Adjust", optionsPopup->isItemChecked(ID_ADJUST));
}

void PokerWindow::readProperties(KConfig* conf)
{
/*
  int i;
  if ((i = conf->readNumEntry("cash", -1)) != -1) {
//    _kpok->setCash(i);//broken
  }
  if ((i = conf->readNumEntry("Sound", -1)) != -1) {
    if (i==0) {
      optionsPopup->setItemChecked(ID_SOUND, FALSE);
      _kpok->setSound(0);
    }
    if (i==1) {
      optionsPopup->setItemChecked(ID_SOUND, TRUE);
      _kpok->setSound(1);
    }
  }
*/
}

void PokerWindow::commandCallback(int id)
{
 switch(id){
	case ID_NEWGAME:
	case ID_SAVEGAME:
		break;
	case ID_EXIT:
		close();
		break;
	case ID_SOUND:
	case ID_BLINKING:
	case ID_ADJUST:
 		optionsPopup->setItemChecked(id, !optionsPopup->isItemChecked(id));
		break;
 }
}

bool PokerWindow::queryClose()
{
 switch(KMessageBox::warningYesNoCancel(this, i18n("Do you want to save this game?"))) {
	case KMessageBox::Yes :
		_kpok->saveGame();
		return true;
	case KMessageBox::No :
		return true;
	default :
		return false;
 }
}

void PokerWindow::setHand(QString newHand, bool lastHand)
{
 if (lastHand) 
	LHLabel->setText(i18n("Last hand: ") + newHand);
 else
	LHLabel->setText(i18n("Last winner: ") + newHand);
 LHLabel->adjustSize();
}

void PokerWindow::showClickToHold(bool show)
{
if (show)
	statusBar()->message(i18n("Click a card to hold it"));
else
	statusBar()->clear();
}

