#ifndef __katalog_h
#define __katalog_h

/*
 * katalog.h. Part of the KDE project.
 *
 * Copyright (C) 1999 Waldo Bastian
 *
 */

#include <qstring.h>

#include <kapp.h>
#include <ktmainwindow.h>
#include <kurl.h>

class MainView;
class Catalog;

class Katalog : public KTMainWindow {
  Q_OBJECT
  MainView *mMainView;
public:
  Katalog();
  ~Katalog();

  void loadFile(const KURL & url);
  bool empty();
  bool queryClose();

public slots:
  void slotView(int id);
  void dragEnterEvent( QDragEnterEvent *e );
  void dropEvent( QDropEvent *);
  void slotLoadFile();
  void slotAddImage();
  void slotSaveFile();
  void slotSaveAs();
  void slotCloseFile();
  void slotNewWindow();
  void slotToolbarClicked(int);

protected:
  void updateTM();
  void updateView();

  void saveProperties(KConfig*);
  void readProperties(KConfig*);
  
private:
  enum {TOOLBAR_EXIT, TOOLBAR_OPEN, TOOLBAR_SAVE, TOOLBAR_SAVE_AS, TOOLBAR_CLOSE};

  enum {ID_VIEW_NAME, ID_VIEW_SIZE, ID_VIEW_FILESIZE, ID_VIEW_DESC };

  int mCatalogId;
  int mNewId;
  int mOpenId;
  int mSaveId;
  int mSaveAsId;
  int mCloseId;
  
  QString mLastDir;
  KURL mLocation;
};
#endif
