// -*- c++ -*-

/* modified by jha (j.habenicht@usa.net)
 */

// $Id: kpaint.h,v 1.24 2000/05/09 08:58:37 hoelzer Exp $

#ifndef KPAINT_H
#define KPAINT_H

#include <qwidget.h>
#include <qscrollview.h>
#include <ktmainwindow.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <qrect.h>
#include "canvas.h"
#include "manager.h"
#include "commands.h"


class ColorBar;
class MainView;
class KAction;
class KToggleAction;


class KPaint : public KTMainWindow
{
Q_OBJECT

public:
  KPaint(const char *url_= 0);
  ~KPaint();

  void setPixmap(QPixmap *);

public slots:

  // File
  void fileNew();
  void fileOpen();
  void fileSave();
  void fileSaveAs();
  void newWindow();
  void closeWindow();
  void fileExit();

  // Edit
  void editCopy();
  void editCut();
  void editPaste();
  void editPasteImage();
  void editZoomIn();
  void editZoomOut();
  void editMask();
  void editOptions();
  
  // Image
  void imageInfo();
  void imageResize();
  void imageEditPalette();
  void imageChangeDepth();

  // Tool
  void toolProperties();

  void setTool(int);

  /**
   * Update toolbars/status bars etc.
   */
  void updateControls();
  void updateCommands();

  /**
   * Read the options
   */
  void readOptions();

  /**
   * Write the options
   */
  void writeOptions();

  void enableEditCutCopy(bool);
  void enableEditPaste(bool);

  void dummy();

protected:
  // Load/Save files
  bool loadFile(const KURL& url);
  bool saveFile(QString filename_, QString format_, KURL &url_);

  /**
   * Should we really?
   */
  int exit();

private:
  // Initialisation
  void initMenus();
  void initStatus();
  void addDefaultColors(ColorBar &);

  KAction *copyAction, *cutAction, *pasteAction, *paletteAction, *saveAction,
    *saveAsAction, *maskAction, *pasteImageAction;
  KToggleAction *toolbarAction, *statusbarAction;

  /**
   * Catch close events
   */
  void closeEvent(QCloseEvent *);

  /**
   * Update status item
   */
  void canvasSizeChanged();

  // Info about the currently open image
  QString filename;          // actual local filename
  KURL url;                  // URL it came from
  QString format;            // format to use

  //QString tempURL;
  int zoom;
  bool modified;

  // Command status
  bool allowEditPalette;

  // Tool manager
  Manager *man;

  //GUIManager
  //  QVBoxLayout *vlayout;

  // Child widgets
  QScrollView *v;
  Canvas *c;

  KToolBar *toolsToolbar;
  KToolBar *commandsToolbar;
  KStatusBar *statusbar;
  KMenuBar *menu;
  MainView *mv;

  QPixmap *lmbColor, *rmbColor;
  ColorBar *defaultCb;
};

#endif
