/*-
 * Copyright (c) 2000 Daniel M. Duley mosfet@mandrakesoft.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: main.cpp,v 1.11 2000/05/02 00:22:28 waba Exp $
 */

#include <qfile.h>

#include <kapp.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kurl.h>
#include <kimageio.h>
#include <toplevel.h>
#include <kaboutdata.h>


static const char *description = 
	I18N_NOOP("KDE tool to convert pixmaps to bitmaps (?)");

static const char *version = "v0.0.1";

static KCmdLineOptions options[] =
{
  { "+[file]" , I18N_NOOP("File or URL to open."), 0 },
  { 0, 0, 0 }
};

int main(int argc, char **argv)
{
    KAboutData aboutData( "kpixmap2bitmap", I18N_NOOP("KPixmap2Bitmap"), 
        version, description, KAboutData::License_BSD,
        "(c) 1998-1999, Daniel M. Duley");
    aboutData.addAuthor("Daniel M. Duley",0, "mosfet@kde.org");
    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

    KApplication app;
    KImageIO::registerFormats();
    KPTopLevel *w = new KPTopLevel;
    app.setMainWidget(w);
    w->show();

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    if(args->count())
    {
        QString fname = QFile::decodeName(args->arg(0));
        if(QFile::exists(fname)) // KURL doesn't like unqualified files in
            w->load(fname); // the cwd, I think it thinks it a protocol.
        else{
            KURL url(fname);
            if(url.isLocalFile())
                w->load(url.path());
#warning remote URLs not supported.
        }
    }
    return(app.exec());
}
