#include "ifapp.h"
#include <kimageio.h>
#include <kurl.h>
#include <klocale.h>
#include <qfileinfo.h>
#include <kmessagebox.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include "imagelist.h"

static const char *description = 
	I18N_NOOP("KDE Pixie Image viewer/editor");

static KCmdLineOptions options[] =
{
  { "+[file(s)]", I18N_NOOP("File(s) or URL(s) to open"), 0 },
  { 0, 0, 0 }
};

int main( int argc, char **argv )
{
    KAboutData aboutData( "pixie", I18N_NOOP("Pixie"), 
    "1.0", description, KAboutData::License_BSD,
    "(c) 2000 Daniel Duley <mosfet@kde.org>");

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options );

    KIFApplication app;
    KImageIO::registerFormats();
    KIFImageList *w = new KIFImageList;
    app.setMainWidget(w);

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    for( int i = 0; i < args->count(); i++ ) 
	w->slotAddURL( QFile::decodeName( args->arg(i)) );

    w->slotSetTopItem();
    return(app.exec());
}
