/* $Id: dlgLimits.cpp,v 1.15 2000/04/10 15:07:19 koss Exp $
   $Log: dlgLimits.cpp,v $
   Revision 1.15  2000/04/10 15:07:19  koss
   removed kmenubar position handling ( not needed ).
   various fixes.

   Revision 1.14  2000/03/19 17:53:55  koss
   Fixed KNumInput stuff.

   Revision 1.12  1999/11/18 21:28:04  koss
   Adapted to a new settings policy.
   All settings are kept in class Settings.
   No more passing over / creating QStringLists etc.

   Revision 1.11  1999/11/15 20:14:10  koss
   Search entries moved to dlgSearch.
   Fixed layout again.
   Now we use units in KNumInput and not in separate QLabels.

   Revision 1.9  1999/11/09 18:24:37  koss
   Ported to KDialogBase.
   Fixed layout stuff ( only QListView in dlgDirectories remains ).

   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>

#include <klocale.h>
#include <kdialog.h>

#include "settings.h"
#include "kmainwidget.h"
#include "dlgLimits.h"


DlgLimits::DlgLimits( QWidget *parent )
  : QGroupBox( parent ) {

  setTitle(i18n("Limits Options"));

  QGridLayout *limitsLayout = new QGridLayout( this, 4, 2, 20, KDialog::spacingHint() );

  limitsLayout->addRowSpacing(1,25);

  limitsLayout->setRowStretch(0,5);
  limitsLayout->setRowStretch(1,0);
  limitsLayout->setRowStretch(2,5);
  limitsLayout->setRowStretch(3,5);
    
  limitsLayout->setColStretch(0,5);
  limitsLayout->setColStretch(1,5);

  // opened connection
  lb_maxnum = new QLabel( i18n("Maximum number of opened connections :"), this );
  limitsLayout->addWidget( lb_maxnum, 0, 0 );

  le_maxnum = new KIntNumInput( 0, this, 10 );
  limitsLayout->addWidget( le_maxnum, 0, 1 );

  // minimum bandwidth
  lb_minband = new QLabel( i18n("Minimum network bandwidth :"), this );
  limitsLayout->addWidget( lb_minband, 2, 0 );

  le_minband = new KIntNumInput( 0, this, 10 );
  le_minband->setSuffix( i18n("b / sec") );
  limitsLayout->addWidget( le_minband, 2, 1 );

  // maximum bandwidth
  lb_maxband = new QLabel( i18n("Maximum network bandwidth :"), this );
  limitsLayout->addWidget( lb_maxband, 3, 0 );

  le_maxband = new KIntNumInput( 0, this, 10 );
  le_maxband->setSuffix( i18n("b / sec") );
  limitsLayout->addWidget( le_maxband, 3, 1 );

  // TODO: these are not supported yet, so disable them
  le_maxband->setEnabled( false );
  le_minband->setEnabled( false );
}


void DlgLimits::setData() {
  le_maxnum->setValue( ksettings.maxSimultaneousConnections );
  le_minband->setValue( ksettings.minimumBandwidth );
  le_maxband->setValue( ksettings.maximumBandwidth );
}


void DlgLimits::applyData() {
  ksettings.maxSimultaneousConnections = le_maxnum->value();
  ksettings.minimumBandwidth = le_minband->value();
  ksettings.maximumBandwidth = le_maxband->value();
  kmain->checkQueue();
}

